/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.Entry;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.RBTree;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map<Key, Val>
implements Iterable<Entry<Key, Val>> {
    protected final RBTree<Entry<Key, Val>> tree;
    private final Comparator<Key> comp;

    public <NVal> Map<Key, NVal> transformValues(List.Map<Val, NVal> tr) {
        return Map.create(this.toList().map(new Transformer<NVal>(tr)), this.comp);
    }

    private Map() {
        this(RBTree.create((Comparable[])new Entry[0]), new Entry.CComp());
    }

    private Map(Comparator<Key> c2) {
        this(RBTree.create((Comparable[])new Entry[0]), c2);
    }

    private Map(List<Entry<Key, Val>> l2, Comparator<Key> c2) {
        this(RBTree.create(l2), c2);
    }

    public Map(List<Entry<Key, Val>> l2) {
        this(l2, new Entry.CComp());
    }

    public Map(RBTree<Entry<Key, Val>> t) {
        this(t, new Entry.CComp());
    }

    public static <Key extends Comparable<Key>, Val> Map<Key, Val> create() {
        return new Map<Key, Val>();
    }

    public static <Key, Val> Map<Key, Val> create(Comparator<Key> c2) {
        return new Map<Key, Val>(c2);
    }

    public static <Key extends Comparable<Key>, Val> Map<Key, Val> create(List<Entry<Key, Val>> l2) {
        return new Map<Key, Val>(RBTree.create(l2), new Entry.CComp());
    }

    public static <Key, Val> Map<Key, Val> create(List<Entry<Key, Val>> l2, Comparator<Key> c2) {
        return new Map<Key, Val>(RBTree.create(l2), c2);
    }

    public static <Key extends Comparable<Key>, Val> Map<Key, Val> create(List<Key> ks, List<Val> vs) {
        return Map.create(ks, vs, new Entry.CComp());
    }

    public static <Key, Val> Map<Key, Val> create(List<Key> ks, List<Val> vs, Comparator<Key> c2) {
        return Map.create(ks.zip(new Zipper(c2), vs), c2);
    }

    public static <Key, Val> Map<Key, Val> hashMap() {
        return new Map(new HashComp());
    }

    public static <Key, Val> Map<Key, Val> hashMap(List<Entry<Key, Val>> l2) {
        return new Map<Key, Val>(l2, new HashComp());
    }

    public static <Key, Val> Map<Key, Val> hashMap(List<Key> ks, List<Val> vs) {
        return Map.create(ks, vs, new HashComp());
    }

    public static <Key, Val> Map<Key, Val> hashMap(java.util.Map<Key, Val> hash) {
        Map<Key, Val> m = Map.hashMap();
        for (Map.Entry<Key, Val> ent : hash.entrySet()) {
            m = m.put(ent.getKey(), ent.getValue());
        }
        return m;
    }

    private Map(RBTree<Entry<Key, Val>> t, Comparator<Key> c2) {
        this.tree = t;
        this.comp = c2;
    }

    private Map<Key, Val> make(RBTree<Entry<Key, Val>> t) {
        return new Map<Key, Val>(t, this.comp);
    }

    public int size() {
        return this.tree.size();
    }

    public boolean containsKey(Key k) {
        return this.tree.contains(Entry.create(k, null, this.comp));
    }

    public boolean isEmpty() {
        return this.tree.isLeaf();
    }

    public Map<Key, Val> put(Key k, Val v2) {
        return this.make(this.tree.insert(Entry.create(k, v2, this.comp)));
    }

    public Map<Key, Val> remap(Key k, Val v2) {
        Entry<Key, Val> e2 = Entry.create(k, v2, this.comp);
        return this.make(!this.containsKey(k) ? this.tree.insert(e2) : this.tree.replace(e2));
    }

    public Val get(Key k) {
        return this.tree.find(Entry.create(k, null, this.comp)).val;
    }

    public Map<Key, Val> remove(Key k) {
        return this.make(this.tree.remove(Entry.create(k, null, this.comp)));
    }

    public Map<Key, Val> merge(Map<Key, Val> s2) {
        return this.make(this.tree.insertAll(s2.tree));
    }

    public Map<Key, Val> merge(Map<Key, Val> s2, Merge<Val> m) {
        return this.make(s2.toList().fold(new Merger(m), this.tree));
    }

    public Map<Key, Val> merge(Key k, Val v2, Merge<Val> m) {
        Entry<Key, Val> e2 = Entry.create(k, v2, this.comp);
        if (!this.tree.contains(e2)) {
            return this.make(this.tree.insert(e2));
        }
        return this.make(this.tree.replace(Entry.create(e2.key, m.merge(v2, this.tree.find(e2).val), this.comp)));
    }

    public List<Key> keys() {
        return this.toList().map(new Keyer());
    }

    public List<Val> values() {
        return this.toList().map(new Valer());
    }

    public List<Entry<Key, Val>> toList() {
        return this.tree.toList();
    }

    @Override
    public Iterator<Entry<Key, Val>> iterator() {
        return this.toList().iterator();
    }

    public String toString() {
        return "[ " + this.toList().toString(" ", "") + " ]";
    }

    public String toTreeString() {
        return "[ " + this.tree + " ]";
    }

    public java.util.Map<Key, Val> toJavaMap() {
        HashMap<Key, Val> m = new HashMap<Key, Val>();
        for (Entry<Key, Val> e2 : this) {
            m.put(e2.getKey(), e2.getVal());
        }
        return m;
    }

    public int hashCode() {
        return 3 * this.tree.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map oo = (Map)o;
        return this.tree.size() == oo.size() && this.tree.toList().equals(oo.tree.toList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashComp<Key>
    implements Comparator<Key> {
        HashComp() {
        }

        @Override
        public int compare(Key k1, Key k2) {
            return k1.hashCode() - k2.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Keyer
    extends List.Map<Entry<Key, Val>, Key> {
        Keyer() {
        }

        @Override
        public Key map(Entry<Key, Val> e2) {
            return e2.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Merge<Val> {
        public abstract Val merge(Val var1, Val var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Merger
    extends List.Fold<Entry<Key, Val>, RBTree<Entry<Key, Val>>> {
        Merge<Val> m;

        Merger(Merge<Val> mm) {
            this.m = mm;
        }

        @Override
        public RBTree<Entry<Key, Val>> fold(Entry<Key, Val> e2, RBTree<Entry<Key, Val>> t) {
            if (!t.contains(e2)) {
                return t.insert(e2);
            }
            return t.replace(Entry.create(e2.key, this.m.merge(e2.val, t.find(e2).val), Map.this.comp));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Transform<X, Y> {
        public abstract Y transform(X var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Transformer<NV>
    extends List.Map<Entry<Key, Val>, Entry<Key, NV>> {
        List.Map<Val, NV> tr;

        Transformer(List.Map<Val, NV> trr) {
            this.tr = trr;
        }

        @Override
        public Entry<Key, NV> map(Entry<Key, Val> e2) {
            return Entry.create(e2.key, this.tr.map(e2.val), Map.this.comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Valer
    extends List.Map<Entry<Key, Val>, Val> {
        Valer() {
        }

        @Override
        public Val map(Entry<Key, Val> e2) {
            return e2.getVal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Zipper<K, V>
    extends List.Zip<K, V, Entry<K, V>> {
        Comparator<K> c;

        Zipper(Comparator<K> cc) {
            this.c = cc;
        }

        @Override
        public Entry<K, V> zip(K k, V v2) {
            return Entry.create(k, v2, this.c);
        }
    }

    public static class tree
    extends Fields.any {
    }
}

