/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.Entry;
import edu.neu.ccs.demeterf.lib.List;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMap<Key, Val>
implements Iterable<Entry<Key, Val>> {
    protected final List<Entry<Key, Val>> list;
    private final Comparator<Key> comp;

    public <NVal> ListMap<Key, NVal> transformValues(List.Map<Val, NVal> tr) {
        return ListMap.create(this.toList().map(new Transformer<NVal>(tr)), this.comp);
    }

    private ListMap() {
        this(List.create(), new Entry.CComp());
    }

    private ListMap(Comparator<Key> c2) {
        this(List.create(), c2);
    }

    private ListMap(Comparator<Key> c2, List<Entry<Key, Val>> l2) {
        this.list = l2;
        this.comp = c2;
    }

    public ListMap(List<Entry<Key, Val>> l2) {
        this(l2, new Entry.CComp());
    }

    public ListMap(List<Entry<Key, Val>> l2, Comparator<Key> c2) {
        this(c2, l2.removeDuplicates(new Entry.EComp(c2)).sort(new Entry.LComp(c2)));
    }

    public static <Key extends Comparable<Key>, Val> ListMap<Key, Val> create() {
        return new ListMap<Key, Val>();
    }

    public static <Key, Val> ListMap<Key, Val> create(Comparator<Key> c2) {
        return new ListMap<Key, Val>(c2);
    }

    public static <Key, Val> ListMap<Key, Val> create(List<Entry<Key, Val>> l2, Comparator<Key> c2) {
        return new ListMap<Key, Val>(l2, c2);
    }

    public static <Key extends Comparable<Key>, Val> ListMap<Key, Val> create(List<Entry<Key, Val>> es) {
        return ListMap.create(es, new Entry.CComp());
    }

    public static <Key extends Comparable<Key>, Val> ListMap<Key, Val> create(List<Key> ks, List<Val> vs) {
        return ListMap.create(ks, vs, new Entry.CComp());
    }

    public static <Key, Val> ListMap<Key, Val> create(List<Key> ks, List<Val> vs, Comparator<Key> c2) {
        return ListMap.create(ks.zip(new Zipper(c2), vs), c2);
    }

    public static <Key, Val> ListMap<Key, Val> hashMap() {
        return new ListMap(new HashComp());
    }

    public static <Key, Val> ListMap<Key, Val> hashMap(List<Entry<Key, Val>> l2) {
        return new ListMap<Key, Val>(l2, new HashComp());
    }

    public static <Key, Val> ListMap<Key, Val> hashMap(List<Key> ks, List<Val> vs) {
        return ListMap.create(ks, vs, new HashComp());
    }

    public static <Key, Val> ListMap<Key, Val> hashMap(Map<Key, Val> hash) {
        ListMap<Key, Val> m = ListMap.hashMap();
        for (Map.Entry<Key, Val> ent : hash.entrySet()) {
            m = m.put(ent.getKey(), ent.getValue());
        }
        return m;
    }

    private ListMap<Key, Val> make(List<Entry<Key, Val>> l2) {
        return new ListMap<Key, Val>(l2, this.comp);
    }

    public int size() {
        return this.list.length();
    }

    public boolean containsKey(Key k) {
        return this.list.contains(new Entry.KPred(k, this.comp));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public ListMap<Key, Val> put(Key k, Val v2) {
        if (this.list.contains(new Entry.KPred(k, this.comp))) {
            return this;
        }
        return this.make(this.list.insert(Entry.create(k, v2, this.comp), new Entry.LComp(this.comp)));
    }

    public ListMap<Key, Val> remap(Key k, Val v2) {
        Entry<Key, Val> e2 = Entry.create(k, v2, this.comp);
        return this.make(!this.containsKey(k) ? this.list.insert(e2, new Entry.LComp(this.comp)) : this.list.replace(new Entry.KPred(e2.getKey(), this.comp), e2));
    }

    public Val get(Key k) {
        return this.list.find(new Entry.KPred<Key, V>(k, this.comp)).val;
    }

    public ListMap<Key, Val> remove(Key k) {
        return this.make(this.list.remove(new Entry.KPred(k, this.comp)));
    }

    public ListMap<Key, Val> merge(ListMap<Key, Val> s2) {
        return this.make(this.list.insert((Entry<Key, Val>)((Object)s2.list.filter(new InList(this.list))), (List.Comp<Entry<Key, Val>>)new Entry.LComp(this.comp)));
    }

    public ListMap<Key, Val> merge(ListMap<Key, Val> s2, Merge<Val> m) {
        return this.make(s2.list.fold(new Merger(m), this.list));
    }

    public ListMap<Key, Val> merge(Key k, Val v2, Merge<Val> m) {
        Entry<Key, Val> e2 = Entry.create(k, v2, this.comp);
        if (!this.containsKey(e2.getKey())) {
            return this.make(this.list.insert(e2, new Entry.LComp(this.comp)));
        }
        return this.make(this.list.replace(new Entry.KPred(e2.getKey(), this.comp), Entry.create(e2.key, m.merge(v2, this.list.find(new Entry.KPred(e2.getKey(), this.comp)).getVal()), this.comp)));
    }

    public List<Key> keys() {
        return this.toList().map(new Keyer());
    }

    public List<Val> values() {
        return this.toList().map(new Valer());
    }

    public List<Entry<Key, Val>> toList() {
        return this.list;
    }

    @Override
    public Iterator<Entry<Key, Val>> iterator() {
        return this.toList().iterator();
    }

    public String toString() {
        return "[ " + this.toList().toString(" ", "") + " ]";
    }

    public Map<Key, Val> toJavaMap() {
        HashMap<Key, Val> m = new HashMap<Key, Val>();
        for (Entry<Key, Val> e2 : this) {
            m.put(e2.getKey(), e2.getVal());
        }
        return m;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ListMap)) {
            return false;
        }
        ListMap oo = (ListMap)o;
        return this.list.length() == oo.list.length() && this.list.equals(oo.list);
    }

    public int hashCode() {
        return 3 * this.list.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashComp<Key>
    implements Comparator<Key> {
        HashComp() {
        }

        @Override
        public int compare(Key k1, Key k2) {
            return k1.hashCode() - k2.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InList
    extends List.Pred<Entry<Key, Val>> {
        List<Entry<Key, Val>> l;

        InList(List<Entry<Key, Val>> ll) {
            this.l = ll;
        }

        @Override
        public boolean huh(Entry<Key, Val> e2) {
            return this.l.contains(new Entry.KPred(e2.getKey(), ListMap.this.comp));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Keyer
    extends List.Map<Entry<Key, Val>, Key> {
        Keyer() {
        }

        @Override
        public Key map(Entry<Key, Val> e2) {
            return e2.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Merge<Val> {
        public abstract Val merge(Val var1, Val var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Merger
    extends List.Fold<Entry<Key, Val>, List<Entry<Key, Val>>> {
        Merge<Val> m;

        Merger(Merge<Val> mm) {
            this.m = mm;
        }

        @Override
        public List<Entry<Key, Val>> fold(Entry<Key, Val> e2, List<Entry<Key, Val>> l2) {
            if (!l2.contains(new Entry.KPred(e2.getKey(), ListMap.this.comp))) {
                return l2.insert(e2, new Entry.LComp(ListMap.this.comp));
            }
            return l2.replace(new Entry.KPred(e2.getKey(), ListMap.this.comp), Entry.create(e2.getKey(), this.m.merge(e2.val, l2.find(new Entry.KPred(e2.getKey(), ListMap.this.comp)).getVal()), ListMap.this.comp));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Transform<X, Y> {
        public abstract Y transform(X var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Transformer<NV>
    extends List.Map<Entry<Key, Val>, Entry<Key, NV>> {
        List.Map<Val, NV> tr;

        Transformer(List.Map<Val, NV> trr) {
            this.tr = trr;
        }

        @Override
        public Entry<Key, NV> map(Entry<Key, Val> e2) {
            return Entry.create(e2.key, this.tr.map(e2.val), ListMap.this.comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Valer
    extends List.Map<Entry<Key, Val>, Val> {
        Valer() {
        }

        @Override
        public Val map(Entry<Key, Val> e2) {
            return e2.getVal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Zipper<K, V>
    extends List.Zip<K, V, Entry<K, V>> {
        Comparator<K> c;

        Zipper(Comparator<K> cc) {
            this.c = cc;
        }

        @Override
        public Entry<K, V> zip(K k, V v2) {
            return Entry.create(k, v2, this.c);
        }
    }

    public static class list
    extends Fields.any {
    }
}

