/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.RE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class List<X>
implements Iterable<X> {
    private final int len;

    public static void main(String[] args2) {
        List<Integer> lst = List.buildlist(new TestB(), 3000);
        TestC c2 = new TestC();
        long st = System.currentTimeMillis();
        int i = 0;
        while (i < 20) {
            super.mergeSort(c2);
            ++i;
        }
        System.out.println("  Merge: " + (System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        i = 0;
        while (i < 20) {
            lst.sort(c2);
            ++i;
        }
        System.out.println(" Insert: " + (System.currentTimeMillis() - st));
    }

    public static <X> List<X> create() {
        return new Empty();
    }

    public static <X> List<X> create(X ... xa) {
        return List.create(xa, 0);
    }

    public static <X> List<X> create(X[] xa, int i) {
        List<X> res2 = List.create();
        while (i < xa.length) {
            res2 = res2.push(xa[i]);
            ++i;
        }
        return res2.reverse();
    }

    public static <X> List<X> create(Iterable<X> xs) {
        List<X> res2 = List.create();
        for (X x2 : xs) {
            res2 = res2.push(x2);
        }
        return res2.reverse();
    }

    public List(int l2) {
        this.len = l2;
    }

    public List<X> push(X x2) {
        return new Cons<X>(x2, this);
    }

    public List<X> push(List<X> xs) {
        return xs.append(this);
    }

    public List<X> reverse() {
        return this.reverse(this.length());
    }

    public List<X> reverse(int i) {
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty() && i-- > 0) {
            X x2 = back.top();
            back = back.pop();
            front = front.push(x2);
        }
        return front;
    }

    public String toString() {
        return this.toString(" ", "");
    }

    public int index(X x2) {
        return this.index(new EqualComp().curry(x2));
    }

    public int index(Pred<X> p) {
        int i = 0;
        for (X x2 : this) {
            if (p.huh(x2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean same(List<X> l2) {
        return this.containsAll(l2) && l2.containsAll(this);
    }

    public boolean same(List<X> l2, Comp<X> c2) {
        return this.sameG(l2, c2);
    }

    public <Y> boolean sameG(List<Y> l2, GComp<X, Y> c2) {
        return this.containsAllG(l2, c2) && l2.containsAllG(this, c2.flip());
    }

    public List<X> pop(int k) {
        return k == 0 ? this : this.pop().pop(k - 1);
    }

    public List<X> append(List<X> l2) {
        List<X> rev = this.reverse();
        return super.revpush(rev);
    }

    public List<X> append(X x2) {
        return this.append((X)List.create(x2));
    }

    public abstract X top();

    public abstract List<X> pop();

    public abstract boolean isEmpty();

    public boolean ormap(Pred<X> p) {
        for (X x2 : this) {
            if (!p.huh(x2)) continue;
            return true;
        }
        return false;
    }

    public boolean andmap(Pred<X> p) {
        return !this.ormap(p.negate());
    }

    public boolean contains(X x2) {
        return this.contains(new EqualComp().curry(x2));
    }

    public boolean contains(Pred<X> p) {
        return this.ormap(p);
    }

    public <Y> boolean containsG(Y y, GComp<X, Y> c2) {
        return this.contains(c2.curry(y));
    }

    public boolean containsAny(List<X> l2) {
        return this.containsAny(l2, new EqualComp());
    }

    public boolean containsAny(List<X> l2, Comp<X> c2) {
        return this.ormap(new AnyP(l2, c2));
    }

    public <Y> boolean containsAnyG(List<Y> l2, GComp<X, Y> c2) {
        return this.ormap(new AnyP<X, Y>(l2, c2));
    }

    public boolean containsAll(List<X> l2) {
        return this.containsAll(l2, new EqualComp());
    }

    public boolean containsAll(List<X> l2, Comp<X> c2) {
        return l2.andmap(new AnyP(this, c2));
    }

    public <Y> boolean containsAllG(List<Y> l2, GComp<X, Y> c2) {
        return l2.andmap(new AnyP<Y, X>(this, c2.flip()));
    }

    public X find(X x2) {
        return this.find(new EqualComp().curry(x2));
    }

    public X find(Pred<X> p) {
        for (X x2 : this) {
            if (!p.huh(x2)) continue;
            return x2;
        }
        throw new RE("No Match Found: " + p);
    }

    public <Y> X findG(Y y, GComp<X, Y> c2) {
        return this.find(c2.curry(y));
    }

    public List<X> remove(X x2) {
        return this.remove(new EqualComp().curry(x2));
    }

    public <Y> List<X> removeG(Y y, GComp<X, Y> c2) {
        return this.remove(c2.curry(y));
    }

    private List<X> revpush(List<X> l2) {
        List<X> ret2 = this;
        for (X x2 : l2) {
            ret2 = ret2.push(x2);
        }
        return ret2;
    }

    public List<X> remove(Pred<X> p) {
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            back = back.pop();
            if (p.huh(x2)) {
                return super.revpush(front);
            }
            front = front.push(x2);
        }
        return front.reverse();
    }

    public int length() {
        return this.len;
    }

    public X lookup(int i) {
        List<X> l2 = this;
        while (i-- > 0) {
            l2 = l2.pop();
        }
        return l2.top();
    }

    public String toString(String sep, String pre) {
        String ret2 = "";
        boolean first2 = true;
        for (X x2 : this) {
            if (!first2) {
                ret2 = String.valueOf(ret2) + sep;
            } else {
                first2 = false;
            }
            ret2 = String.valueOf(ret2) + pre + x2;
        }
        return ret2;
    }

    public String toString(Stringer<X> s2) {
        String ret2 = "";
        List<X> lst = this;
        while (!lst.isEmpty()) {
            ret2 = String.valueOf(ret2) + s2.toString(lst.top(), lst.pop());
            lst = lst.pop();
        }
        return ret2;
    }

    public List<X> filterout(X x2) {
        return this.filterout(new EqualComp().curry(x2));
    }

    public List<X> filterout(Pred<X> p) {
        return this.filter(p.negate());
    }

    public List<X> filter(X x2) {
        return this.filter(new EqualComp().curry(x2));
    }

    public List<X> filter(Pred<X> p) {
        List<X> keep = List.create();
        for (X x2 : this) {
            if (!p.huh(x2)) continue;
            keep = keep.push(x2);
        }
        return keep.reverse();
    }

    public int count(Pred<X> p) {
        int c2 = 0;
        for (X x2 : this) {
            if (!p.huh(x2)) continue;
            ++c2;
        }
        return c2;
    }

    public List<X> removeDuplicates() {
        return this.removeDuplicates(new EqualComp());
    }

    public List<X> removeDuplicates(Comp<X> c2) {
        return this.fold(new RMDup<X>(c2), List.<X>create());
    }

    public <Y> Y fold(Fold<X, Y> f, Y b) {
        return this.foldl(f, b);
    }

    public <Y> Y foldl(Fold<X, Y> f, Y b) {
        for (X x2 : this) {
            b = f.fold(x2, b);
        }
        return b;
    }

    public <Y> Y foldr(Fold<X, Y> f, Y b) {
        return this.reverse().foldl(f, b);
    }

    public <Y> List<Y> map(Map<X, Y> m) {
        List<Y> ret2 = List.create();
        for (X x2 : this.reverse()) {
            ret2 = ret2.push(m.map(x2));
        }
        return ret2;
    }

    public List<X> add(X a, int i) {
        int j = i;
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            back = back.pop();
            if (i-- == 0) {
                return super.revpush(front);
            }
            front = front.push(x2);
        }
        if (i == 0) {
            return front.push(a).reverse();
        }
        throw new RE("Bad Add Index: " + j);
    }

    public List<X> remove(int i) {
        int j = i;
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            back = back.pop();
            if (i-- == 0) {
                return super.revpush(front);
            }
            front = front.push(x2);
        }
        throw new RE("Bad Remove Index: " + j);
    }

    public List<X> insert(Iterable<X> xs, Comp<X> c2) {
        List ths = this;
        for (X x2 : xs) {
            ths.insert(x2, c2);
        }
        return ths;
    }

    public List<X> insert(X a, Comp<X> c2) {
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            if (c2.comp(a, x2)) {
                return super.revpush(front);
            }
            back = back.pop();
            front = front.push(x2);
        }
        return front.push(a).reverse();
    }

    public List<X> sort(Comp<X> c2) {
        return this.mergeSort(c2);
    }

    public List<X> insertionSort(Comp<X> c2) {
        List<X> srt = List.create();
        for (X x2 : this) {
            srt = srt.insert(x2, c2);
        }
        return srt;
    }

    public X[] toArray(X[] arr) {
        int i = 0;
        for (X x2 : this) {
            arr[i++] = x2;
        }
        return arr;
    }

    @Override
    public Iterator<X> iterator() {
        return new ListIterator(this);
    }

    public <Y, Z> List<Z> zip(Zip<X, Y, Z> z, List<Y> ys) {
        List<Z> zs = List.create();
        List<X> xs = this;
        while (!xs.isEmpty() && !ys.isEmpty()) {
            zs = zs.push(z.zip(xs.top(), ys.top()));
            xs = xs.pop();
            ys = ys.pop();
        }
        return zs.reverse();
    }

    public static <X> List<X> buildlist(Build<X> b, int len) {
        List<X> lst = List.create();
        while (len-- > 0) {
            lst = lst.push(b.build(len));
        }
        return lst;
    }

    public List<X> replace(int i, X s2) {
        int j = i;
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            back = back.pop();
            if (i-- == 0) {
                return super.revpush(front);
            }
            front = front.push(x2);
        }
        throw new RE("Bad Replace Index: " + j);
    }

    public List<X> replace(X t, X s2) {
        return this.replace(new EqualComp().curry(t), s2);
    }

    public List<X> replace(Pred<X> p, X s2) {
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X x2 = back.top();
            back = back.pop();
            if (p.huh(x2)) {
                return super.revpush(front);
            }
            front = front.push(x2);
        }
        throw new RE("Bad Replace: " + p);
    }

    public List<X> replaceAll(X t, X s2) {
        return this.replaceAll(new EqualComp().curry(t), s2);
    }

    public List<X> replaceAll(Pred<X> p, X x2) {
        List<X> front = List.create();
        List<X> back = this;
        while (!back.isEmpty()) {
            X xx = back.top();
            back = back.pop();
            front = front.push(p.huh(xx) ? x2 : xx);
        }
        return front.reverse();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private FB<X> frontBack(int i) {
        List<X> front = List.create();
        List<X> back = this;
        while (i-- > 0 && !back.isEmpty()) {
            front = front.push(back.top());
            back = back.pop();
        }
        return new FB<X>(front, back);
    }

    private static <X> List<X> merge(List<X> a, List<X> b, Comp<X> c2) {
        List<X> ret2 = List.create();
        for (X x2 : a) {
            while (!b.isEmpty() && c2.comp(b.top(), x2)) {
                ret2 = ret2.push(b.top());
                b = b.pop();
            }
            ret2 = ret2.push(x2);
        }
        for (X x2 : b) {
            ret2 = ret2.push(x2);
        }
        return ret2.reverse();
    }

    private List<X> mergeSort(Comp<X> c2) {
        if (this.length() < 2) {
            return this;
        }
        FB<X> fb = this.frontBack(this.length() / 2);
        return List.merge(super.mergeSort(c2), super.mergeSort(c2), c2);
    }

    public java.util.List<X> toJavaList() {
        ArrayList<X> l2 = new ArrayList<X>();
        for (X x2 : this) {
            l2.add(x2);
        }
        return l2;
    }

    public List<X> sublist(int i, int k) {
        if (this.length() < i) {
            return List.create();
        }
        if (this.length() < i + k) {
            return this.pop(i);
        }
        return this.pop(i).reverse(k).reverse();
    }

    public List<X> take(int k) {
        return this.reverse(k).reverse();
    }

    public List<X> drop(int k) {
        return this.pop(k);
    }

    public List<X> takeWhile(Pred<X> p) {
        List<X> lst = this;
        List<X> ret2 = List.create();
        while (!lst.isEmpty() && p.huh(lst.top())) {
            ret2.push(lst.top());
            lst = lst.pop();
        }
        return ret2.reverse();
    }

    public List<X> dropWhile(Pred<X> p) {
        List<X> lst = this;
        while (!lst.isEmpty() && p.huh(lst.top())) {
            lst = lst.pop();
        }
        return lst;
    }

    public List<X> shuffle() {
        List<X> lst = List.create();
        for (X x2 : this) {
            lst = lst.add(x2, (int)(Math.random() * (double)(lst.length() + 1)));
        }
        return lst;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnyP<X, Y>
    extends Pred<X> {
        List<Y> l;
        GComp<X, Y> c;

        public AnyP(List<Y> ll, GComp<X, Y> cc) {
            this.l = ll;
            this.c = cc;
        }

        @Override
        public boolean huh(X x2) {
            return this.l.contains(this.c.revCurry(x2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Build<X> {
        public abstract X build(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Comp<X>
    extends GComp<X, X> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EqualComp
    extends Comp<X> {
        private EqualComp() {
        }

        @Override
        public boolean comp(X x2, X y) {
            return x2.equals(y);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FB<X> {
        List<X> front;
        List<X> back;

        FB(List<X> f, List<X> b) {
            this.front = f;
            this.back = b;
        }

        public String toString() {
            return this.front + "::" + this.back;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Fold<X, Y> {
        public abstract Y fold(X var1, Y var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GComp<X, Y> {
        private GComp<X, Y> that;

        public abstract boolean comp(X var1, Y var2);

        public GComp<Y, X> flip() {
            return new Flip(this);
        }

        public Pred<X> curry(Y y) {
            return new Curry(this, y);
        }

        public Pred<Y> revCurry(X x2) {
            return new RCurry(this, x2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Curry<X, Y>
        extends Pred<X> {
            Y y;
            GComp<X, Y> c;

            Curry(GComp<X, Y> cc, Y yy) {
                this.c = cc;
                this.y = yy;
            }

            @Override
            public boolean huh(X x2) {
                return this.c.comp(x2, this.y);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Flip
        extends GComp<Y, X> {
            GComp<X, Y> par;

            Flip(GComp<X, Y> p) {
                this.par = p;
            }

            @Override
            public boolean comp(Y y, X x2) {
                return this.par.comp(x2, y);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RCurry<X, Y>
        extends Pred<Y> {
            X x;
            GComp<X, Y> c;

            RCurry(GComp<X, Y> cc, X xx) {
                this.c = cc;
                this.x = xx;
            }

            @Override
            public boolean huh(Y y) {
                return this.c.comp(this.x, y);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListIterator<X>
    implements Iterator<X> {
        List<X> inner;

        ListIterator(List<X> i) {
            this.inner = i;
        }

        @Override
        public boolean hasNext() {
            return !this.inner.isEmpty();
        }

        @Override
        public X next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next()");
            }
            X t = this.inner.top();
            this.inner = this.inner.pop();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Map<X, Y> {
        public abstract Y map(X var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Pred<X> {
        public abstract boolean huh(X var1);

        public Pred<X> negate() {
            return new Negate(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Negate<X>
        extends Pred<X> {
            Pred<X> p;

            Negate(Pred<X> pp) {
                this.p = pp;
            }

            @Override
            public boolean huh(X x2) {
                return !this.p.huh(x2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RMDup<X>
    extends Fold<X, List<X>> {
        Comp<X> c;

        RMDup(Comp<X> cc) {
            this.c = cc;
        }

        @Override
        public List<X> fold(X x2, List<X> l2) {
            if (l2.contains(this.c.curry(x2))) {
                return l2;
            }
            return l2.push(x2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Stringer<X> {
        public abstract String toString(X var1, List<X> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestB
    extends Build<Integer> {
        TestB() {
        }

        @Override
        public Integer build(int i) {
            return (int)(Math.random() * 100.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestC
    extends Comp<Integer> {
        TestC() {
        }

        @Override
        public boolean comp(Integer i, Integer j) {
            return i < j;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Zip<X, Y, Z> {
        public abstract Z zip(X var1, Y var2);
    }
}

