/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.NESepList;
import edu.neu.ccs.demeterf.lib.PESepList;
import edu.neu.ccs.demeterf.lib.SepList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsS<Syn, X>
implements PESepList<Syn, X> {
    protected final Syn syntax;
    protected final X first;
    protected final PESepList<Syn, X> rest;

    public ConsS(Syn syntax2, X first2, PESepList<Syn, X> rest2) {
        this.syntax = syntax2;
        this.first = first2;
        this.rest = rest2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConsS)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ConsS oo = (ConsS)o;
        return this.syntax.equals(oo.syntax) && this.first.equals(oo.first) && this.rest.equals(oo.rest);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public X top() {
        return this.first;
    }

    @Override
    public PESepList<Syn, X> pop() {
        return this.rest;
    }

    @Override
    public boolean hasSyntax() {
        return true;
    }

    @Override
    public Syn topSyntax() {
        return this.syntax;
    }

    @Override
    public SepList<Syn, X> reverse(SepList<Syn, X> acc, Syn s2) {
        return this.rest.reverse(acc.push(this.first, this.syntax), this.syntax);
    }

    @Override
    public SepList<Syn, X> toSepList() {
        return new NESepList<Syn, X>(this.first, this.rest);
    }

    @Override
    public List<X> toList() {
        return this.rest.toList().push(this.first);
    }

    @Override
    public int length() {
        return 1 + this.rest.length();
    }

    @Override
    public X lookup(int i) {
        return i == 0 ? this.first : this.rest.lookup(i - 1);
    }

    @Override
    public String toString() {
        return this.syntax + " " + this.first + this.rest;
    }

    @Override
    public <Y> Y foldl(SepList.Fold<Syn, X, Y> f, Y b) {
        PESepList<Syn, X> r2 = this;
        while (!r2.isEmpty()) {
            b = f.fold(r2.topSyntax(), r2.top(), b);
            r2 = r2.pop();
        }
        return b;
    }

    public static class first
    extends Fields.any {
    }

    public static class rest
    extends Fields.any {
    }

    public static class syntax
    extends Fields.any {
    }
}

