/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lexer.classes;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lexer.classes.Label;
import edu.neu.ccs.demeterf.lexer.classes.ParseException;
import edu.neu.ccs.demeterf.lexer.classes.PrintToString;
import edu.neu.ccs.demeterf.lexer.classes.State;
import edu.neu.ccs.demeterf.lexer.classes.TheParser;
import edu.neu.ccs.demeterf.lexer.classes.Trans;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Set;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFA {
    protected final State start;
    protected final State fin;
    protected final List<Trans> trans;

    public NFA(State start2, State fin2, List<Trans> trans2) {
        this.start = start2;
        this.fin = fin2;
        this.trans = trans2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NFA)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        NFA oo = (NFA)o;
        return ((Object)this.start).equals(oo.start) && ((Object)this.fin).equals(oo.fin) && ((Object)this.trans).equals(oo.trans);
    }

    public static NFA parse(String inpt) throws ParseException {
        return new TheParser(new StringReader(inpt)).parse_NFA();
    }

    public static NFA parse(InputStream inpt) throws ParseException {
        return new TheParser(inpt).parse_NFA();
    }

    public static NFA parse(Reader inpt) throws ParseException {
        return new TheParser(inpt).parse_NFA();
    }

    public static NFA empty() {
        State s2 = State.fresh();
        State f = State.fresh();
        return new NFA(s2, f, List.<Trans>create());
    }

    public static NFA concat(List<NFA> nfas) {
        return nfas.foldr(new List.Fold<NFA, NFA>(){

            @Override
            public NFA fold(NFA f, NFA r2) {
                return f.concat(r2);
            }
        }, NFA.empty());
    }

    public NFA concat(NFA nfa) {
        if (nfa.trans.isEmpty()) {
            return this;
        }
        List<Trans> ts = NFA.replace(this.trans, this.fin, nfa.start);
        return new NFA(this.fin.equals(this.start) ? nfa.start : this.start, nfa.fin, ts.append((Trans)((Object)nfa.trans)));
    }

    static List<Trans> replace(List<Trans> ts, final State old, final State nw) {
        return ts.map(new List.Map<Trans, Trans>(){

            @Override
            public Trans map(Trans t) {
                State frm2 = t.getFrm().equals(old) ? nw : t.getFrm();
                State to2 = t.getTo().equals(old) ? nw : t.getTo();
                return new Trans(t.getL(), frm2, to2);
            }
        });
    }

    public static NFA or(List<NFA> nfas) {
        return nfas.fold(new List.Fold<NFA, NFA>(){

            @Override
            public NFA fold(NFA f, NFA r2) {
                return r2.or(f);
            }
        }, NFA.empty());
    }

    public NFA or(NFA nfa) {
        return new NFA(this.start, this.fin, this.trans.append((Trans)((Object)NFA.replace(NFA.replace(nfa.trans, nfa.start, this.start), nfa.fin, this.fin))));
    }

    public NFA rawOr(NFA nfa) {
        return new NFA(this.start, this.fin, this.trans.append((Trans)((Object)NFA.replace(nfa.trans, nfa.start, this.start))));
    }

    public NFA addTrans(Label l2, State s2, State f) {
        return new NFA(this.start, this.fin, this.trans.push(new Trans(l2, s2, f)));
    }

    public NFA addTrans(Label l2) {
        return new NFA(this.start, this.fin, this.trans.push(new Trans(l2, this.start, this.fin)));
    }

    public NFA star() {
        return new NFA(this.start, this.start, NFA.replace(this.trans, this.fin, this.start));
    }

    public NFA huh() {
        return this.addTrans(Trans.EPSILON, this.start, this.fin);
    }

    public NFA rmdups() {
        return new NFA(this.start, this.fin, this.trans.removeDuplicates());
    }

    public Set<State> DFAEdge(Set<State> s2, char c2, List<Trans> eps) {
        return NFA.closure(NFA.nextStates(this.trans, s2, c2), eps);
    }

    public List<Trans> epsilons() {
        return this.trans.filter(new List.Pred<Trans>(){

            @Override
            public boolean huh(Trans t) {
                return t.getL().isEpsilon();
            }
        });
    }

    public static Set<State> closure(Set<State> start2, List<Trans> eps) {
        Set<State> next = start2.union(NFA.nextStates(eps, start2, -1));
        if (next.size() == start2.size()) {
            return start2;
        }
        return NFA.closure(next, eps);
    }

    static Set<State> nextStates(List<Trans> ts, final Set<State> s2, final int c2) {
        return ts.fold(new List.Fold<Trans, Set<State>>(){

            @Override
            public Set<State> fold(Trans t, Set<State> r2) {
                if (s2.contains(t.getFrm()) && (c2 < 0 || t.getL().contains((char)c2))) {
                    return r2.add(t.getTo());
                }
                return r2;
            }
        }, Set.create());
    }

    public String toString() {
        return PrintToString.PrintToStringM(this);
    }

    public List<Trans> getTrans() {
        return this.trans;
    }

    public State getFin() {
        return this.fin;
    }

    public State getStart() {
        return this.start;
    }

    public static class fin
    extends Fields.any {
    }

    public static class start
    extends Fields.any {
    }

    public static class trans
    extends Fields.any {
    }
}

