/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lexer;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TP;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.Preamble;
import edu.neu.ccs.demeterf.lexer.classes.ChLbl;
import edu.neu.ccs.demeterf.lexer.classes.ChRE;
import edu.neu.ccs.demeterf.lexer.classes.ConcatRE;
import edu.neu.ccs.demeterf.lexer.classes.FinalState;
import edu.neu.ccs.demeterf.lexer.classes.GrpLbl;
import edu.neu.ccs.demeterf.lexer.classes.GrpPart;
import edu.neu.ccs.demeterf.lexer.classes.GrpRE;
import edu.neu.ccs.demeterf.lexer.classes.HuhRE;
import edu.neu.ccs.demeterf.lexer.classes.LexDef;
import edu.neu.ccs.demeterf.lexer.classes.LexMain;
import edu.neu.ccs.demeterf.lexer.classes.LocDef;
import edu.neu.ccs.demeterf.lexer.classes.LocRef;
import edu.neu.ccs.demeterf.lexer.classes.Mach;
import edu.neu.ccs.demeterf.lexer.classes.NChLbl;
import edu.neu.ccs.demeterf.lexer.classes.NChRE;
import edu.neu.ccs.demeterf.lexer.classes.NFA;
import edu.neu.ccs.demeterf.lexer.classes.NGrpLbl;
import edu.neu.ccs.demeterf.lexer.classes.NGrpRE;
import edu.neu.ccs.demeterf.lexer.classes.OrRE;
import edu.neu.ccs.demeterf.lexer.classes.PlusRE;
import edu.neu.ccs.demeterf.lexer.classes.PrintToString;
import edu.neu.ccs.demeterf.lexer.classes.RegExp;
import edu.neu.ccs.demeterf.lexer.classes.StarRE;
import edu.neu.ccs.demeterf.lexer.classes.State;
import edu.neu.ccs.demeterf.lexer.classes.StrRE;
import edu.neu.ccs.demeterf.lexer.classes.TokDef;
import edu.neu.ccs.demeterf.lexer.classes.Trans;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Set;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.CLI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemFLex {
    static String graph = "--graph";
    static String nocompress = "--nocompress";
    static String quiet = "--quiet";
    static String nowarn = "--nowarn";
    static DecimalFormat form = new DecimalFormat("0.00");

    static void p(String s2) {
        System.err.print(s2);
    }

    public static void main(String[] args2) throws Exception {
        List<String>[] all = CLI.splitArgs(args2);
        List<String> opts = all[CLI.OPTS];
        List<String> nonopts = all[CLI.ARGS];
        String[] nonOpt = nonopts.toArray((String[])new String[nonopts.length()]);
        Diff.storeOptions(opts);
        if (Diff.optionSet("--help")) {
            DemFLex.usage(true);
        }
        if (nonOpt.length != 2) {
            DemFLex.usage(false);
        }
        String inFile = nonOpt[0];
        String outFile = nonOpt[1];
        try {
            LexMain mn = LexMain.parse(new FileInputStream(inFile));
            DemFLex.genLex(mn, opts, outFile);
        }
        catch (Exception re2) {
            DemFLex.p(" Error:\n   " + re2.getMessage().replace("\n", "\n    ") + "\n");
        }
    }

    public static void genLex(LexMain mn, List<String> opts, String outFile) throws Exception {
        long start2 = System.currentTimeMillis();
        boolean loud = !Diff.optionSet(quiet);
        PrintStream out = new PrintStream(new FileOutputStream(outFile));
        if (loud) {
            DemFLex.p(" ** Rewriting\n");
        }
        List<TokDef> ts = DemFLex.rewriteAll(mn.getDs(), Map.<ident, RegExp>create());
        if (loud) {
            DemFLex.p(" ** Building NFAs\n");
        }
        List<NFA> nfas = DemFLex.convert(ts);
        final NFA fnfa = nfas.fold(new List.Fold<NFA, NFA>(){

            @Override
            public NFA fold(NFA f, NFA r2) {
                return r2.rawOr(f);
            }
        }, NFA.empty());
        List<FinalState> fins = nfas.zip(new List.Zip<NFA, TokDef, FinalState>(){

            @Override
            public FinalState zip(NFA n2, TokDef t) {
                State fin2 = n2.getStart().equals(n2.getFin()) ? fnfa.getStart() : n2.getFin();
                return new FinalState(fin2, "" + t.getId());
            }
        }, ts);
        if (Diff.optionSet(graph)) {
            out.println(String.valueOf(DemFLex.nfaToGraph(fnfa, fins)) + "\n");
            return;
        }
        Mach m = DemFLex.toDFA(fnfa);
        if (loud) {
            DemFLex.p(" ** Building DFA\n");
        }
        String cls = DemFLex.className(outFile);
        out.println(String.valueOf(Preamble.header) + mn.getPkg());
        out.println("public class " + DemFLex.className(outFile) + " extends edu.neu.ccs.demeterf.lexer.Lexer{");
        out.println("    static class DFA implements edu.neu.ccs.demeterf.lexer.ADFA{");
        out.println(Diff.optionSet(nocompress) ? m.transArray() : m.smallTransArray());
        out.println(m.finalArray(fins, Diff.optionSet(nowarn) || !loud));
        out.println("\n\n        /* Access Methods */\n        public int EOF(){ return T_EOF; }\n        public int SKIP(){ return T_SKIP; }\n        public int[][] getEDGES(){ return EDGES; }\n        public int[][] getFINAL(){ return FINAL; }\n        public String[] getNAMES(){ return NAMES; }\n    }\n\n    /* Create a " + cls + " Lexer... */\n" + "    public " + cls + "(java.io.InputStream inpt){ super(inpt, new DFA()); }\n");
        out.println("}");
        if (loud) {
            DemFLex.p(" ** Finished [" + DemFLex.time(start2) + " sec.]\n");
        }
    }

    static String className(String file2) {
        int d2 = file2.lastIndexOf(".");
        int s2 = file2.lastIndexOf(File.separator);
        s2 = s2 < 0 ? 0 : ++s2;
        if (d2 < s2) {
            throw new LexEx("Non-Java FileName");
        }
        return file2.substring(s2, d2);
    }

    static void usage(boolean help) {
        DemFLex.p("\n" + (help ? "" : " !! Incorrect arguments\n !!") + " Usage: java demflex [Options] <LEX-File> <Output-File>\n\n" + " The order/placement of options doesn't matter, but the relative\n" + "    order of the manditory ones must be as shown.\n\n" + " LEX-File contains the Lexer declarations to be generated,\n" + " Output-File is the Java File in which to place the generated DFA\n" + " Options can be: \n" + "   --help            : Print this usage information.\n" + "   --quiet           : Don't print Token overlap warnings.\n" + "   --nocompress      : Don't compress the State Table (might not compile then).\n" + "   --graph           : Write out a DOT/GraphViz graph of the final NFA to the\n" + "                         output File, instead of the DFA class.\n" + "\n");
        System.exit(1);
    }

    private static String time(long s2) {
        double t = (double)(System.currentTimeMillis() - s2) / 1000.0;
        return form.format(t);
    }

    static List<NFA> convert(List<TokDef> ts) {
        return (List)new Traversal(new ID(){

            NFA combine(StrRE re2) {
                throw new LexEx("Strings should be rewritten");
            }

            NFA combine(PlusRE re2) {
                throw new LexEx("Plus should be rewritten");
            }

            NFA combine(LocRef re2, ident id2) {
                throw new LexEx("Unbound Local Def: " + id2);
            }

            NFA combine(ChRE re2, char v2) {
                return NFA.empty().addTrans(new ChLbl(v2));
            }

            NFA combine(NChRE re2, char v2) {
                return NFA.empty().addTrans(new NChLbl(v2));
            }

            NFA combine(GrpRE re2, List<GrpPart> gs2) {
                return NFA.empty().addTrans(new GrpLbl(gs2));
            }

            NFA combine(NGrpRE re2, List<GrpPart> gs2) {
                return NFA.empty().addTrans(new NGrpLbl(gs2));
            }

            NFA combine(ConcatRE re2, List<NFA> nfas) {
                return NFA.concat(nfas);
            }

            NFA combine(OrRE re2, List<NFA> nfas) {
                return NFA.or(nfas);
            }

            NFA combine(StarRE re2, NFA nfa) {
                return nfa.star();
            }

            NFA combine(HuhRE re2, NFA nfa) {
                return nfa.huh();
            }

            NFA combine(TokDef t, ident id2, NFA n2) {
                return n2;
            }

            List<NFA> combine(List<?> l2, NFA n2, List<NFA> r2) {
                return r2.push(n2.rmdups());
            }

            List<NFA> combine(Empty<?> e2) {
                return List.create();
            }
        }, Control.bypass("edu.neu.ccs.demeterf.lexer.classes.GrpRE.gs edu.neu.ccs.demeterf.lexer.classes.NGrpRE.gs")).traverse(ts);
    }

    static Mach toDFA(NFA nfa) {
        List<Trans> eps = nfa.epsilons();
        Set<State> start2 = NFA.closure(Set.create((Comparable[])new State[]{nfa.getStart()}), eps);
        Mach m = new Mach(start2);
        int last = 1;
        int curr = 1;
        while (curr <= last) {
            Set<State> currState = m.state(curr);
            char c2 = '\u0000';
            while (c2 < '\u0100') {
                Set<State> e2 = nfa.DFAEdge(currState, c2, eps);
                int look2 = m.lookup(e2);
                m = look2 >= 0 ? m.addTrans(curr, c2, look2) : m.addState(++last, e2).addTrans(curr, c2, last);
                c2 = (char)(c2 + '\u0001');
            }
            ++curr;
        }
        return m;
    }

    static List<TokDef> rewriteAll(List<LexDef> ds2, final Map<ident, RegExp> locs) {
        return (List)Traversal.onestep(new ID(){

            List<TokDef> combine(List<?> l2, LocDef loc, List<LexDef> r2) {
                return DemFLex.rewriteAll(r2, locs.put(loc.getId(), DemFLex.rewrite(loc.getRe(), locs)));
            }

            List<TokDef> combine(List<?> l2, TokDef tok2, List<LexDef> r2) {
                return DemFLex.rewriteAll(r2, locs).push(DemFLex.rewrite(tok2, locs));
            }

            List<TokDef> combine(Empty<?> e2) {
                return List.create();
            }
        }).traverse(ds2);
    }

    static List<RegExp> flatten(List<RegExp> res2, Flat f) {
        return (List)new Traversal(f, Control.bypass("edu.neu.ccs.demeterf.lib.Cons.first")).traverse(res2);
    }

    static <T> T rewrite(T t, final Map<ident, RegExp> locs) {
        return (T)new Traversal(new TP(){

            RegExp combine(StrRE s2, String val2) {
                return DemFLex.toConcat(val2, List.<RegExp>create());
            }

            RegExp combine(PlusRE s2, RegExp inner) {
                return new ConcatRE(List.create(inner, new StarRE(inner)));
            }

            RegExp combine(LocRef re2, ident id2) {
                if (!locs.containsKey(id2)) {
                    throw new LexEx("Unbound Local: " + id2);
                }
                return (RegExp)locs.get(id2);
            }

            RegExp combine(OrRE re2, List<RegExp> args2) {
                return new OrRE(DemFLex.flatten(args2, new Flat(){

                    List<RegExp> combine(List<?> l2, OrRE e2, List<RegExp> r2) {
                        return r2.push(e2.getRes());
                    }
                }));
            }

            RegExp combine(ConcatRE re2, List<RegExp> args2) {
                return new ConcatRE(DemFLex.flatten(args2, new Flat(){

                    List<RegExp> combine(List<?> l2, ConcatRE e2, List<RegExp> r2) {
                        return r2.push(e2.getRes());
                    }
                }));
            }
        }).traverse(t);
    }

    static RegExp toConcat(String s2, List<RegExp> lor) {
        if (s2.length() == 0) {
            if (lor.length() == 1) {
                return lor.top();
            }
            return new ConcatRE(lor.reverse());
        }
        return DemFLex.toConcat(s2.substring(1), lor.push(new ChRE(s2.charAt(0))));
    }

    static String nfaToGraph(NFA nfa, List<FinalState> fins) {
        return "digraph G{\n  rankdir=LR;\n  node [shape=doublecircle,style=filled,fillcolor=\"#66FF66\"];\n    \"" + nfa.getStart() + "\";\n" + "  node [shape=ellipse,style=filled,fillcolor=\"#FF6666\"];\n" + "  " + fins.toString(new List.Stringer<FinalState>(){

            @Override
            public String toString(FinalState f, List<FinalState> r2) {
                return "  \"" + f.getS() + "\"[label=\"" + f.getTok().toUpperCase() + "\"]\n;";
            }
        }) + "  node [shape=circle,style=filled,fillcolor=\"#FFFFFF\"];\n" + nfa.getTrans().toString(new List.Stringer<Trans>(){

            @Override
            public String toString(Trans t, List<Trans> r2) {
                return "  \"" + t.getFrm() + "\" -> \"" + t.getTo() + "\"[label=\" " + PrintToString.escape("" + t.getL()) + "\"];\n";
            }
        }) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Flat
    extends TP {
        Flat() {
        }

        List<RegExp> combine(List<?> l2, List<RegExp> res2, List<RegExp> r2) {
            return r2.push(res2);
        }
    }

    static class LexEx
    extends RuntimeException {
        LexEx(String s2) {
            super(s2);
        }
    }
}

