/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.ClassDef;
import edu.neu.ccs.demeterf.demfgen.classes.DoGen;
import edu.neu.ccs.demeterf.demfgen.classes.Field;
import edu.neu.ccs.demeterf.demfgen.classes.FieldList;
import edu.neu.ccs.demeterf.demfgen.classes.Impl;
import edu.neu.ccs.demeterf.demfgen.classes.IntfcDef;
import edu.neu.ccs.demeterf.demfgen.classes.PESubtypeList;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.inline.AbstRec;
import edu.neu.ccs.demeterf.inline.Checker;
import edu.neu.ccs.demeterf.inline.GenControl;
import edu.neu.ccs.demeterf.inline.Help;
import edu.neu.ccs.demeterf.inline.Inline;
import edu.neu.ccs.demeterf.inline.NewDecision;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.inline.ToLst;
import edu.neu.ccs.demeterf.inline.TravRet;
import edu.neu.ccs.demeterf.inline.classes.EnvEntry;
import edu.neu.ccs.demeterf.inline.classes.FunctionClass;
import edu.neu.ccs.demeterf.inline.classes.Meth;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.lib.Set;
import edu.neu.ccs.demeterf.lib.ident;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Typer
extends ID {
    Traversal trav;
    List<TypeDef> types;
    FunctionClass func;
    FunctionClass ctxFunc;
    GenControl ctrl;
    Option<TypeUse> targ;
    List<AbstRec> recabstr = List.create();
    SubTyping subs;
    Set<EnvEntry> results = Set.create(new Comparator<EnvEntry>(){

        @Override
        public int compare(EnvEntry a, EnvEntry b) {
            return a.getType().print().compareTo(b.getType().print());
        }
    });
    Map<String, List<Meth>> updates = Map.create();

    Typer(List<TypeDef> ts, FunctionClass fc, GenControl c2, SubTyping s2, FunctionClass ctxF) {
        this(ts, fc, c2, Option.none(), s2, ctxF);
    }

    Typer(List<TypeDef> ts, FunctionClass fc, GenControl c2, Option<TypeUse> ta, SubTyping s2, FunctionClass ctxF) {
        this.types = ts;
        this.func = fc;
        this.ctrl = c2;
        this.targ = ta;
        this.subs = s2;
        this.trav = Traversal.onestep(this);
        this.ctxFunc = ctxF;
    }

    synchronized void addEnv(EnvEntry ent) {
        if (this.results.contains(ent)) {
            return;
        }
        if (ent.getRet().equals(SubTyping.obj)) {
            Help.tell(" ** Warning[" + this.func.getName() + "]: " + ent.getType() + " returns Object\n");
        }
        this.results = this.results.add(ent);
    }

    synchronized void addAbst(AbstRec abs) {
        this.recabstr = this.recabstr.push(abs);
    }

    public List<AbstRec> getRecAbstrs() {
        return this.recabstr;
    }

    TravRet recurse(String one, Set<String> recs) {
        Help.print(" Recurse: " + one + "\n");
        if (this.ctrl.isBuiltIn(one)) {
            List<Meth> ap;
            TypeUse typ = TypeUse.makeType(one);
            List<Option<TypeUse>> argTs = List.create(Option.some(typ));
            if (this.targ.isSome()) {
                argTs = argTs.append(this.targ);
            }
            if ((ap = this.possibleMethsStar(argTs, this.func)).isEmpty()) {
                this.addEnv(new EnvEntry(typ, typ, ap));
                return new TravRet(typ, ap);
            }
            TypeUse ret2 = this.unifyReturns(ap);
            this.addEnv(new EnvEntry(typ, ret2, ap));
            return new TravRet(ret2, ap);
        }
        TypeDef td = Checker.defFor(TypeUse.makeType(one), this.types);
        return this.recurse(td, recs);
    }

    TravRet recurse(TypeDef one, Set<String> recs) {
        return (TravRet)this.trav.traverse((Object)one, recs);
    }

    TravRet combine(ClassDef d2, DoGen g, ident n2, TypeDefParams ps, PESubtypeList sts2, FieldList fs, Impl i, Set<String> recs) {
        if (!sts2.isEmpty()) {
            List<Meth> ms = !fs.isEmpty() && Diff.optionSet("--concretes") ? this.check((String)new StringBuilder().append((Object)n2).append((String)ps.print()).toString(), (FieldList)fs, recs, (boolean)true).meths : List.create();
            return this.check(n2 + ps.print(), sts2, recs, ms);
        }
        return this.check(n2 + ps.print(), fs, recs, true);
    }

    TravRet combine(IntfcDef d2, DoGen g, ident n2, TypeDefParams ps, PESubtypeList sts2, Set<String> recs) {
        return this.check(n2 + ps.print(), sts2, recs, List.<Meth>create());
    }

    TravRet check(String t, FieldList fields2, Set<String> recs, boolean save) {
        Help.print(" Check Concrete: " + t + "\n");
        final TypeUse curr = TypeUse.makeType(t);
        Help.print(" TypeUse: " + curr.print() + "\n");
        List<GenControl.Edge> fts = ToLst.toList(fields2, Field.class).map(new List.Map<Field, GenControl.Edge>(){

            @Override
            public GenControl.Edge map(Field f) {
                return GenControl.makeEdge(f.getType(), "" + f.getName());
            }
        });
        final Set<String> nextrecs = recs.add(t);
        List<Option<TravRet>> rets = fts.map(new List.Map<GenControl.Edge, Option<TravRet>>(){

            @Override
            public Option<TravRet> map(GenControl.Edge e2) {
                String typ = e2.getType().print();
                if (Typer.this.ctrl.skip(curr, e2.getField())) {
                    return Option.some(new TravRet(e2.getType(), List.<Meth>create()));
                }
                if (Typer.this.targ.isSome()) {
                    String fldS = curr.getName() + "$" + e2.getField();
                    TypeUse fldC = TypeUse.makeType(fldS);
                    List<Option<TypeUse>> argTs = List.create(Option.some(curr), Option.some(fldC), Typer.this.targ);
                    List<Meth> ap = Typer.this.possibleMethsStar(argTs, Typer.this.ctxFunc);
                    if (!ap.isEmpty()) {
                        if (!Typer.this.subs.subtype(Typer.this.unifyReturns(ap), Typer.this.targ.inner())) {
                            throw new TypeError("Update method return(s) are not subtypes\n" + ap.toString("\n", "   "));
                        }
                        Typer.this.updates = Typer.this.updates.put(fldS, ap);
                    }
                }
                if (nextrecs.contains(typ)) {
                    return Option.none();
                }
                return Option.some(Typer.this.recurse(typ, (Set<String>)nextrecs));
            }
        });
        List<Option<TypeUse>> argTs = rets.map(new List.Map<Option<TravRet>, Option<TypeUse>>(){

            @Override
            public Option<TypeUse> map(Option<TravRet> o) {
                return o.isSome() ? Option.some(o.inner().ret) : Option.none();
            }
        }).push(Option.some(TypeUse.makeType(t)));
        if (this.targ.isSome()) {
            argTs = argTs.append(this.targ);
        }
        List<Meth> poss = this.possibleMethsStar(argTs, this.func);
        String argsStr = this.signature(argTs);
        Help.print(" Selections for " + argsStr + "\n" + poss.toString("", "    ") + "\n");
        if (poss.length() == 0) {
            throw new TypeError("No Possible Method for: " + argsStr);
        }
        if (!Inline.RESIDUE && poss.length() > 1) {
            throw new TypeError("Too Many Methods [" + poss.length() + "] For: " + argsStr);
        }
        TypeUse ret2 = this.unifyReturns(poss);
        if (save) {
            this.addEnv(new EnvEntry(curr, ret2, poss));
        }
        return new TravRet(ret2, poss);
    }

    List<Meth> possibleMethsStar(List<Option<TypeUse>> argTs, FunctionClass f) {
        List<Meth> app = f.applicableWithStar(argTs, this.subs);
        List<Meth> poss = f.subWithStar(argTs, this.subs, app);
        if (!app.isEmpty()) {
            poss = poss.push(NewDecision.best(app.top(), app.pop(), this.subs)).removeDuplicates();
        }
        return poss;
    }

    String signature(List<Option<TypeUse>> argTs) {
        return "(" + argTs.toString(new List.Stringer<Option<TypeUse>>(){

            @Override
            public String toString(Option<TypeUse> f, List<Option<TypeUse>> r2) {
                return String.valueOf(f.isSome() ? f.inner().toString() : "*") + (r2.isEmpty() ? "" : ", ");
            }
        }) + ")";
    }

    TravRet check(String t, PESubtypeList subtypes2, Set<String> recs, List<Meth> ms) {
        TypeUse upper;
        Help.print(" Check Abstract: " + t + "\n");
        TypeUse curr = TypeUse.makeType(t);
        List<TypeUse> sts2 = ToLst.toList(subtypes2, TypeUse.class);
        final Set<String> nextrecs = recs.add(t);
        List<Option<TravRet>> rets = sts2.map(new List.Map<TypeUse, Option<TravRet>>(){

            @Override
            public Option<TravRet> map(TypeUse t) {
                if (nextrecs.contains(t.print())) {
                    return Option.none();
                }
                return Option.some(Typer.this.recurse(t.print(), (Set<String>)nextrecs));
            }
        });
        if (rets.contains(Option.none())) {
            this.addAbst(new AbstRec(curr, sts2));
        }
        if ((upper = this.unifyResults(rets)) == null) {
            throw new TypeError("All Recursive Subtypes for: " + t);
        }
        this.addEnv(new EnvEntry(curr, upper, ms));
        return new TravRet(upper, ms);
    }

    static <X> List<Option<X>> wrapSomes(List<X> lst) {
        return lst.map(new List.Map<X, Option<X>>(){

            @Override
            public Option<X> map(X x2) {
                return Option.some(x2);
            }
        });
    }

    TypeUse unifyReturns(List<Meth> ms) {
        return this.unify(ms.map(new List.Map<Meth, TypeUse>(){

            @Override
            public TypeUse map(Meth m) {
                return m.getRet();
            }
        }));
    }

    TypeUse unifyResults(List<Option<TravRet>> ors) {
        return this.unify(ors.fold(new List.Fold<Option<TravRet>, List<TypeUse>>(){

            @Override
            public List<TypeUse> fold(Option<TravRet> p, List<TypeUse> tus) {
                return p.isSome() ? tus.push(p.inner().ret) : tus;
            }
        }, List.create()));
    }

    TypeUse unify(List<TypeUse> tus) {
        if (tus.isEmpty()) {
            return null;
        }
        TypeUse upper = tus.fold(new List.Fold<TypeUse, TypeUse>(){

            @Override
            public TypeUse fold(TypeUse n2, TypeUse t) {
                AnySup fnd = new AnySup(n2);
                List<TypeUse> sups = List.create(t);
                while (!sups.contains(fnd)) {
                    sups = Typer.this.subs.supertypes(sups.top());
                }
                return sups.filter(fnd).top();
            }
        }, tus.top());
        return upper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnySup
    extends List.Pred<TypeUse> {
        TypeUse t;

        AnySup(TypeUse tt) {
            this.t = tt;
        }

        @Override
        public boolean huh(TypeUse u) {
            return Typer.this.subs.subtype(this.t, u);
        }
    }
}

