/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.lib.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenControl {
    static List<String> FirstBuiltIns = List.create("short", "Short", "Integer", "int", "Float", "float", "Long", "long", "Double", "double", "String", "Boolean", "boolean", "char", "Character", "ident", "verbatim");
    private SubTyping subs;
    private List<TypeUse> builtIns;
    private List<Edge> bypass;
    private List<Edge> ignore;

    public static GenControl make(SubTyping subs, List<String> cls, List<String> byps, List<String> ign) {
        return new GenControl(subs, FirstBuiltIns.append((String)((Object)cls)).map(new List.Map<String, TypeUse>(){

            @Override
            public TypeUse map(String s2) {
                return TypeUse.makeType(s2);
            }
        }), GenControl.toEdges(subs, byps), GenControl.toEdges(subs, ign));
    }

    static List<Edge> toEdges(SubTyping subs, List<String> es) {
        return es.map(new List.Map<String, Edge>(){

            @Override
            public Edge map(String s2) {
                int idx = s2.indexOf(46);
                if (idx < 1) {
                    return new AllEdges(TypeUse.makeType(s2));
                }
                return new Edge(TypeUse.makeType(s2.substring(0, idx)), s2.substring(idx + 1));
            }
        });
    }

    public boolean skip(String c2, String f) {
        return this.skip(TypeUse.makeType(c2), f);
    }

    public boolean skip(TypeUse c2, String f) {
        return this.skip(new Edge(c2, f));
    }

    public boolean skip(Edge e2) {
        return this.bypass.contains(e2);
    }

    public boolean ignore(String c2, String f) {
        return this.ignore(TypeUse.makeType(c2), f);
    }

    public boolean ignore(TypeUse c2, String f) {
        return this.ignore(new Edge(c2, f));
    }

    public boolean ignore(Edge e2) {
        return this.ignore.contains(e2);
    }

    private GenControl(SubTyping st, List<TypeUse> bins, List<Edge> byps, List<Edge> ignr) {
        this.subs = st;
        this.builtIns = bins;
        this.bypass = byps;
        this.ignore = ignr;
    }

    public boolean isBuiltIn(String tu) {
        return this.isBuiltIn(TypeUse.makeType(tu));
    }

    public boolean isBuiltIn(final TypeUse tu) {
        return this.builtIns.contains(new List.Pred<TypeUse>(){

            @Override
            public boolean huh(TypeUse bi) {
                return GenControl.this.subs.subtype(tu, bi);
            }
        });
    }

    public static Edge makeEdge(TypeUse t, String f) {
        return new Edge(t, f);
    }

    static class AllEdges
    extends Edge {
        AllEdges(TypeUse c2) {
            super(c2, "");
        }

        public boolean equals(Object eo) {
            if (!(eo instanceof Edge)) {
                return false;
            }
            Edge e2 = (Edge)eo;
            return this.clas.equals(e2.clas);
        }

        public String toString() {
            return "alledges(" + this.clas + ")";
        }
    }

    public static class Edge {
        TypeUse clas;
        String field;

        Edge(TypeUse c2, String f) {
            this.clas = c2;
            this.field = f;
        }

        public TypeUse getType() {
            return this.clas;
        }

        public String getField() {
            return this.field;
        }

        public boolean equals(Object eo) {
            if (!(eo instanceof Edge)) {
                return false;
            }
            Edge e2 = (Edge)eo;
            return this.clas.equals(e2.clas) && this.field.equals(e2.field);
        }

        public String toString() {
            return "edge(" + this.clas + "." + this.field + ")";
        }
    }
}

