/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http.server;

import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;
import edu.neu.ccs.demeterf.http.server.Factory;
import edu.neu.ccs.demeterf.http.server.Path;
import edu.neu.ccs.demeterf.http.server.Server;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDispatch {
    private Map<String, Method> dispatch;
    private Object target;
    static Class<?>[] MinimalFormals = new Class[]{HTTPReq.class};
    static Class<?>[] DefaultFormals = new Class[]{HTTPReq.class, Socket.class};

    static void p(String s2) {
        Factory.p(s2);
    }

    private ServerDispatch(Map<String, Method> dis, Object targ2) {
        this.dispatch = dis;
        this.target = targ2;
    }

    public static ServerDispatch create(Object handler) {
        return ServerDispatch.create(handler, DefaultFormals);
    }

    public static ServerDispatch create(Object handler, final Class<?>[] formals) {
        Class<?> c2 = handler.getClass();
        if (!c2.isAnnotationPresent(Server.class)) {
            throw Factory.error("Cannot Create Server for unannotated class '" + c2.getCanonicalName() + "'");
        }
        Server s2 = c2.getAnnotation(Server.class);
        return new ServerDispatch(List.create(c2.getDeclaredMethods()).fold(new List.Fold<Method, Map<String, Method>>(){

            @Override
            public Map<String, Method> fold(Method m, Map<String, Method> res2) {
                if (!m.isAnnotationPresent(Path.class)) {
                    return res2;
                }
                String p = ServerDispatch.check(m, formals);
                m.setAccessible(true);
                ServerDispatch.p("Mapping '" + p + "' to " + m.getName());
                return res2.put(p, m);
            }
        }, Map.create()), handler);
    }

    public Object getTarget() {
        return this.target;
    }

    public HTTPResp handle(HTTPReq req) {
        return this.handle(req, null);
    }

    public HTTPResp handle(HTTPReq req, Socket sock) {
        try {
            HTTPResp res2;
            String path = req.trimmedUrl();
            ServerDispatch.p("HTTP Path: " + path);
            if (!this.dispatch.containsKey(path)) {
                ServerDispatch.p("Unbound Path '" + path + "' Trying Default");
                path = "";
            }
            if (!this.dispatch.containsKey(path)) {
                ServerDispatch.p("No Default Path");
                res2 = HTTPResp.textError("Path Not Found");
            } else {
                Object[] args2;
                Method m = this.dispatch.get(path);
                switch (m.getParameterTypes().length) {
                    case 0: {
                        args2 = new Object[]{};
                        break;
                    }
                    case 1: {
                        args2 = new Object[]{req};
                        break;
                    }
                    default: {
                        if (sock == null) {
                            throw Factory.error("Missing Expected Socket Argument");
                        }
                        args2 = new Object[]{req, sock};
                    }
                }
                res2 = (HTTPResp)m.invoke(this.target, args2);
            }
            return res2;
        }
        catch (IllegalAccessException e2) {
            return HTTPResp.textError(500, "Server Error", "Inaccessable Request Handler: " + e2);
        }
        catch (InvocationTargetException e3) {
            return HTTPResp.textError(500, "Handler Exception", "Exception in Request Handler: " + e3.getCause());
        }
    }

    public static String check(Method m, Class<?>[] formals) {
        Path p = m.getAnnotation(Path.class);
        if (!HTTPResp.class.equals(m.getReturnType())) {
            throw Factory.error("Return Type is incorrect: '" + m.getReturnType().getClass() + "'");
        }
        Class<?>[] params2 = m.getParameterTypes();
        if (params2.length > formals.length) {
            throw Factory.error("Too many Parameters for Server Method '" + m.getName() + "'");
        }
        ServerDispatch.checkParams(m.getName(), 0, params2, formals);
        if (p == null) {
            return null;
        }
        return p.value();
    }

    private static void checkParams(String method, int i, Class<?>[] ps, Class<?>[] fmls) {
        if (i >= ps.length || i >= fmls.length) {
            return;
        }
        if (!fmls[i].isAssignableFrom(ps[i])) {
            throw Factory.error("Parameter #" + i + " of " + method + " is of an incorrect type. " + "Expecting '" + fmls[i].getName() + "'");
        }
        ServerDispatch.checkParams(method, i + 1, ps, fmls);
    }
}

