/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http;

import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;
import edu.neu.ccs.demeterf.http.server.ExceptionHandler;
import edu.neu.ccs.demeterf.http.server.Factory;
import edu.neu.ccs.demeterf.http.server.MaxMessageSize;
import edu.neu.ccs.demeterf.http.server.Path;
import edu.neu.ccs.demeterf.http.server.Port;
import edu.neu.ccs.demeterf.http.server.RequestException;
import edu.neu.ccs.demeterf.http.server.Server;
import edu.neu.ccs.demeterf.http.server.ServerThread;
import edu.neu.ccs.demeterf.lib.Entry;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Server
public class Test {
    @Port
    static int PORT = 9000;
    @MaxMessageSize
    static final int MAX = 20;

    @Path(value="/html")
    public HTTPResp htmlResp(HTTPReq req) {
        return HTTPResp.htmlResponse("<html>\n<head><title>Sample Page</title></head>\n<body><b>HELLO</b> <i>There</i></body><html>");
    }

    @Path(value="/text")
    public HTTPResp textResp(HTTPReq req) {
        return HTTPResp.textResponse("Plain Text Response");
    }

    @Path(value="/urlargs")
    public HTTPResp urlResp(HTTPReq req) {
        return this.mapToHTML(req.urlArgs());
    }

    @Path(value="/headers")
    public HTTPResp headerResp(HTTPReq req) {
        return this.mapToHTML(req.getHeaders());
    }

    HTTPResp mapToHTML(Map<String, String> m) {
        return HTTPResp.htmlResponse("<html>" + m.toList().fold(new List.Fold<Entry<String, String>, String>(){

            @Override
            public String fold(Entry<String, String> e2, String r2) {
                return "<b>" + e2.getKey() + "</b> : <i>" + e2.getVal() + "</i><br/>" + r2;
            }
        }, "</html>"));
    }

    @Path
    public HTTPResp fileResp(HTTPReq req) {
        String file2 = req.getHead().getUrl().trimArgs();
        if (!file2.startsWith("/file/")) {
            return HTTPResp.textError("ERROR: Unknown Request");
        }
        file2 = file2.substring(file2.indexOf(47, 1));
        try {
            BufferedReader buff = new BufferedReader(new FileReader(file2));
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = buff.readLine()) != null) {
                sb.append(line).append('\n');
            }
            return HTTPResp.textResponse(sb.toString());
        }
        catch (IOException e2) {
            return HTTPResp.error("FileNotFound: '" + file2 + "'");
        }
    }

    @ExceptionHandler
    public HTTPResp exception() {
        return HTTPResp.error("Exception: ");
    }

    static void p(String s2) {
        System.err.print(s2);
    }

    public static void main(String[] args2) throws Exception {
        try {
            Test.p("Starting Server\n");
            Factory.setVerbose(true);
            if (args2.length == 1) {
                PORT = Integer.parseInt(args2[0]);
            }
            ServerThread server = Factory.create(new Test());
            Test.p("Hit enter to shutdown");
            System.in.read();
            server.shutdown();
        }
        catch (RequestException e2) {
            System.out.println("Error: " + e2.getMessage());
        }
    }
}

