/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TP;
import edu.neu.ccs.demeterf.Traversal;

public class FuncTest {
    public static void main(String[] args2) {
        List<Integer> lst = List.from(new Integer[]{1, 5, 2, 6, 3, 4, 7});
        System.out.println(" String: " + lst);
        System.out.println(" Length: " + new Traversal(new Length()).traverse(lst));
        System.out.println("    Sum: " + new Traversal(new Sum()).traverse(lst));
        System.out.println("   Add1: " + new Traversal(new Add1()).traverse(lst));
        System.out.println("    I2S: " + new Traversal(new Int2Str()).traverse(lst));
    }

    static class Add1
    extends TP {
        Add1() {
        }

        public int combine(int i) {
            return i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cons<T>
    extends List<T> {
        T first;
        List<T> rest;

        Cons(T f, List<T> r2) {
            this.first = f;
            this.rest = r2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Empty<T>
    extends List<T> {
        Empty() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Fold<T, R>
    extends ID {
        Fold() {
        }

        abstract R combine(Empty<T> var1);

        abstract R combine(Cons<T> var1, T var2, R var3);
    }

    public static class Int2Str
    extends TP {
        String combine(Integer i) {
            return "'" + i + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Length
    extends Fold<Integer, Integer> {
        Length() {
        }

        @Override
        Integer combine(Empty<Integer> l2) {
            return 0;
        }

        @Override
        Integer combine(Cons<Integer> l2, Integer f, Integer r2) {
            return r2 + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class List<T> {
        List() {
        }

        static <S> List<S> from(S[] a) {
            return List.from(a, 0);
        }

        static <S> List<S> from(S[] a, int i) {
            if (i == a.length) {
                return new Empty();
            }
            return new Cons<S>(a[i], List.from(a, i + 1));
        }

        public String toString() {
            return (String)new Traversal(new Fold<Object, String>(){

                @Override
                String combine(Empty<Object> l2) {
                    return "()";
                }

                @Override
                String combine(Cons<Object> l2, Object first2, String r2) {
                    return "(" + first2 + " " + r2 + ")";
                }
            }).traverse(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sum
    extends Length {
        Sum() {
        }

        @Override
        Integer combine(Cons<Integer> l2, Integer f, Integer r2) {
            return f + r2;
        }
    }
}

