/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TP;
import edu.neu.ccs.demeterf.Traversal;

public class EvalTest {
    public static void main(String[] args2) {
        Bin e2 = new Bin(new Div(), new Bin(new Plus(), new Bin(new Plus(), new Bin(new Times(), new Num(9), new Num(6)), new Num(8)), new Bin(new Minus(), new Num(5), new Num(7))), new Num(4));
        System.out.println("  Before: " + e2);
        System.out.println("  AddOne: " + new Traversal(new AddOne()).traverse(e2));
        System.out.println("    Eval: " + new Traversal(new Eval()).traverse(e2));
        System.out.println(" Num2Str: " + new Traversal(new Num2Str()).traverse(e2));
        System.out.println("   Depth: " + new Traversal(new Depth()).traverse(e2));
    }

    static class AddOne
    extends TP {
        AddOne() {
        }

        public int combine(int i) {
            return i + 1;
        }
    }

    static class Bin
    extends Exp {
        Op op;
        Exp left;
        Exp right;

        Bin(Op o, Exp l2, Exp r2) {
            this.op = o;
            this.left = l2;
            this.right = r2;
        }
    }

    static class Depth
    extends ID {
        Depth() {
        }

        Op combine(Op o) {
            return o;
        }

        int combine(Exp u, int i) {
            return 0;
        }

        int combine(Exp b, Op o, int l2, int r2) {
            return 1 + Math.max(l2, r2);
        }
    }

    static class Div
    extends Op {
        Div() {
        }
    }

    static class Eval
    extends ID {
        Eval() {
        }

        int combine(Num n2, int i) {
            return i;
        }

        Op combine(Op o) {
            return o;
        }

        int combine(Bin b, Plus p, int l2, int r2) {
            return l2 + r2;
        }

        int combine(Bin b, Minus p, int l2, int r2) {
            return l2 - r2;
        }

        int combine(Bin b, Times p, int l2, int r2) {
            return l2 * r2;
        }

        int combine(Bin b, Div p, int l2, int r2) {
            return l2 / r2;
        }
    }

    static abstract class Exp {
        Exp() {
        }

        public String toString() {
            return (String)new Traversal(new ID(){

                String combine(Num n2, int i) {
                    return "" + i;
                }

                String combine(Bin b, String op, String l2, String r2) {
                    return "(" + l2 + " " + op + " " + r2 + ")";
                }

                String combine(Plus p) {
                    return "+";
                }

                String combine(Minus p) {
                    return "-";
                }

                String combine(Times p) {
                    return "*";
                }

                String combine(Div p) {
                    return "/";
                }

                String combine(Str se, String s2) {
                    return "\"" + s2 + "\"";
                }
            }).traverse(this);
        }
    }

    static class Minus
    extends Op {
        Minus() {
        }
    }

    static class Num
    extends Exp {
        int num;

        Num(int i) {
            this.num = i;
        }

        public String toString() {
            return "" + this.num;
        }
    }

    static class Num2Str
    extends TP {
        Num2Str() {
        }

        Str combine(Num n2, int i) {
            return new Str("" + n2);
        }
    }

    static abstract class Op {
        Op() {
        }
    }

    static class Plus
    extends Op {
        Plus() {
        }
    }

    static class Str
    extends Exp {
        String str;

        Str(String s2) {
            this.str = s2;
        }
    }

    static class Times
    extends Op {
        Times() {
        }
    }
}

