/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import edu.neu.ccs.demeterf.dispatch.TypeSort;
import edu.neu.ccs.demeterf.lib.List;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDB<M> {
    static boolean debug = false;
    protected List<DBEntry<M>> methods;

    public MethodDB(List<DBEntry<M>> m) {
        this.methods = m;
    }

    public static List<DBEntry<Method>> getMethods(Class<?> c2, String name2) {
        List<DBEntry<Method>> l2 = List.create();
        while (c2 != null && !c2.equals(Object.class)) {
            Method[] methodArray = c2.getDeclaredMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MethodEntry me;
                Method m = methodArray[n3];
                if (m.getName().equals(name2) && l2.index(me = new MethodEntry(m)) < 0) {
                    l2 = l2.push(me);
                }
                ++n3;
            }
            c2 = c2.getSuperclass();
        }
        return l2;
    }

    public static MethodDB<Method> createMethodDB(Class<?> c2, String name2) {
        return new MethodDB<Method>(MethodDB.getMethods(c2, name2));
    }

    public static MethodDB<Constructor<?>> createConstrDB(Class<?> c2) {
        List l2 = List.create();
        Constructor<?>[] constructorArray = c2.getDeclaredConstructors();
        int n2 = constructorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Constructor<?> con = constructorArray[n3];
            l2 = l2.push(new ConstrEntry(con));
            ++n3;
        }
        return new MethodDB(l2);
    }

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static boolean isDebug() {
        return debug;
    }

    public DBEntry<M> matchEntryFast(Class<?>[] args2) {
        return MethodDB.matchEntryFast(args2, args2.length, this.methods);
    }

    private static <M> DBEntry<M> matchEntryFast(Class<?>[] args2, int len, List<DBEntry<M>> db) {
        if (db.isEmpty()) {
            return null;
        }
        DBEntry<M> e2 = db.top();
        if (MethodDB.applicable(args2, len, e2)) {
            return MethodDB.matchEntryFast(args2, len, db.pop(), e2);
        }
        return MethodDB.matchEntryFast(args2, len, db.pop());
    }

    private static <M> boolean applicable(Class<?>[] args2, int len, DBEntry<M> e2) {
        if (e2.numArgs() > len) {
            return false;
        }
        int i = 0;
        while (i < e2.numArgs()) {
            if (!e2.arg(i).isAssignableFrom(args2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static <M> DBEntry<M> matchEntryFast(Class<?>[] args2, int len, List<DBEntry<M>> db, DBEntry<M> bst2) {
        if (db.isEmpty()) {
            return bst2;
        }
        DBEntry<M> e2 = db.top();
        if (MethodDB.applicable(args2, len, e2) && TypeSort.compare(e2, bst2)) {
            return MethodDB.matchEntryFast(args2, len, db.pop(), e2);
        }
        return MethodDB.matchEntryFast(args2, len, db.pop(), bst2);
    }

    public List<DBEntry<M>> matchAllEntries(final Class<?>[] args2) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> e2) {
                return MethodDB.applicable(args2, args2.length, e2);
            }
        });
    }

    public String toString() {
        return this.methods.toString();
    }

    public String toString(String s2) {
        return this.methods.toString(s2, "");
    }

    public List<DBEntry<M>> prefixApp(final Class<?> c2) {
        return this.methods.filter(new List.Pred<DBEntry<M>>(){

            @Override
            public boolean huh(DBEntry<M> e2) {
                return e2.numArgs() >= 1 && e2.arg(0).isAssignableFrom(c2);
            }
        });
    }

    public List<DBEntry<M>> allMethods() {
        return this.methods;
    }
}

