/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.demfgen.Diff;

public class Preamble {
    public static String header = "// ** This file was generated with DemFGen (vers:" + Diff.buildDate + ")\n\n";
    private static String lexer = "SKIP : { \" \" | \"\\t\" | \"\\n\" | \"\\r\" | \"\\r\\n\" }\nSKIP : { < \"//\" (~[\"\\n\",\"\\r\"])* (\"\\n\"|\"\\r\\n\") >\n       | < \"/*\" (~[\"*\"])* \"*\" (~[\"/\"] (~[\"*\"])* \"*\")* \"/\" > }\nTOKEN: { < TRUE : \"true\" >\n       | < FALSE : \"false\" > }\nTOKEN: { < CHAR: \"\\'\" \n              ( (~[\"\\'\",\"\\\\\",\"\\n\",\"\\r\"]) | \n                (\"\\\\\" ( [\"n\",\"t\",\"b\",\"r\",\"f\",\"\\\\\",\"\\'\",\"\\\"\"] |\n                            [\"0\"-\"7\"] ( [\"0\"-\"7\"] )? |\n                            [\"0\"-\"3\"] [\"0\"-\"7\"] [\"0\"-\"7\"] ) ) )\n              \"\\'\" >\n       | < STRING :\n              \"\\\"\"\n              (   (~[\"\\\"\",\"\\\\\",\"\\n\",\"\\r\"])\n                | (\"\\\\\"\n                    ( [\"n\",\"t\",\"b\",\"r\",\"f\",\"\\\\\",\"'\",\"\\\"\"]\n                    | [\"0\"-\"7\"] ( [\"0\"-\"7\"] )?\n                    | [\"0\"-\"3\"] [\"0\"-\"7\"] [\"0\"-\"7\"]\n                    )\n                  )\n              )*\n              \"\\\"\" >\n       | < TEXT : ( \"{{\" (~[\"}\"])* ( \"}\" ~[\"}\"] (~[\"}\"])* )* \"}}\" ) >\n       | < IDENT : [\"a\"-\"z\",\"A\"-\"Z\",\"$\",\"_\"]\n                   ([\"a\"-\"z\",\"A\"-\"Z\",\"0\"-\"9\",\"_\",\"$\"])* > }\n";
    public static String signedNumLexer = "TOKEN: { < INT : (\"+\" | \"-\")? ( ([\"0\"-\"9\"])+ \n                                  | (\"0\" [\"x\",\"X\"]) ([\"0\"-\"9\",\"a\"-\"f\",\"A\"-\"F\"])+ ) >\n       | < DOUBLE : (\"-\")?([\"0\"-\"9\"])+ \".\" ([\"0\"-\"9\"])+ (<EXPON>)?\n                            | \".\" ([\"0\"-\"9\"])+  (<EXPON>)? >\n       | < #EXPON: [\"e\",\"E\"] ([\"+\",\"-\"])? ([\"0\"-\"9\"])+ > }\n" + lexer;
    public static String unsignedNumLexer = "TOKEN: { < INT : ( ([\"0\"-\"9\"])+ \n                 | (\"0\" [\"x\",\"X\"]) ([\"0\"-\"9\",\"a\"-\"f\",\"A\"-\"F\"])+ ) >\n       | < DOUBLE : ([\"0\"-\"9\"])+ \".\" ([\"0\"-\"9\"])+ (<EXPON>)?\n                    | \".\" ([\"0\"-\"9\"])+  (<EXPON>)? >\n       | < #EXPON: [\"e\",\"E\"] ([\"+\",\"-\"])? ([\"0\"-\"9\"])+ > }\n" + lexer;
    public static String parserJava = "byte parse_byte():{ int i; }{\n    i = parse_int() { return (byte)i; }\n}\nByte parse_Byte():{ byte b; }{\n    b = parse_byte() { return b; }\n}\nshort parse_short():{ int i; }{\n    i = parse_int() { return (short)i; }\n}\nShort parse_Short():{ short s; }{\n    s = parse_short() { return s; }\n}\nint parse_int():{ Token t; }{\n    t = <INT>\n    { if(t.image.length() > 1 && Character.toLowerCase(t.image.charAt(1)) == 'x')\n          return Integer.parseInt(t.image.substring(2), 16);\n      return Integer.parseInt(t.image); }\n}\nInteger parse_Integer():{ int i; }{\n    i = parse_int() { return i; }\n}\nlong parse_long():{ Token t; }{\n    t = <INT>\n    { if(t.image.length() > 1 && Character.toLowerCase(t.image.charAt(1)) == 'x')\n          return Long.parseLong(t.image.substring(2), 16);\n    return Long.parseLong(t.image); }\n}\nLong parse_Long():{ long l; }{\n    l = parse_long() { return l; }\n}\ndouble parse_double():{ Token t; }{\n    t = <DOUBLE>\n    { return Double.parseDouble(t.image); }\n}\nDouble parse_Double():{ double d; }{\n    d = parse_double() { return d; }\n}\nfloat parse_float():{ Token t; }{\n    t = <DOUBLE>\n    { return Float.parseFloat(t.image); }\n}\nFloat parse_Float():{ float f; }{\n    f = parse_float() { return f; }\n}\nString parse_String():{ Token t; }{\n    t = <STRING>\n    { return unescape(t.image.substring(1,t.image.length()-1)); }\n}\nboolean parse_boolean():{ Token t; }{\n    t = <TRUE> { return true; } |\n    t = <FALSE> { return false; }\n}\nBoolean parse_Boolean():{ boolean b; }{\n    b = parse_boolean() { return b; }\n}\nchar parse_char():{ Token t; }{\n    t = <CHAR>\n    { return unescape(t.image.substring(1,t.image.length()-1)).charAt(0); }\n}\nCharacter parse_Character():{ char c; }{\n    c = parse_char() { return c; }\n}\nident parse_ident():{ Token t; }{\n    t = <IDENT>\n    { return new ident(t.image); }\n}\nverbatim parse_verbatim():{ Token t; }{\n    t = <TEXT>\n    { return new verbatim(t.image.substring(2,t.image.length()-2)); }\n}\n";
    public static String parserCS = "byte parse_byte():{ int i; }{\n    i = parse_int() { return (byte)i; }\n}\nByte parse_Byte():{ byte b; }{\n    b = parse_byte() { return b; }\n}\nshort parse_short():{ Token t; }{\n    t = <INT>\n    { return Int16.Parse(t.image); }\n}\nInt16 parse_Int16():{ short i; }{\n    i = parse_short() { return i; }\n}\nint parse_int():{ Token t; }{\n    t = <INT>\n    { return Int32.Parse(t.image); }\n}\nInt32 parse_Int32():{ int i; }{\n    i = parse_int() { return i; }\n}\nlong parse_long():{ Token t; }{\n    t = <INT>\n    { return Int64.Parse(t.image); }\n}\nInt64 parse_Int64():{ long l; }{\n    l = parse_long() { return l; }\n}\ndouble parse_double():{ Token t; }{\n    t = <DOUBLE>\n    { return Double.Parse(t.image); }\n}\nDouble parse_Double():{ double d; }{\n    d = parse_double() { return d; }\n}\nfloat parse_float():{ Token t; }{\n    t = <DOUBLE>\n    { return Single.Parse(t.image); }\n}\nSingle parse_Single():{ Single s; }{\n    s = parse_float() { return s; }\n}\nString parse_string():{ Token t; }{\n    t = <STRING>\n    { return t.image.Substring(1,t.image.Length-2); }\n}\nString parse_String():{ string s; }{\n    s = parse_string() { return s; }\n}\nbool parse_bool():{ Token t; }{\n    t = <TRUE> { return true; } |\n    t = <FALSE> { return false; }\n}\nBoolean parse_Boolean():{ bool b; }{\n    b = parse_bool() { return b; }\n}\nchar parse_char():{ Token t; }{\n    t = <CHAR>\n    { return unescapeChar(t.image); }\n}\nChar parse_Char():{ char c; }{\n    c = parse_char() { return c; }\n}\nident parse_ident():{ Token t; }{\n    t = <IDENT>\n    { return new ident(t.image); }\n}\nverbatim parse_verbatim():{ Token t; }{\n    t = <TEXT>\n    { return new verbatim(t.image.Substring(2,t.image.Length-2)); }\n}\n";
    public static String escapeChar = "   public static String escape(char c){\n      switch(c){\n      case '\\n':return \"\\\\n\";  case '\\t':return \"\\\\t\";\n      case '\\b':return \"\\\\b\";  case '\\r':return \"\\\\r\";\n      case '\\f':return \"\\\\f\";  case '\\\\':return \"\\\\\\\\\";\n      case '\\'':return \"\\\\'\"; case '\\\"':return \"\\\\\\\"\";\n      default: return \"\"+c;\n      }\n   }\n";
    public static String escapeMethodsJava = "   public static String escape(String s){\n      char str[] = s.toCharArray();\n      StringBuffer ret = new StringBuffer(\"\");\n      for(char c:str)ret.append(escape(c));\n      return ret.toString();\n   }\n" + escapeChar;
    public static String escapeMethodsCS = "   public static string escape(string s){\n       string ret = \"\";\n       foreach(char c in s)ret += escape(c);\n       return ret;\n   }\n" + escapeChar;
    public static String unescapeMethodJava = "   public static String unescape(String str){\n      String retval = \"\";\n      int index = 0;\n      char ch, ch1;\n      int ordinal = 0;\n      while (index < str.length()) {\n         if(str.charAt(index) != '\\\\') { retval += str.charAt(index++); continue; }\n         ch = str.charAt(++index);\n         if(ch == 'b') { retval += '\\b'; index++; continue; }\n         if(ch == 't') { retval += '\\t'; index++; continue; }\n         if(ch == 'n') { retval += '\\n'; index++; continue; }\n         if(ch == 'f') { retval += '\\f'; index++; continue; }\n         if(ch == 'r') { retval += '\\r'; index++; continue; }\n         if(ch == '\"') { retval += '\\\"'; index++; continue; }\n         if(ch == '\\'') { retval += '\\''; index++; continue; }\n         if(ch == '\\\\') { retval += '\\\\'; index++; continue; }\n         if(ch >= '0' && ch <= '7'){\n            ordinal = ((int)ch) - ((int)'0'); index++;\n            ch1 = str.charAt(index);\n            if(ch1 >= '0' && ch1 <= '7'){\n               ordinal = ordinal*8 + ((int)ch1) - ((int)'0'); index++;\n               ch1 = str.charAt(index);\n               if(ch <= '3' && ch1 >= '0' && ch1 <= '7'){\n                  ordinal = ordinal*8 + ((int)ch1) - ((int)'0'); index++;\n               }\n            }\n            retval += (char)ordinal;\n            continue;\n         }\n         if(ch == 'u'){\n            ordinal = 0;\n            for(int i = 0; i < 4; i++){\n               index++; ch = str.charAt(index);\n               ordinal = ordinal*16+hexval(ch);\n            }\n            index++;\n            retval += (char)ordinal;\n            continue;\n         }\n      }\n      return retval;\n   }\n   static int hexval(char c){\n      int r = \"0123456789ABCDEF\".indexOf(Character.toUpperCase(c));\n      if(r >= 0)return r;\n      throw new RuntimeException(\" ** Bad Escaped Character\");\n   }\n";
    public static String parserBodyCS = "\n    static char unescapeChar(String s){\n        s = s.Substring(1,s.Length-1);        char c = s[0];\n        if (c == '\\\\'){\n            switch (s[1]) {\n            case 'n': return '\\n';  case 't': return '\\t';\n            case 'b': return '\\b';  case 'r': return '\\r';\n            case 'f': return '\\f';  case '\\\\': return '\\\\';\n            case '\\'': return '\\''; case '\\\"': return '\\\"';\n            default: return (char)(Convert.ToInt32(s.Substring(1, s.Length), 8));\n            }\n        }\n        return c;\n    }\n";
    public static String parserBodyJava = "\n" + unescapeMethodJava;
}

