/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TP;
import edu.neu.ccs.demeterf.demfgen.Factory;
import edu.neu.ccs.demeterf.demfgen.classes.BehDef;
import edu.neu.ccs.demeterf.demfgen.classes.BehFile;
import edu.neu.ccs.demeterf.demfgen.classes.CDFile;
import edu.neu.ccs.demeterf.demfgen.classes.ConsList;
import edu.neu.ccs.demeterf.demfgen.classes.DoGen;
import edu.neu.ccs.demeterf.demfgen.classes.EmptyList;
import edu.neu.ccs.demeterf.demfgen.classes.ImportEmpty;
import edu.neu.ccs.demeterf.demfgen.classes.ImportList;
import edu.neu.ccs.demeterf.demfgen.classes.Include;
import edu.neu.ccs.demeterf.demfgen.classes.IncludeList;
import edu.neu.ccs.demeterf.demfgen.classes.LookDef;
import edu.neu.ccs.demeterf.demfgen.classes.NoLook;
import edu.neu.ccs.demeterf.demfgen.classes.RTFileNotFound;
import edu.neu.ccs.demeterf.demfgen.classes.RTParseException;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.YesGen;
import edu.neu.ccs.demeterf.lib.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeCDs {
    public static List<CDFile> resolveCDs(IncludeList l2, String par) {
        return IncludeCDs.resolveCDs(l2, par, new YesGen());
    }

    public static List<CDFile> resolveCDs(IncludeList l2, String par, DoGen g) {
        return (List)Factory.newTraversal(new ReadCDs(par, g)).traverseIncludeList(l2);
    }

    public static List<BehDef> resolveBEHs(IncludeList l2, String par) {
        return IncludeCDs.resolveBEHs(l2, par, new YesGen());
    }

    public static List<BehDef> resolveBEHs(IncludeList l2, String par, DoGen g) {
        return (List)Factory.newTraversal(new ReadBEHs(par, g)).traverseIncludeList(l2);
    }

    public static String localFile(String name2, String inc) {
        if (inc.charAt(0) == File.separatorChar) {
            return inc;
        }
        return String.valueOf(name2.substring(0, name2.lastIndexOf(File.separatorChar) + 1)) + inc;
    }

    public static List<TypeDef> allTypes(List<CDFile> l2) {
        return l2.fold(new List.Fold<CDFile, List<TypeDef>>(){

            @Override
            public List<TypeDef> fold(CDFile f, List<TypeDef> r2) {
                return r2.append((TypeDef)((Object)f.getTypes().toList()));
            }
        }, List.create());
    }

    public static LookDef maxLookAhead(List<CDFile> l2) {
        return l2.fold(new List.Fold<CDFile, LookDef>(){

            @Override
            public LookDef fold(CDFile f, LookDef r2) {
                if (!f.getLook().isLook()) {
                    return r2;
                }
                if (!r2.isLook()) {
                    return f.getLook();
                }
                return f.getLook().look() > r2.look() ? f.getLook() : r2;
            }
        }, new NoLook());
    }

    public static ImportList allImports(List<CDFile> l2) {
        return l2.fold(new List.Fold<CDFile, ImportList>(){

            @Override
            public ImportList fold(CDFile f, ImportList r2) {
                return f.getImports().append(r2);
            }
        }, new ImportEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Read<X>
    extends ID {
        String parFile;
        DoGen gen;

        protected Read(String p, DoGen g) {
            this.parFile = p;
            this.gen = g;
        }

        protected abstract List<X> read(InputStream var1, DoGen var2, String var3) throws Exception;

        protected abstract String type();

        protected DoGen combine(DoGen g) {
            return g;
        }

        protected List<X> combine(Include inc, DoGen g, String file2) {
            String loc = IncludeCDs.localFile(this.parFile, file2);
            try {
                FileInputStream in = new FileInputStream(loc);
                return this.read(in, g.merge(this.gen), loc);
            }
            catch (FileNotFoundException fe) {
                throw new RTFileNotFound(" ** In \"" + this.parFile + "\"\n   Included " + this.type() + " File Not Found : \"" + loc + "\"");
            }
            catch (Exception e2) {
                throw new RTParseException(" ** " + this.type() + " File: \"" + loc + "\"\n" + e2.getMessage());
            }
        }

        protected List<X> combine(ConsList c2, List<X> f, List<X> r2) {
            return r2.push(f);
        }

        protected List<X> combine(EmptyList e2) {
            return List.create();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReadBEHs
    extends Read<BehDef> {
        ReadBEHs(String p, DoGen g) {
            super(p, g);
        }

        @Override
        protected String type() {
            return "BEH";
        }

        @Override
        protected List<BehDef> read(InputStream in, DoGen g, String file2) throws Exception {
            BehFile b = BehFile.parse(in);
            return IncludeCDs.resolveBEHs(b.getIncl(), file2, g).push(b.getBehs().toList());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReadCDs
    extends Read<CDFile> {
        ReadCDs(String p, DoGen g) {
            super(p, g);
        }

        @Override
        protected String type() {
            return "CD";
        }

        @Override
        protected List<CDFile> read(InputStream in, DoGen g, String file2) throws Exception {
            CDFile m = ReadCDs.mergeGen(CDFile.parse(in), g);
            List<CDFile> incl2 = IncludeCDs.resolveCDs(m.getIncl(), file2, g);
            ImportList imp = IncludeCDs.allImports(incl2);
            return incl2.push(m.updateImports(imp.append(m.getImports())));
        }

        static CDFile mergeGen(CDFile m, final DoGen g) {
            if (g.doGen() && g.doParse()) {
                return m;
            }
            return (CDFile)((List)Factory.newTraversal(new TP(){

                DoGen combine(DoGen gen2) {
                    return gen2.merge(g);
                }
            }, Control.builtins(DoGen.class)).traverseList_CDFile_(List.create(m))).top();
        }
    }
}

