/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.DFGTrav;
import edu.neu.ccs.demeterf.demfgen.DFGTravC;
import edu.neu.ccs.demeterf.demfgen.classes.CDFile;
import edu.neu.ccs.demeterf.demfgen.classes.FieldOrSyntax;
import edu.neu.ccs.demeterf.demfgen.classes.IncludeList;
import edu.neu.ccs.demeterf.demfgen.classes.StaticTrav;
import edu.neu.ccs.demeterf.demfgen.classes.StaticTravCtx;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefList;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.parallel.ParTraversal;
import edu.neu.ccs.demeterf.stackless.HeapTrav;

public abstract class Factory {
    static Factory fact = new StaticFactory();

    public static DFGTrav newTraversal(FC f) {
        return fact.newTrav(f);
    }

    public static DFGTrav newTraversal(FC f, Control c2) {
        return fact.newTrav(f, c2);
    }

    public static DFGTravC newTraversalCtx(FC f) {
        return fact.newTravCtx(f);
    }

    public static DFGTravC newTraversalCtx(FC f, Control c2) {
        return fact.newTravCtx(f, c2);
    }

    public abstract DFGTrav newTrav(FC var1);

    public abstract DFGTrav newTrav(FC var1, Control var2);

    public abstract DFGTravC newTravCtx(FC var1);

    public abstract DFGTravC newTravCtx(FC var1, Control var2);

    private static class DynFactory
    extends Factory {
        private DynFactory() {
        }

        public DFGTrav newTrav(FC f) {
            return new Trav(f);
        }

        public DFGTrav newTrav(FC f, Control c2) {
            return new Trav(f, c2);
        }

        public DFGTravC newTravCtx(FC f) {
            return new Trav(f);
        }

        public DFGTravC newTravCtx(FC f, Control c2) {
            return new Trav(f, c2);
        }
    }

    static class HTrav
    extends Trav {
        HTrav(FC f) {
            super(new HeapTrav(f));
        }

        HTrav(FC f, Control c2) {
            super(new HeapTrav(f, c2));
        }
    }

    private static class HeapFactory
    extends Factory {
        private HeapFactory() {
        }

        public DFGTrav newTrav(FC f) {
            return new HTrav(f);
        }

        public DFGTrav newTrav(FC f, Control c2) {
            return new HTrav(f, c2);
        }

        public DFGTravC newTravCtx(FC f) {
            return new HTrav(f);
        }

        public DFGTravC newTravCtx(FC f, Control c2) {
            return new HTrav(f, c2);
        }
    }

    static class PTrav
    extends Trav {
        PTrav(FC f) {
            super(new ParTraversal(f));
        }

        PTrav(FC f, Control c2) {
            super(new ParTraversal(f, c2));
        }
    }

    private static class ParFactory
    extends Factory {
        private ParFactory() {
        }

        public DFGTrav newTrav(FC f) {
            return new PTrav(f);
        }

        public DFGTrav newTrav(FC f, Control c2) {
            return new PTrav(f, c2);
        }

        public DFGTravC newTravCtx(FC f) {
            return new PTrav(f);
        }

        public DFGTravC newTravCtx(FC f, Control c2) {
            return new PTrav(f, c2);
        }
    }

    static class STrav
    extends StaticTrav
    implements DFGTrav {
        STrav(FC f) {
            super(f);
        }

        STrav(FC f, Control c2) {
            super(f, c2);
        }
    }

    static class STravC
    extends StaticTravCtx
    implements DFGTravC {
        STravC(FC f) {
            super(f);
        }

        STravC(FC f, Control c2) {
            super(f, c2);
        }
    }

    private static class StaticFactory
    extends Factory {
        private StaticFactory() {
        }

        public DFGTrav newTrav(FC f) {
            return new STrav(f);
        }

        public DFGTrav newTrav(FC f, Control c2) {
            return new STrav(f, c2);
        }

        public DFGTravC newTravCtx(FC f) {
            return new STravC(f);
        }

        public DFGTravC newTravCtx(FC f, Control c2) {
            return new STravC(f, c2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Trav
    implements DFGTrav,
    DFGTravC {
        Traversal trav;

        Trav(FC f) {
            this(new Traversal(f));
        }

        Trav(FC f, Control c2) {
            this(new Traversal(f, c2));
        }

        Trav(Traversal t) {
            this.trav = t;
        }

        @Override
        public <Ret> Ret traverseList_CDFile_(List<CDFile> o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseTypeDefParams(TypeDefParams o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseTypeDefList(TypeDefList o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseList_TypeDef_(List<TypeDef> o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseList_FieldOrSyntax_(List<FieldOrSyntax> o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseOption_List_TypeDef__(Option<List<TypeDef>> o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseTypeDef(TypeDef o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseIncludeList(IncludeList o) {
            return this.trav.traverse(o);
        }

        @Override
        public <Ret> Ret traverseList_FieldOrSyntax_(List<FieldOrSyntax> o, Object a) {
            return this.trav.traverse(o, a);
        }

        @Override
        public <Ret> Ret traverseList_CDFile_(List<CDFile> o, Object a) {
            return this.trav.traverse(o, a);
        }

        @Override
        public <Ret> Ret traverseTypeDefList(TypeDefList o, Object a) {
            return this.trav.traverse((Object)o, a);
        }

        @Override
        public <Ret> Ret traverseTypeDef(TypeDef o, Object a) {
            return this.trav.traverse((Object)o, a);
        }
    }
}

