/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.demeterf.lib.List;
import java.util.Random;

public class ListTest {
    Random r = new Random();
    int fails = 0;
    int total = 0;

    public static void main(String[] args2) {
        if (args2.length != 1) {
            ListTest.p(" usage: ListTest <length>");
            System.exit(1);
        }
        int len = Integer.parseInt(args2[0]);
        new ListTest().main(len);
    }

    void main(int len) {
        List<Integer> lst = List.buildlist(new List.Build<Integer>(){

            @Override
            public Integer build(int i) {
                return i;
            }
        }, len);
        int rand = this.r.nextInt(len);
        this.test("Length", lst.length() == len);
        this.print("Map-Add1", lst.map(new List.Map<Integer, Integer>(){

            @Override
            public Integer map(Integer i) {
                return i + 1;
            }
        }), len);
        this.print("Append-List", lst.append((Integer)((Object)List.create(len, len + 1, len + 2))), len);
        this.print("Append-Element", lst.append(len), len);
        this.print("Shuffle", lst.shuffle(), len);
        this.print("Shuffle", lst.shuffle(), len);
        this.test("Contains", lst.contains(len - 1));
        this.test("ContainsG", lst.containsG(Long.valueOf(len - 1), new LComp()));
        this.test("Contains", lst.contains(rand));
        this.test("ContainsG", lst.containsG(Long.valueOf(rand), new LComp()));
        this.test("Contains", lst.contains(new Odd()));
        this.test("Contains", lst.contains(new Even()));
        this.test("ContainsAny", lst.containsAny(List.create(1, 3, 5)));
        this.test("ContainsAnyG", lst.containsAnyG(List.create(1L, 3L, 5L), new LComp()));
        this.test("ContainsAny", !lst.containsAny(List.create(-1, -3, -5)));
        this.test("ContainsAnyG", !lst.containsAnyG(List.create(-1L, -3L, -5L), new LComp()));
        this.test("ContainsAll-#t", lst.containsAll(List.create(1, 3, 5)));
        this.test("ContainsAllG-#t", lst.containsAllG(List.create(1L, 3L, 5L), new LComp()));
        this.test("ContainsAll-#f", !lst.containsAll(List.create(-1, 3, 5)));
        this.test("ContainsAllG-#f", !lst.containsAllG(List.create(-1L, -3L, -5L), new LComp()));
        this.test("Find", rand == lst.find(rand));
        this.test("FindG", rand == lst.findG(Long.valueOf(rand), new LComp()));
        this.print("Remove", lst.remove(rand), len);
        this.test("lookup-" + rand + ":" + lst.lookup(rand), rand == lst.lookup(rand));
        this.test("lookup-0", lst.lookup(0) == 0);
        this.print("toString", lst.toString(", ", ""), len);
        this.print("toString", lst.toString(":", " #"), len);
        this.print("Filter-Odd", lst.filter(new Odd()), len);
        this.print("Filter-Even", lst.filter(new Even()), len);
        this.print("foldl:sum:" + len * (len - 1) / 2, lst.foldl(new List.Fold<Integer, Long>(){

            @Override
            public Long fold(Integer i, Long l2) {
                return (long)i.intValue() + l2;
            }
        }, 0L), len);
        this.print("foldr:fact", lst.pop().foldr(new List.Fold<Integer, Long>(){

            @Override
            public Long fold(Integer i, Long l2) {
                return (long)i.intValue() * l2;
            }
        }, 1L), len);
        this.print("add", lst.add(99, 3), len);
        this.print("remove", lst.remove(3), len);
        this.print("sort", List.create(2, 3, 1, 5, 2, 65, 26, 34, 27, 1).sort(new List.Comp<Integer>(){

            @Override
            public boolean comp(Integer a, Integer b) {
                return a < b;
            }
        }), len);
        this.print("zip", lst.zip(new List.Zip<Integer, Integer, String>(){

            @Override
            public String zip(Integer a, Integer b) {
                return a + ":" + b;
            }
        }, List.create(9, 8, 7, 6, 5, 4, 3, 2, 1, 0)), len);
        this.print("replace", List.create(1L, 2L, 3L, 4L, 5L, 6L).replace((Long)4, (Long)99L), len);
        this.print("replace", List.create(1L, 2L, 3L, 4L, 5L, 6L).replace(3L, (Long)99L), len);
        this.print("replaceAll", List.create(1L, 2L, 3L, 3L, 2L, 1L).replaceAll(2L, (Long)99L), len);
        ListTest.p("\n ** Total: " + this.total + "  Failed: " + this.fails + "\n");
    }

    void print(String s2, Object lst, int len) {
        if (len <= 20) {
            ListTest.p(String.valueOf(this.extend(s2, 20)) + " : " + lst);
        }
    }

    String extend(String s2, int i) {
        if (s2.length() < i) {
            return this.extend(" " + s2, i);
        }
        return s2;
    }

    public static void p(String s2) {
        System.out.println(s2);
    }

    public void test(String msg, boolean good) {
        ++this.total;
        if (!good) {
            ListTest.p(" !! Test #" + this.total + " Failed \"" + msg + "\"\n");
            ++this.fails;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Even
    extends List.Pred<Integer> {
        Even() {
        }

        @Override
        public boolean huh(Integer i) {
            return (i & 1) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LComp
    extends List.GComp<Integer, Long> {
        LComp() {
        }

        @Override
        public boolean comp(Integer i, Long l2) {
            return (long)i.intValue() == l2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Odd
    extends List.Pred<Integer> {
        Odd() {
        }

        @Override
        public boolean huh(Integer i) {
            return (i & 1) == 1;
        }
    }
}

