package rules;

import java.util.HashMap;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;

import csp.CSPInstance;
import csp.CSPSolution;

import scg.Claim;
import scg.ParseException;
import scg.net.PlayerSpec;
import scg.net.admin.RemotePlayerProxy;
import scg.protocolInterpreter.AgreementProtocolInterpreter;
import scg.protocolInterpreter.ProtocolInterpreter;
import scg.protocolInterpreter.StrengtheningProtocolInterpreter;

public class TestAgreementProtocolInterpreter {

	private static final double INITIAL_REPUTATION = 100;
	private static final long TIMEOUT = 60;
	private static final double MIN_STRENGTHEN = 0.01;
	private static final double DELTA = 0.8;
	
	private RemotePlayerProxy alice;
	private RemotePlayerProxy bob;

	@Before
	public void init() {
		alice = new RemotePlayerProxy(new PlayerSpec("alice", "localhost", -1), TIMEOUT,
				INITIAL_REPUTATION);
		bob = new RemotePlayerProxy(new PlayerSpec("bob", "localhost", -1), TIMEOUT,
				INITIAL_REPUTATION);
	}

	@Test
	public void test1() throws ParseException, csp.ParseException {
		Claim claim = Claim.parse("csp.CSPInstanceSet {{ (12 22) }} scg.protocol.PositiveSecret {{ }} 0.444444 0.8");
		HashMap<Claim, ProtocolInterpreter> listOfRefutationInterpreter = new HashMap<Claim, ProtocolInterpreter>();
		HashMap<Claim, Claim> newClaimOriginalClaim = new HashMap<Claim, Claim>();
		newClaimOriginalClaim.put(claim, claim);
		AgreementProtocolInterpreter api = new AgreementProtocolInterpreter(alice, bob, claim, MIN_STRENGTHEN);
		api.createRpi(listOfRefutationInterpreter, newClaimOriginalClaim);

		ProtocolInterpreter refutationProtocolInterpreter0 = listOfRefutationInterpreter.values().iterator().next();
		Assert.assertFalse(refutationProtocolInterpreter0.isComplete());
		refutationProtocolInterpreter0.setInstance(CSPInstance.parse("x1 x2 x3 (12 {1} x1 x2 x3)"));
		refutationProtocolInterpreter0.proceed();
		Assert.assertFalse(refutationProtocolInterpreter0.isComplete());
		refutationProtocolInterpreter0.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->false)]"));
		refutationProtocolInterpreter0.proceed();
		refutationProtocolInterpreter0.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->true)]"));
		refutationProtocolInterpreter0.proceed();
		refutationProtocolInterpreter0.proceed();
		//--------		
		api.createRpi(listOfRefutationInterpreter, newClaimOriginalClaim);
		ProtocolInterpreter refutationProtocolInterpreter1 = listOfRefutationInterpreter.values().iterator().next();
		
		Assert.assertFalse(refutationProtocolInterpreter1.isComplete());
		refutationProtocolInterpreter1.setInstance(CSPInstance.parse("x1 x2 x3 (12 {1} x1 x2 x3)"));
		refutationProtocolInterpreter1.proceed();
		Assert.assertFalse(refutationProtocolInterpreter1.isComplete());
		refutationProtocolInterpreter1.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->false)]"));
		refutationProtocolInterpreter1.proceed();
		refutationProtocolInterpreter1.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->true)]"));
		refutationProtocolInterpreter1.proceed();
		refutationProtocolInterpreter1.proceed();
		//--------		
		api.createRpi(listOfRefutationInterpreter, newClaimOriginalClaim);
		ProtocolInterpreter refutationProtocolInterpreter2 = listOfRefutationInterpreter.values().iterator().next();
		Assert.assertFalse(refutationProtocolInterpreter2.isComplete());
		refutationProtocolInterpreter2.setInstance(CSPInstance.parse("x1 x2 x3 (12 {1} x1 x2 x3)"));
		refutationProtocolInterpreter2.proceed();
		Assert.assertFalse(refutationProtocolInterpreter2.isComplete());
		refutationProtocolInterpreter2.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->false)]"));
		refutationProtocolInterpreter2.proceed();
		refutationProtocolInterpreter2.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->true)]"));
		refutationProtocolInterpreter2.proceed();
		refutationProtocolInterpreter2.proceed();
		
		//--------		
		api.createRpi(listOfRefutationInterpreter,newClaimOriginalClaim);
		ProtocolInterpreter refutationProtocolInterpreter3 = listOfRefutationInterpreter.values().iterator().next();
		
		Assert.assertFalse(refutationProtocolInterpreter3.isComplete());
		refutationProtocolInterpreter3.setInstance(CSPInstance.parse("x1 x2 x3 (12 {1} x1 x2 x3)"));
		refutationProtocolInterpreter3.proceed();
		Assert.assertFalse(refutationProtocolInterpreter3.isComplete());
		refutationProtocolInterpreter3.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->false)]"));
		refutationProtocolInterpreter3.proceed();
		refutationProtocolInterpreter3.setSolution(CSPSolution.parse("[(x1->true) (x2->true) (x3->true)]"));
		refutationProtocolInterpreter3.proceed();
		refutationProtocolInterpreter3.proceed();
		
		
		Assert.assertTrue(api.isComplete());
		Assert.assertTrue(api.areAllStepsExecuted());
//		Assert.assertTrue(api.checkResult());
		
//		Assert.assertEquals(-1d, api.getResult()); // Bob Wins
		Assert.assertEquals(INITIAL_REPUTATION, bob.getReputation());
		Assert.assertEquals(INITIAL_REPUTATION, alice.getReputation());

	}

}
