package nwf;

import java.util.Iterator;

import junit.framework.Assert;
import nwf.avatar.NWFAvatar;

import org.junit.Ignore;
import org.junit.Test;

import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Some;

import scg.Claim;
import scg.Config;
import scg.SolveRequest;
import scg.protocol.ForAllExists;


public class TestNWFAvatar {

	@Test
	public void testSolve() throws ParseException {
		Config cfg = NWFConfig.getDefaultConfig();
		NWFAvatar avatar = new NWFAvatar(cfg);
		
		String inpt = "instance " +
		"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
		"\"1\" successors (\"t\" c 15 f 0) " +
		"\"2\" successors (\"t\" c 10 f 0) " +
		"\"t\" successors () " +
		"source \"s\" " +
		"sink \"t\"";
		
		NWFInstance instance = NWFInstance.parse(inpt);
		NWFInstanceSet nwfInstanceSet =
			new NWFInstanceSet(instance);
		Claim claim = new Claim(nwfInstanceSet, ForAllExists.getInstance(),
				0.5, 0.5);
		SolveRequest solveRequest = new SolveRequest(instance, new Some<Claim>(claim));
		NWFSolution solution = (NWFSolution)avatar.solve(solveRequest);
		
		System.out.println(solution.print());
		
	}
	
	@Ignore
	@Test
	public void testPropose() throws ParseException {
		
		
		
		Config cfg = NWFConfig.getDefaultConfig();
		NWFAvatar avatar = new NWFAvatar(cfg);
		
		List<Claim> proposeClaims = avatar.propose(new Empty<Claim>());
		Iterator<Claim> ic = proposeClaims.iterator();
		
		for (; ic.hasNext();) {
			Claim c = ic.next();
			// print out all the instanceset to see 
			// whether all of them have the right shape.
			System.out.println(c.print());
		}
		
	}
}
