package nwf;

import nwf.NWFInstanceSet;
import junit.framework.Assert;

import org.junit.Ignore;
import org.junit.Test;

import edu.neu.ccs.demeterf.lib.None;

import scg.Claim;
import scg.Config;
import scg.InstanceI;
import scg.InstanceSetI;
import scg.SolutionI;

public class TestNWF {


	@Test
	public void testNWFInstance() throws ParseException {
		InstanceI instance = NWFInstance.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		Assert.assertTrue(instance instanceof NWFInstance);
		
		NWFInstance nwfInstance = (NWFInstance) instance;
		String s1 = nwfInstance.getSink().getV();
		String s2 = nwfInstance.getSource().getV();
		
		Assert.assertTrue(s1.equals("t"));
		Assert.assertTrue(s2.equals("s"));
		
	}
	
	@Test
	public void testNWFSolution() throws ParseException {
		SolutionI solution = NWFSolution.parse("solution " +
				"\"s\" successors (\"1\" c 20 f 10 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 10) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		Assert.assertTrue(solution instanceof NWFSolution);
		
		NWFSolution nwfSolution = (NWFSolution) solution;
		String s1 = nwfSolution.getSink().getV();
		String s2 = nwfSolution.getSource().getV();
		
		Assert.assertTrue(s1.equals("t"));
		Assert.assertTrue(s2.equals("s"));
	}
	
	@Test
	public void testNWFInstanceSet() throws ParseException {
		InstanceSetI instanceSet = NWFInstanceSet.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		Assert.assertTrue(instanceSet instanceof NWFInstanceSet);
		
		NWFInstanceSet nwfInstanceSet = (NWFInstanceSet) instanceSet;
		NWFInstance nwfInstance = NWFInstance.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		Assert.assertEquals(nwfInstance, nwfInstanceSet.getSingleton());
	}
	
	@Ignore
	@Test
	public void testClaim() throws ParseException, scg.ParseException {
		
		String instance = "instance " +
		"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
		"\"1\" successors (\"t\" c 15 f 0) " +
		"\"2\" successors (\"t\" c 10 f 0) " +
		"\"t\" successors () " +
		"source \"s\" " +
		"sink \"t\"";
		
		Claim claim = Claim.parse("nwf.NWFInstanceSet {{" + instance + "}} scg.protocol.ForAllExists {{ }} 0.5 0.5");
		Assert.assertEquals(0.5, claim.getQuality());
		NWFInstanceSet hsrInstanceSet = (NWFInstanceSet)claim.getInstanceSet();
		Assert.assertEquals(instance, hsrInstanceSet.print());
		Assert.assertEquals("scg.protocol.ForAllExists", claim.getProtocol().getClass().getCanonicalName().replaceAll(" ",""));
	}
	
	@Test
	public void testBelongsTo() throws ParseException {
		NWFInstance nwfInstance = NWFInstance.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		NWFInstanceSet nwfInstanceSet = NWFInstanceSet.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		boolean b = nwfInstanceSet.belongsTo(nwfInstance) instanceof None<?>;
		Assert.assertTrue(b);
	}
	
	@Test
	public void testQuality() throws ParseException {

		NWFInstance instance 
		    = NWFInstance.parse("instance " +
					"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
					"\"1\" successors (\"t\" c 15 f 0) " +
					"\"2\" successors (\"t\" c 10 f 0) " +
					"\"t\" successors () " +
					"source \"s\" " +
					"sink \"t\"");
		
		NWFSolution solution = NWFSolution.parse("solution " +
				"\"s\" successors (\"1\" c 20 f 10 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 10) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
        Assert.assertEquals((double) 1/3, instance.quality(solution));
	}
	
	@Test
	public void testValid() throws ParseException {
		
		NWFInstance instance 
	    = NWFInstance.parse("instance " +
				"\"s\" successors (\"1\" c 20 f 0 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 0) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		NWFSolution solution = NWFSolution.parse("solution " +
				"\"s\" successors (\"1\" c 20 f 10 \"2\" c 10 f 0 ) " +
				"\"1\" successors (\"t\" c 15 f 10) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		// should valid the edge number? 
		NWFSolution inValidSolution = NWFSolution.parse("solution " +
				"\"s\" successors (\"1\" c 20 f 10) " +
				"\"1\" successors (\"t\" c 15 f 16) " +
				"\"2\" successors (\"t\" c 10 f 0) " +
				"\"t\" successors () " +
				"source \"s\" " +
				"sink \"t\"");
		
		Config config = NWFConfig.getDefaultConfig();
		Assert.assertEquals(1d, instance.valid(solution, config));
		Assert.assertEquals(0d, instance.valid(inValidSolution, config));
	}

}
