package network;

import junit.framework.Assert;

import org.junit.Ignore;
import org.junit.Test;

import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;

import scg.net.ParseException;
import scg.net.PasswordEntry;
import scg.net.PasswordFile;
import scg.net.PlayerSpec;


public class TestNetWork {

	/**
	 * test changeAddress and create, functions
	 * @throws ParseException 
	 */
	@Test
	public void testPlayerSpec() throws ParseException {

		PlayerSpec ps1 = PlayerSpec.parse("playerspec[ \"test:a\" \"127.0.0.1\" 8888 ]");
		boolean result1 = ps1.samePrefixPred().huh(ps1);
		Assert.assertFalse(result1);
		
		PlayerSpec ps2 = PlayerSpec.parse("playerspec[ \"test\" \"127.0.0.1\" 8888 ]");
		boolean result2 = ps2.samePrefixPred().huh(ps2);
		Assert.assertTrue(result2);
	}
	
	@Test
	public void testPasswordFile() throws ParseException {
		List<PasswordEntry> pwEntryList = List.create();
		
		String input = "passwd[ \"aa\" \"hash-aa\"] passwd[ \"bb\" \"hash-bb\"]";
		PasswordFile passwordFile = PasswordFile.parse(input);
		
		Map<String, String> passwordMap = passwordFile.getPasswordMap();
		
		Assert.assertEquals(passwordMap.get("aa"), "hash-aa");
		Assert.assertEquals(passwordMap.get("bb"), "hash-bb");
	    
	}
}
