package hsr;

import hsr.avatar.HSRAvatar;

import java.util.Iterator;

import junit.framework.Assert;
import org.junit.Test;

import scg.Claim;
import scg.Config;
import scg.OpposeAction;
import scg.ParseException;
import scg.SolveRequest;
import scg.protocol.ForAllExists;
import csp.CSPConfig;
import csp.CSPInstance;
import csp.CSPInstanceSet;
import csp.CSPSolution;
import csp.Clause;
import csp.Var;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Some;

public class TestHSRAvatar {
	
	//testing solve method of avatar
	@Test
	public void testSolve(){
		Config cfg = HSRConfig.getDefaultConfig();
		HSRAvatar avatar = new HSRAvatar(cfg);
		
		HSRInstance instance = new HSRInstance(9,3);
		HSRInstanceSet hsrInstanceSet = new HSRInstanceSet(instance);
		Claim claim = new Claim(hsrInstanceSet, ForAllExists.getInstance(), 0.44444, 0.44444);
		SolveRequest solveRequest = new SolveRequest(instance, new Some<Claim>(claim));
		HSRSolution solution = (HSRSolution)avatar.solve(solveRequest);
		Assert.assertEquals("HSR(9,3)", instance.print());
		Assert.assertEquals("(1 y h 0 n (2 y h 1 n (3 y h 2 n (4 y h 3 n (5 y h 4 n (6 y h 5 n (7 y h 6 n (8 y h 7 n h 8))))))))", solution.print());
	    
		Assert.assertEquals(8, solution.findDepth());
	}

	//testing propose method of avatar
	@Test
	public void testPropose() {
		Config cfg = HSRConfig.getDefaultConfig();
		HSRAvatar avatar = new HSRAvatar(cfg);
		HSRInstance instance = new HSRInstance(9,3);
		HSRInstanceSet hsrInstanceSet = new HSRInstanceSet(instance);
		Claim claim = new Claim(hsrInstanceSet, ForAllExists.getInstance(), 0.44444, 0.44444);
		
		List<Claim> claims = avatar.propose(new Empty<Claim>());
		
		for(Claim calim: claims){
			Assert.assertEquals("HSR(9,3)", ((HSRInstanceSet)claim.getInstanceSet()).print());
			Assert.assertEquals("scg.protocol.ForAllExists", claim.getProtocol().getClass().getName());
			Assert.assertEquals(0.44444, claim.getQuality());	
		}
	}

	//testing oppose method of avatar
	@Test
	public void testOppose() {
		Config cfg = HSRConfig.getDefaultConfig();
		HSRAvatar avatar = new HSRAvatar(cfg);
		HSRInstance instance = new HSRInstance(9,3);
		HSRInstanceSet hsrInstanceSet = new HSRInstanceSet(instance);
		Claim claim = new Claim(hsrInstanceSet, ForAllExists.getInstance(), 0.44444, 0.44444);
		List<Claim> claims = avatar.propose(new Empty<Claim>());
		
		List<Claim> claims1 = List.create();
		claims1 = claims.append(claim);
		Assert.assertEquals("HSR(9,3)", ((HSRInstanceSet)claim.getInstanceSet()).print());
		Assert.assertEquals("scg.protocol.ForAllExists", claim.getProtocol().getClass().getName());
		Assert.assertEquals(0.44444d, claim.getQuality());		
	}
	
	@Test
	public void testProvide() throws ParseException {
		Config cfg = HSRConfig.getDefaultConfig();
		HSRAvatar avatar = new HSRAvatar(cfg);
		
		Claim claim = Claim.parse("hsr.HSRInstanceSet {{  HSR (9,2) }} scg.protocol.ForAllExists {{ }} 0.44444 0.44444");
		HSRInstance instance = (HSRInstance) avatar.provide(claim);
		
		Assert.assertEquals(2, instance.getK());
		Assert.assertEquals(9, instance.getN());
		
	}
}
