package hsr;

import junit.framework.Assert;

import org.junit.Ignore;
import org.junit.Test;

import csp.CSPConfig;
import scg.SolutionI;
import scg.InstanceI;
import scg.InstanceSetI;
import hsr.HSRConfig;
import hsr.HSRInstance;
import hsr.HSRInstanceSet;
import hsr.HSRSolution;
import hsr.avatar.HSRAvatar;
import scg.Claim;
import scg.Config;
import scg.OpposeAction;
import scg.SCGConfig;
import scg.SolveRequest;
import scg.TournamentStyle;
import scg.protocol.ForAllExists;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.lib.Some;
import hsr.avatar.HSRAvatar;


public class TestHSR {

	@Test
	public void testConfig() throws Exception{
		Config cfg = HSRConfig.getDefaultConfig();
		SCGConfig scg_cfg = cfg.getScgCfg();
		Assert.assertEquals("full round-robin", scg_cfg.getTournamentStyle().print());
		Assert.assertEquals(60,scg_cfg.getTurnDuration());
		Assert.assertEquals(20,scg_cfg.getMaxNumAvatars());
		Assert.assertEquals(0.01,scg_cfg.getMinStrengthening());
		Assert.assertEquals(100.0,scg_cfg.getInitialReputation());
		Assert.assertEquals(1000.0,scg_cfg.getMaxReputation());
		Assert.assertEquals(0.4,scg_cfg.getReputationFactor());
		Assert.assertEquals(2,scg_cfg.getMinProposals());
		Assert.assertEquals(5,scg_cfg.getMaxProposals());
		Assert.assertEquals(9,scg_cfg.getNumRounds());
		Assert.assertTrue(scg_cfg.getProposedClaimMustBeNew());
		HSRConfig hsr_cfg = HSRConfig.getDefaultDomainConfig();
		Assert.assertEquals(hsr_cfg.getMaxN(), 10000);
	}
	
	@Test

	public void testClaim() throws Exception {
		String inpt = "hsr.HSRInstanceSet {{ HSR (9,2) }} scg.protocol.ForAllExists {{    }} 0.44444 0.44444";
		Claim claim = Claim.parse(inpt);
		Assert.assertEquals(0.44444, claim.getQuality());
		HSRInstanceSet hsrInstanceSet = (HSRInstanceSet)claim.getInstanceSet();
		Assert.assertEquals("HSR(9,2)", hsrInstanceSet.print());
		Assert.assertEquals("scg.protocol.ForAllExists", claim.getProtocol().getClass().getCanonicalName().replaceAll(" ",""));
		System.out.println(claim.print());
		System.out.println(inpt);
		Assert.assertEquals(inpt, claim.print());
		
		
	}
	
	@Test
	public void testHSRInstance() throws Exception {
		String inpt = "HSR(9,3)";
		InstanceI instance = HSRInstance.parse(inpt);
		Assert.assertTrue(instance instanceof HSRInstance);
		HSRInstance hsrInstance = (HSRInstance) instance;
		Assert.assertEquals(3, hsrInstance.getK());
		Assert.assertEquals(9, hsrInstance.getN());
		Assert.assertEquals(inpt, hsrInstance.print());
		}
	
	@Test
	public void testHSRSolution() throws Exception {
		String inpt = "(7 y (3 y (1 y h 0 n (2 y h 1 n h 2)) n (5 y (4 y h 3 n h 4) n (6 y h 5 n h 6))) n h 7)";
		SolutionI solution = HSRSolution.parse(inpt);
		Assert.assertTrue(solution instanceof HSRSolution);
		HSRSolution hsrSolution = (HSRSolution) solution;
		Assert.assertEquals(4, hsrSolution.findDepth());
		Assert.assertEquals(inpt, hsrSolution.print());
	}
	
	@Test
	public void testHSRInstanceSet() throws Exception {
		String inpt = "HSR(9,2)";
		InstanceSetI instanceSet = HSRInstanceSet.parse(inpt);
		Assert.assertTrue(instanceSet instanceof HSRInstanceSet);
		HSRInstanceSet hsrInstanceSet = (HSRInstanceSet) instanceSet;
		HSRInstance hsrInstance = new HSRInstance(9,2);
		Assert.assertEquals(hsrInstance, hsrInstanceSet.getSingleton());
		Assert.assertEquals(inpt, hsrInstanceSet.print());
	}
	
	
	@Test
	public void testValid() throws Exception {
		HSRInstance hsrInstance = HSRInstance.parse("HSR(9,3)");
		HSRSolution hsrSolutionInvalidIncomplete = HSRSolution.parse("(7 y (3 y (1 y h 0 n (2 y h 1 n h 2)) n (5 y (4 y h 3 n h 4) n (6 y h 5 n h 6))) n h 7)");
		//HSRSolution hsrSolutionInvalidExtra = HSRSolution.parse("(7 y ( 3 y ( 1 y ( 2 y h 0 n h 1))))");
		HSRSolution hsrSolutionValid = HSRSolution.parse("(7 y ( 3 y ( 1 y h 0 n ( 2 y h 1 n h 2 )) n ( 5 y ( 4 y h 3 n h 4 ) n ( 6 y h 5 n h 6 ))) n ( 8 y h 7 n h 8 ) ) ");
		Assert.assertEquals(0d,hsrInstance.valid(hsrSolutionInvalidIncomplete,HSRConfig.getDefaultConfig()));
		//Assert.assertEquals(0d,hsrInstance.valid(hsrSolutionInvalidExtra));
		Assert.assertEquals(1d,hsrInstance.valid(hsrSolutionValid,HSRConfig.getDefaultConfig()));
		
	}
	
	@Test
	public void testQuality() throws ParseException {
		HSRInstance hsrInstance = HSRInstance.parse("HSR(9,4)");
		HSRSolution hsrSolutionValid = HSRSolution.parse("(7 y ( 3 y ( 1 y h 0 n ( 2 y h 1 n h 2 )) n ( 5 y ( 4 y h 3 n h 4 ) n ( 6 y h 5 n h 6 ))) n ( 8 y h 7 n h 8 ) ) ");
	    Assert.assertEquals(4/9d, hsrInstance.quality(hsrSolutionValid));
	}
	
	@Test
	public void testBelongTo() throws Exception {
		HSRInstance hsrInstance = HSRInstance.parse("HSR(9,3)");
		HSRInstanceSet hsrInstanceSet = HSRInstanceSet.parse("HSR(9,3)");
		Assert.assertEquals(hsrInstance, hsrInstanceSet.getSingleton());
	}
}
