package scg.tournament;

import scg.Util;

public class Session {
  public static final long EXPIRATION_MILLIS = 1000 * 60 * 10; // 10 Mins
  private final String _key;
  private final User _user;
  private final long _expire;

  public Session(User user) {
    _user = user;
    long now = System.currentTimeMillis();
    _key = Util.encrypt(_user.getName() + now);
    _expire = now + EXPIRATION_MILLIS;
  }

  public String getKey() {
    return _key;
  }

  public User getUser() {
    return _user;
  }

  public boolean hasExpired() {
    return System.currentTimeMillis() > _expire;
  }
}
