// ** This file was generated with DemFGen (vers:4/15/2011)

package csp;

import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.lib.*;
import scg.*;
import java.util.Iterator;





/** Representation of CSPInstanceSet */
public class CSPInstanceSet implements InstanceSetI{
    protected ListSet<Integer> type;

    /** Construct a(n) CSPInstanceSet Instance */
    public CSPInstanceSet(ListSet<Integer> type){
        this.type = type;
    }
    /** Is the given object Equal to this CSPInstanceSet? */
    public boolean equals(Object o){
        if(!(o instanceof CSPInstanceSet))return false;
        if(o == this)return true;
        CSPInstanceSet oo = (CSPInstanceSet)o;
        return (((Object)type).equals(oo.type));
    }
    /** Parse an instance of CSPInstanceSet from the given String */
    public static CSPInstanceSet parse(String inpt) throws csp.ParseException{
        return new csp.TheParser(new java.io.StringReader(inpt)).parse_CSPInstanceSet();
    }
    /** Parse an instance of CSPInstanceSet from the given Stream */
    public static CSPInstanceSet parse(java.io.InputStream inpt) throws csp.ParseException{
        return new csp.TheParser(inpt).parse_CSPInstanceSet();
    }
    /** Parse an instance of CSPInstanceSet from the given Reader */
    public static CSPInstanceSet parse(java.io.Reader inpt) throws csp.ParseException{
        return new csp.TheParser(inpt).parse_CSPInstanceSet();
    }

    /** Field Class for CSPInstanceSet.type */
    public static class type extends edu.neu.ccs.demeterf.Fields.any{}

        /** Is this a valid/well-formed Instance of the given instance? */
        public Option<String> belongsTo(InstanceI instance){
        	//check if relnum in each clause is present in InstanceSet
        	CSPInstance i = (CSPInstance)instance;
        	boolean valid = true;
        	for(Iterator<Clause> clauses = i.getClauses().iterator(); clauses.hasNext();){
        		Clause clause = clauses.next();
        		valid &= getType().contains(clause.getRelnum());
        	}
        	if(!valid){
        		return new Some<String>("The instance " + i.print() + " is different from " + this.print() + ".");
        	}
        	return new None<String>();
        }        
        
        /** Is this a valid/well-formed InstanceSet? */
	    public Option<String> valid(Config config){
	       //Semantic checks
	       for(Iterator<Integer> relnums = getType().iterator(); relnums.hasNext();){
	    		 int relnum = relnums.next();
	    		 if(relnum < 0){
			    	   return new Some<String>("The Instance set has a relnum < 0");
			       }else if(relnum > 255){
			    	   return new Some<String>("The Instance set has a relnum > 255");
			       }
	    	 }
	    	 return new None<String>();
	    }    

    /** DGP method from Class Display */
    public String display(){ return csp.Display.DisplayM(this); }
    /** DGP method from Class Print */
    public String print(){ return csp.Print.PrintM(this); }
    /** DGP method from Class ToStr */
    public String toStr(){ return csp.ToStr.ToStrM(this); }
    /** DGP method from Class PrintToString */
    public String toString(){ return csp.PrintToString.PrintToStringM(this); }
    /** DGP method from Class HashCode */
    public int hashCode(){ return csp.HashCode.HashCodeM(this); }
    /** Setter for field CSPInstanceSet.type */
    public void setType(ListSet<Integer> _type){ type = _type; }
    /** Getter for field CSPInstanceSet.type */
    public ListSet<Integer> getType(){ return type; }

}


