/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Set;
import edu.neu.ccs.demeterf.lib.Wrap;
import java.util.Comparator;
import java.util.Iterator;

public class ListSet<X>
implements Iterable<X> {
    protected final List<Wrap<X>> list;
    private final Comparator<X> comp;

    private ListSet(List<X> l2, Comparator<X> c2) {
        this(c2, l2.map(new Set.Wrapper<X>(c2)).removeDuplicates().sort(new Wrap.LComp()));
    }

    public ListSet(List<Wrap<X>> l2) {
        this(new Wrap.CComp(), l2.removeDuplicates().sort(new Wrap.LComp()));
    }

    public static <X extends Comparable<X>> ListSet<X> create() {
        return new ListSet<X>(List.create());
    }

    public static <X> ListSet<X> create(Comparator<X> c2) {
        return new ListSet<X>(c2, List.create());
    }

    public static <X extends Comparable<X>> ListSet<X> create(List<X> l2) {
        return new ListSet<X>(l2.map(new Set.Wrapper(new Wrap.CComp())));
    }

    public static <X> ListSet<X> create(List<X> l2, Comparator<X> c2) {
        return new ListSet<X>(l2, c2);
    }

    public static <X extends Comparable<X>> ListSet<X> create(X ... xs) {
        return new ListSet<X>(List.create(xs), new Wrap.CComp());
    }

    private ListSet(Comparator<X> c2, List<Wrap<X>> l2) {
        this.comp = c2;
        this.list = l2;
    }

    private ListSet<X> make(List<Wrap<X>> lst) {
        return new ListSet<X>(this.comp, lst);
    }

    private List<Wrap<X>> toWrapList() {
        return this.list;
    }

    public boolean contains(X x2) {
        return this.list.contains(new Wrap<X>(x2, this.comp));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.length();
    }

    public ListSet<X> add(X x2) {
        Wrap<X> w = new Wrap<X>(x2, this.comp);
        return this.list.contains(w) ? this : this.make(this.list.insert(new Wrap<X>(x2, this.comp), new Wrap.LComp()));
    }

    public ListSet<X> remove(X x2) {
        return this.make(this.list.remove(new Wrap<X>(x2, this.comp)));
    }

    public boolean subseteq(ListSet<X> s2) {
        return s2.list.containsAll(this.list);
    }

    public ListSet<X> union(ListSet<X> s2) {
        return this.make(this.list.push(s2.list.filterout(new InList<X>(s2.list))));
    }

    public ListSet<X> intersect(ListSet<X> s2) {
        return this.make(this.toWrapList().filter(new InList<X>(s2.list)));
    }

    public ListSet<X> difference(ListSet<X> s2) {
        return this.make(this.toWrapList().filterout(new InList<X>(s2.list)));
    }

    public List<X> toList() {
        return this.toWrapList().map(new Set.UnWrapper());
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    public ListSet<X> merge(ListSet<X> s2, Map.Merge<X> m) {
        return this.make(super.toWrapList().fold(new Merger(m), this.list));
    }

    public ListSet<X> merge(X x2, Map.Merge<X> m) {
        Wrap<X> w = new Wrap<X>(x2, this.comp);
        if (!this.list.contains(w)) {
            return this.make(this.list.insert(w, new Wrap.LComp()));
        }
        int i = this.list.index(w);
        return this.make(this.list.replace((Wrap<Wrap<X>>)i, (Wrap<Wrap<X>>)new Wrap<X>(m.merge(w.x, this.list.lookup((int)i).x), this.comp)));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ListSet)) {
            return false;
        }
        ListSet s2 = (ListSet)o;
        return s2.size() == this.size() && this.list.equals(s2.list);
    }

    public String toString() {
        return "{ " + this.toList().toString(" ", "") + " }";
    }

    public int hashCode() {
        return 3 * this.list.hashCode();
    }

    public <Y extends Comparable<Y>> ListSet<Y> map(List.Map<X, Y> m) {
        return ListSet.create(this.toList().map(m));
    }

    public <Y> ListSet<Y> map(List.Map<X, Y> m, Comparator<Y> c2) {
        return ListSet.create(this.toList().map(m), c2);
    }

    static class InList<X>
    extends List.Pred<Wrap<X>> {
        List<Wrap<X>> l;

        InList(List<Wrap<X>> ll) {
            this.l = ll;
        }

        @Override
        public boolean huh(Wrap<X> x2) {
            return this.l.contains(x2);
        }
    }

    class Merger
    extends List.Fold<Wrap<X>, List<Wrap<X>>> {
        Map.Merge<X> m;

        Merger(Map.Merge<X> mm) {
            this.m = mm;
        }

        @Override
        public List<Wrap<X>> fold(Wrap<X> w, List<Wrap<X>> r2) {
            if (!r2.contains(w)) {
                return r2.insert(w, new Wrap.LComp());
            }
            int i = r2.index(w);
            return r2.replace((Wrap)i, (Wrap)new Wrap(this.m.merge(w.x, r2.lookup((int)i).x), ListSet.this.comp));
        }
    }

    public static class list
    extends Fields.any {
    }
}

