/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.List;
import java.util.Comparator;

public class Entry<Key, Val>
implements Comparable<Entry<Key, Val>> {
    protected final Key key;
    protected final Val val;
    private final Comparator<Key> comp;

    public Entry(Key k, Val v2) {
        this(k, v2, new CComp());
    }

    private Entry(Key k, Val v2, Comparator<Key> c2) {
        this.key = k;
        this.val = v2;
        this.comp = c2;
    }

    @Override
    public int compareTo(Entry<Key, Val> e2) {
        return this.comp.compare(this.key, e2.key);
    }

    public Key getKey() {
        return this.key;
    }

    public Val getVal() {
        return this.val;
    }

    public String toString() {
        return "(" + this.key + " -> " + this.val + ")";
    }

    public static <Key extends Comparable<Key>, Val> Entry<Key, Val> create(Key k, Val v2) {
        return new Entry<Key, Val>(k, v2, new CComp());
    }

    public static <Key, Val> Entry<Key, Val> create(Key k, Val v2, Comparator<Key> c2) {
        return new Entry<Key, Val>(k, v2, c2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Entry)) {
            return false;
        }
        return this.comp.compare(this.key, ((Entry)o).key) == 0 && this.val.equals(((Entry)o).val);
    }

    public int hashCode() {
        return this.key.hashCode() + 3 * this.val.hashCode();
    }

    static class CComp<Key>
    implements Comparator<Key> {
        CComp() {
        }

        @Override
        public int compare(Key a, Key b) {
            return ((Comparable)a).compareTo(b);
        }
    }

    static class EComp<K, V>
    extends List.Comp<Entry<K, V>> {
        Comparator<K> c;

        EComp(Comparator<K> cc) {
            this.c = cc;
        }

        @Override
        public boolean comp(Entry<K, V> a, Entry<K, V> b) {
            return this.c.compare(a.getKey(), b.getKey()) == 0;
        }
    }

    static class KPred<K, V>
    extends List.Pred<Entry<K, V>> {
        K key;
        Comparator<K> c;

        KPred(K k, Comparator<K> cc) {
            this.key = k;
            this.c = cc;
        }

        @Override
        public boolean huh(Entry<K, V> e2) {
            return this.c.compare(this.key, e2.getKey()) == 0;
        }
    }

    static class LComp<K, V>
    extends List.Comp<Entry<K, V>> {
        Comparator<K> c;

        LComp(Comparator<K> cc) {
            this.c = cc;
        }

        @Override
        public boolean comp(Entry<K, V> a, Entry<K, V> b) {
            return this.c.compare(a.getKey(), b.getKey()) <= 0;
        }
    }

    public static class key
    extends Fields.any {
    }

    public static class val
    extends Fields.any {
    }
}

