/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lexer.classes;

import edu.neu.ccs.demeterf.lexer.classes.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
            ++i;
        }
        String retval = "Encountered \"";
        Token tok2 = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok2.kind == 0) {
                retval = String.valueOf(retval) + this.tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + this.add_escapes(tok2.image);
            tok2 = tok2.next;
            ++i2;
        }
        retval = String.valueOf(retval) + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retval = String.valueOf(retval) + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + this.eol + "    " : String.valueOf(retval) + "Was expecting one of:" + this.eol + "    ";
        retval = String.valueOf(retval) + expected.toString();
        return retval;
    }

    protected String add_escapes(String str2) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str2.length()) {
            switch (str2.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch2 = str2.charAt(i);
                    if (ch2 < ' ' || ch2 > '~') {
                        String s2 = "0000" + Integer.toString(ch2, 16);
                        retval.append("\\u" + s2.substring(s2.length() - 4, s2.length()));
                        break;
                    }
                    retval.append(ch2);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

