/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.parallel;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

public class ParTraversal2
extends Traversal {
    private boolean parallel = true;

    public ParTraversal2(FC f) {
        super(f);
    }

    public ParTraversal2(FC f, Control c2) {
        super(f, c2);
    }

    @Override
    public <Ret> Ret traverse(Object o) {
        Class<?> c2 = o.getClass();
        if (this.control.isBuiltIn(c2)) {
            return (Ret)this.applyBuilder(new Object[]{o}, true);
        }
        List<Field> fl = Util.getFuncFields(c2);
        int len = fl.length();
        Object[] ret2 = new Object[len + 1];
        ret2[0] = o;
        try {
            SubTravP[] subs = new SubTravP[len - 1];
            int i = 0;
            for (Field f : fl.pop()) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                subs[i++] = new SubTravS(f.get(o), this);
            }
            Field fst = fl.top();
            if (!fst.isAccessible()) {
                fst.setAccessible(true);
            }
            ret2[1] = this.traverse(fst.get(o));
            ++len;
            i = 2;
            while (i < len) {
                ret2[i] = subs[i - 2].waitDone();
                ++i;
            }
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        return (Ret)this.applyBuilder(ret2, false);
    }

    public <Ret> Ret traverseP(Object o) {
        Class<?> c2 = o.getClass();
        if (this.control.isBuiltIn(c2)) {
            return (Ret)this.applyBuilder(new Object[]{o}, true);
        }
        List<Field> fl = Util.getFuncFields(c2);
        int len = fl.length();
        Object[] ret2 = new Object[len + 1];
        ret2[0] = o;
        try {
            SubTravS[] subs = new SubTravS[len - 1];
            int i = 0;
            for (Field f : fl.pop()) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                subs[i++] = new SubTravS(f.get(o), this);
            }
            Field fst = fl.top();
            if (!fst.isAccessible()) {
                fst.setAccessible(true);
            }
            ret2[1] = this.traverse(fst.get(o));
            ++len;
            i = 2;
            while (i < len) {
                ret2[i] = subs[i - 2].waitDone();
                ++i;
            }
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        return (Ret)this.applyBuilder(ret2, false);
    }

    public <Ret> Ret traverseS(Object o) {
        Class<?> c2 = o.getClass();
        if (this.control.isBuiltIn(c2)) {
            return (Ret)this.applyBuilder(new Object[]{o}, true);
        }
        List<Field> fl = Util.getFuncFields(c2);
        int len = fl.length();
        Object[] ret2 = new Object[len + 1];
        ret2[0] = o;
        try {
            int i = 1;
            for (Field f : fl) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                ret2[i++] = this.traverseS(f.get(o));
            }
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        return (Ret)this.applyBuilder(ret2, false);
    }

    static class SubTravP
    extends Thread {
        final Object tobj;
        final ParTraversal2 trav;
        Object res;
        boolean done = false;

        SubTravP(Object o, ParTraversal2 t) {
            this.tobj = o;
            this.trav = t;
            this.start();
        }

        @Override
        public void run() {
            long t = System.currentTimeMillis();
            this.setDone(this.trav.traverseP(this.tobj));
            System.out.println("THREAD : " + (System.currentTimeMillis() - t));
        }

        synchronized void setDone(Object r2) {
            this.res = r2;
            this.done = true;
            this.notify();
        }

        synchronized Object waitDone() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            }
            return this.res;
        }
    }

    static class SubTravS
    extends SubTravP {
        SubTravS(Object o, ParTraversal2 t) {
            super(o, t);
        }

        @Override
        public void run() {
            long t = System.currentTimeMillis();
            this.setDone(this.trav.traverseS(this.tobj));
            System.out.println("THREAD : " + (System.currentTimeMillis() - t));
        }

        @Override
        synchronized void setDone(Object r2) {
            this.res = r2;
            this.done = true;
            this.notify();
        }

        @Override
        synchronized Object waitDone() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    System.err.println(" ** Error Waiting on Thread!!");
                }
            }
            return this.res;
        }
    }
}

