/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http.server;

import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;
import edu.neu.ccs.demeterf.http.server.Factory;
import edu.neu.ccs.demeterf.http.server.ResponseException;
import edu.neu.ccs.demeterf.http.server.ServerDispatch;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.util.Util;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerThread
extends Thread {
    static final int DEFAULT_BACKLOG = 20;
    private ServerSocket socket;
    private ServerDispatch dispatch;
    private List<Thread> servants = List.create();
    private boolean single;
    private long maxRequest;
    private int backlog;
    private boolean done = false;
    private Method exHandler;

    static void p(String s2) {
        Factory.p(s2);
    }

    public static void setVerbose(boolean v2) {
        Factory.setVerbose(v2);
    }

    protected ServerThread(int port, boolean sing, ServerDispatch disp, long max) throws IOException {
        this(port, sing, disp, max, null, 20);
    }

    protected ServerThread(int port, boolean sing, ServerDispatch disp, long max, Method eh, int back) throws IOException {
        this.socket = new ServerSocket(port, back);
        this.dispatch = disp;
        this.single = sing;
        this.maxRequest = max;
        this.backlog = back;
        this.exHandler = eh;
        this.start();
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                ServerThread.p("Waiting for connection...");
                Socket req = this.socket.accept();
                ServerThread.p("Got One from: " + req.getInetAddress() + ":" + req.getPort());
                if (this.numServants() < this.backlog) {
                    DispatchThread t = new DispatchThread(req, this.dispatch, this);
                    this.addServant(t);
                    t.start();
                    try {
                        if (this.single) {
                            t.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    req.close();
                }
                Thread.yield();
            }
            catch (IOException e2) {
                if (this.done) continue;
                System.err.println(" ServerThread Exception: " + e2.getMessage());
                this.done = true;
            }
        }
    }

    public synchronized void addServant(Thread t) {
        this.servants = this.servants.push(t);
    }

    public synchronized void removeServant(Thread t) {
        this.servants = this.servants.remove(t);
        this.notify();
    }

    public synchronized int numServants() {
        return this.servants.length();
    }

    public synchronized void waitServants() {
        ServerThread.p("Waiting for Servants...");
        while (!this.servants.isEmpty()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ServerThread.p("Still Waiting...");
        }
        ServerThread.p("Done");
    }

    public void shutdown() throws IOException {
        this.shutdown(true);
    }

    public void shutdown(boolean wait) throws IOException {
        this.done = true;
        this.socket.close();
        if (wait) {
            this.waitServants();
        }
    }

    private static class DispatchThread
    extends Thread {
        Socket sock;
        ServerDispatch dispatch;
        ServerThread parent;

        DispatchThread(Socket s2, ServerDispatch disp, ServerThread p) {
            this.sock = s2;
            this.dispatch = disp;
            this.parent = p;
        }

        @Override
        public void run() {
            ServerThread.p("In Dispatch Thread...");
            HTTPReq req = null;
            try {
                req = HTTPReq.fromSocket(this.sock, 2000, this.parent.maxRequest);
            }
            catch (Exception e2) {
                if (this.parent.exHandler != null) {
                    try {
                        HTTPResp res2 = (HTTPResp)Util.applyMethod(this.parent.exHandler, this.dispatch.getTarget(), new Object[]{e2, this.sock});
                        res2.toSocket(this.sock);
                        this.parent.removeServant(this);
                        this.sock.close();
                        return;
                    }
                    catch (Exception ee) {
                        e2 = ee;
                        return;
                    }
                }
                this.parent.removeServant(this);
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                HTTPResp res3 = this.dispatch.handle(req, this.sock);
                res3.toSocket(this.sock);
                this.sock.close();
            }
            catch (Exception e3) {
                this.parent.removeServant(this);
                throw new ResponseException(e3);
            }
            this.parent.removeServant(this);
        }
    }
}

