/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http.classes;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.http.classes.HTTPHead;
import edu.neu.ccs.demeterf.http.classes.HTTPResp;
import edu.neu.ccs.demeterf.http.classes.MsgHead;
import edu.neu.ccs.demeterf.http.classes.ParseException;
import edu.neu.ccs.demeterf.http.classes.PrintHeapToString;
import edu.neu.ccs.demeterf.http.classes.URL;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.ident;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class HTTPReq {
    protected final HTTPHead head;
    protected final List<MsgHead> keys;
    protected final ident body;
    public static final int DEFAULT_CONN_TIMEOUT = 20000;
    public static final int DEFAULT_RESP_TIMEOUT = 500;

    public HTTPReq(HTTPHead head2, List<MsgHead> keys2, ident body2) {
        this.head = head2;
        this.keys = keys2;
        this.body = body2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HTTPReq)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        HTTPReq oo = (HTTPReq)o;
        return this.head.equals(oo.head) && ((Object)this.keys).equals(oo.keys) && ((Object)this.body).equals(oo.body);
    }

    public static HTTPReq create(HTTPHead req, List<MsgHead> hds, String body2) {
        return HTTPReq.createNoLen(req, hds.append(new MsgHead("Content-Length", "" + body2.length())), body2);
    }

    private static HTTPReq createNoLen(HTTPHead req, List<MsgHead> hds, String body2) {
        return new HTTPReq(req, hds, new ident(body2));
    }

    public static HTTPReq Get(String url2) throws ParseException {
        return HTTPReq.create(HTTPHead.Get(URL.parse(url2)), List.<MsgHead>create(), "");
    }

    public static HTTPReq Get(String url2, String host) throws ParseException {
        return HTTPReq.create(HTTPHead.Get(URL.parse(url2)), HTTPReq.hostHeader(host), "");
    }

    public static HTTPReq Head(String url2) throws ParseException {
        return HTTPReq.create(HTTPHead.Get(URL.parse(url2)), List.<MsgHead>create(), "");
    }

    public static HTTPReq Head(String url2, String host) throws ParseException {
        return HTTPReq.create(HTTPHead.Head(URL.parse(url2)), HTTPReq.hostHeader(host), "");
    }

    public static HTTPReq Post(String url2, String body2) throws ParseException {
        return HTTPReq.create(HTTPHead.Post(URL.parse(url2)), List.<MsgHead>create(), body2);
    }

    public static HTTPReq Post(String url2, String host, String body2) throws ParseException {
        return HTTPReq.create(HTTPHead.Post(URL.parse(url2)), HTTPReq.hostHeader(host), body2);
    }

    private static List<MsgHead> hostHeader(String h) {
        return List.create(new MsgHead(new ident("Host"), new ident(h)));
    }

    private HTTPReq addHeaders(List<MsgHead> hs) {
        return HTTPReq.createNoLen(this.head, hs.append((MsgHead)((Object)this.keys)), "" + this.body);
    }

    public HTTPReq addHeader(String key2, String val2) {
        return HTTPReq.createNoLen(this.head, this.keys.append(new MsgHead(key2, val2)), "" + this.body);
    }

    public ReqType getType() {
        return this.head.getType();
    }

    public Map<String, String> urlArgs() {
        return this.head.url.urlArgs();
    }

    public Map<String, String> bodyArgs() {
        return HTTPReq.splitArgs("" + this.body);
    }

    public String trimmedUrl() {
        return this.head.url.trimArgs();
    }

    public HTTPResp send(String server, int port) throws IOException {
        return this.send(server, port, 0);
    }

    public HTTPResp send(String server, int port, int respTimeout) throws IOException {
        return this.send(server, port, 20000, respTimeout, 0L);
    }

    public HTTPResp send(String server, int port, int respTimeout, long maxResp) throws IOException {
        return this.send(server, port, 20000, respTimeout, maxResp);
    }

    public HTTPResp send(String server, int port, int connTimeout, int respTimeout, long maxResp) throws IOException {
        Socket sock = new Socket();
        sock.connect(new InetSocketAddress(server, port), connTimeout);
        this.addHeaders(HTTPReq.hostHeader(String.valueOf(server) + ":" + port)).toSocket(sock);
        HTTPResp res2 = HTTPResp.fromSocket(sock, respTimeout, maxResp);
        sock.close();
        return res2;
    }

    public void toSocket(Socket s2) {
        try {
            PrintWriter outt = new PrintWriter(s2.getOutputStream());
            outt.print(this.toString());
            outt.flush();
            s2.shutdownOutput();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static HTTPReq fromSocket(Socket s2) {
        return HTTPReq.fromSocket(s2, 0, 0L);
    }

    public static HTTPReq fromSocket(Socket s2, long maxBytes) {
        return HTTPReq.fromSocket(s2, 0, maxBytes);
    }

    public static HTTPReq fromSocket(Socket s2, int respTimeout, long maxBytes) {
        try {
            s2.setSoTimeout(500);
            HTTPReq req = HTTPReq.fromInputStream(s2.getInputStream(), respTimeout, maxBytes);
            s2.shutdownInput();
            return req;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static HTTPReq fromInputStream(InputStream inpt, long timeout, long maxBytes) {
        try {
            BufferedReader inn = new BufferedReader(new InputStreamReader(inpt));
            String first2 = HTTPReq.readLine(inn, timeout);
            if (first2 == null) {
                throw new RuntimeException("Empty HTTP Header");
            }
            HTTPHead h = HTTPHead.parse(first2);
            CountHds headers = HTTPReq.parseMsgHeads(inn, timeout, maxBytes, maxBytes - (long)(first2.length() + 1));
            return new HTTPReq(h, headers.heads, HTTPReq.parseBody(inn, timeout, maxBytes, maxBytes - ((long)(first2.length() + 1) + headers.size)));
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    static CountHds parseMsgHeads(BufferedReader in, long timeout, long maxBytes, long bytesLeft) throws Exception {
        HTTPReq.checkMaxBytes(maxBytes, bytesLeft);
        String line = HTTPReq.readLine(in, timeout);
        if (line == null || line.length() == 0) {
            return new CountHds(0L, List.<MsgHead>create());
        }
        int colon = line.indexOf(":");
        return HTTPReq.parseMsgHeads(in, timeout, maxBytes, bytesLeft - (long)(line.length() + 1)).add(line.length() + 1, new MsgHead(new ident(line.substring(0, colon)), new ident(line.substring(colon + 2))));
    }

    static String readLine(BufferedReader inn, long timeout) throws IOException {
        long start2 = System.currentTimeMillis();
        String line = "";
        while (true) {
            line = null;
            try {
                line = inn.readLine();
                return line;
            }
            catch (SocketTimeoutException e2) {
                if (timeout <= 0L || System.currentTimeMillis() - start2 <= timeout) continue;
                throw e2;
            }
            break;
        }
    }

    static void checkMaxBytes(long maxBytes, long bytesLeft) {
        if (maxBytes > 0L && bytesLeft < 0L) {
            throw new RuntimeException("HTTP Max Size Reached");
        }
    }

    static ident parseBody(BufferedReader inn, long timeout, long maxBytes, long bytesLeft) throws Exception {
        int many;
        HTTPReq.checkMaxBytes(maxBytes, bytesLeft);
        long start2 = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        char[] buff = new char[1024];
        do {
            many = 0;
            try {
                many = inn.read(buff);
                if (many <= 0) continue;
                sb.append(buff, 0, many);
                HTTPReq.checkMaxBytes(maxBytes, bytesLeft -= (long)many);
            }
            catch (SocketTimeoutException e2) {
                if (timeout <= 0L || System.currentTimeMillis() - start2 <= timeout) continue;
                throw new RuntimeException(e2);
            }
        } while (inn.ready() || many > 0);
        return new ident(sb.toString());
    }

    public String getBodyString() {
        return this.body.toString();
    }

    public Map<String, String> getHeaders() {
        return HTTPReq.getHeaders(this.keys);
    }

    static Map<String, String> getHeaders(List<MsgHead> hds) {
        return hds.fold(new List.Fold<MsgHead, Map<String, String>>(){

            @Override
            public Map<String, String> fold(MsgHead h, Map<String, String> m) {
                return m.put("" + h.key, "" + h.value);
            }
        }, Map.create());
    }

    static Map<String, String> splitArgs(String s2) {
        return List.create(s2.split("&")).fold(new List.Fold<String, Map<String, String>>(){

            @Override
            public Map<String, String> fold(String p, Map<String, String> m) {
                String[] kv = p.split("=");
                if (kv.length < 2) {
                    return m;
                }
                return m.put(HTTPReq.decodeURL(kv[0]), HTTPReq.decodeURL(kv[1]));
            }
        }, Map.create());
    }

    public static String decodeURL(String url2) {
        try {
            return URLDecoder.decode(url2, "UTF-8");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String encodeURL(String url2) {
        try {
            return URLEncoder.encode(url2, "UTF-8");
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public String toString() {
        return PrintHeapToString.PrintHeapToStringM(this);
    }

    public HTTPHead getHead() {
        return this.head;
    }

    public List<MsgHead> getKeys() {
        return this.keys;
    }

    public ident getBody() {
        return this.body;
    }

    static class CountHds {
        public long size;
        public List<MsgHead> heads;

        public CountHds(long s2, List<MsgHead> hds) {
            this.size = s2;
            this.heads = hds;
        }

        public CountHds add(long s2, MsgHead hd) {
            return new CountHds(s2 + this.size, this.heads.push(hd));
        }
    }

    public static enum ReqType {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        TRACE,
        CONNECT,
        OPTIONS,
        OTHER;

    }

    public static class body
    extends Fields.any {
    }

    public static class head
    extends Fields.any {
    }

    public static class keys
    extends Fields.any {
    }
}

