/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.batch;

import edu.neu.ccs.demeterf.batch.GenBatch;
import edu.neu.ccs.demeterf.batch.classes.ParseException;
import edu.neu.ccs.demeterf.batch.classes.TRVFile;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.RTFileNotFound;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.inline.Inline;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.util.CLI;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Batch {
    static boolean FOR_ALL = false;
    static boolean RESIDUE = true;

    static void p(String s2) {
        System.err.print(s2);
    }

    public static void main(String[] args2) {
        List<String>[] all = CLI.splitArgs(args2);
        List<String> opts = all[CLI.OPTS];
        Diff.storeOptions(opts);
        String[] nonOpt = all[CLI.ARGS].toArray((String[])new String[all[CLI.ARGS].length()]);
        List<String> unknown = CLI.invalidOptions(opts, Inline.allOpts);
        if (!unknown.isEmpty()) {
            Batch.usage("Unknown Option(s): " + unknown.toString(", ", ""));
        }
        if (nonOpt.length != 1) {
            Batch.usage("Not Enough Aguments");
        }
        String trvFile = nonOpt[0];
        String[] stringArray = CLI.separateOption("--path", opts);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String p = stringArray[n3];
            Type.addPath(p);
            ++n3;
        }
        try {
            TRVFile file2 = TRVFile.parse(new FileInputStream(trvFile));
            GenBatch.createTraversals(file2, opts);
            return;
        }
        catch (ParseException pe) {
            Batch.error(pe, "Parse");
        }
        catch (FileNotFoundException fe) {
            Batch.error(fe, "File");
        }
        catch (RTFileNotFound fe) {
            Batch.error(fe, "File");
        }
        catch (TypeError te) {
            Batch.error(te, "Type");
        }
        catch (RuntimeException e2) {
            Batch.error(e2, "", true);
        }
        System.exit(1);
    }

    static void error(Throwable t, String type2) {
        Batch.error(t, type2, false);
    }

    static void error(Throwable t, String type2, boolean stack) {
        Batch.p("\n !! " + type2 + " Error:\n" + t.getMessage() + "\n\n");
        if (stack) {
            t.printStackTrace();
        }
    }

    static void usage(String msg) {
        Batch.p(String.valueOf(msg.length() > 0 ? " !! " + msg + "\n" : "") + " !! Usage: Batch [Options] <TRV-File>\n\n" + "    The order/placement of options doesn't matter, but the relative\n" + "       order of the manditory ones must be as shown.\n\n" + "\n");
        System.exit(1);
    }
}

