// ** This file was generated with DemFGen (vers:4/15/2011)

package mmg.avatar;

import edu.neu.ccs.demeterf.lib.*;
import edu.neu.ccs.demeterf.lib.*;
import java.util.Random;
import java.lang.reflect.Method;
import scg.*;
import scg.protocol.*;
import mmg.*;
import java.text.DecimalFormat;




/** Representation of MMGAvatar */
public class MMGAvatar implements AvatarI{

    /** Construct a(n) MMGAvatar Instance */
    public MMGAvatar(){
    }
    /** Is the given object Equal to this MMGAvatar? */
    public boolean equals(Object o){
        if(!(o instanceof MMGAvatar))return false;
        if(o == this)return true;
        MMGAvatar oo = (MMGAvatar)o;
        return true;
    }
    /** Parse an instance of MMGAvatar from the given String */
    public static MMGAvatar parse(String inpt) throws mmg.avatar.ParseException{
        return new mmg.avatar.TheParser(new java.io.StringReader(inpt)).parse_MMGAvatar();
    }
    /** Parse an instance of MMGAvatar from the given Stream */
    public static MMGAvatar parse(java.io.InputStream inpt) throws mmg.avatar.ParseException{
        return new mmg.avatar.TheParser(inpt).parse_MMGAvatar();
    }
    /** Parse an instance of MMGAvatar from the given Reader */
    public static MMGAvatar parse(java.io.Reader inpt) throws mmg.avatar.ParseException{
        return new mmg.avatar.TheParser(inpt).parse_MMGAvatar();
    }

	

	private Config config;
	
	/** Constructor to be called during registration where you supply config */
	public MMGAvatar(Config cfg){
		config = cfg;
	}
	
	@Override
	/** Refutes when claim > Cmax, strengthens when claim < Cmax and
	agrees when claim is equal to Cmax */
	
	public List<OpposeAction> oppose(List<Claim> claimsToBeOpposed){
		return claimsToBeOpposed.map(new List.Map<Claim, OpposeAction>() {
			public OpposeAction map(Claim claim){
				

				double Cmax = computeCmax();
				double claim_made = claim.getQuality();
				
				if(claim_made > Cmax)
				{
					return new Refuting();
				}
				else if(claim_made < Cmax)
				{			
					SCGConfig scg_cfg = config.getScgCfg();
					double q = claim.getQuality();
					return new Strengthening(q + scg_cfg.getMinStrengthening());
				}
				else
				{
					return new Agreement();
				}

			}
		});
	}

	private double computeCmax()
	{

		// Initial upper and lower bounds
		double lowerbound = 0.00F;
		double upperbound = 1.00F;
		double middlevalue = 0.00F;
		int trueflag = 0;
		
		// To restrict precision to 2 digits
		DecimalFormat precision2 = new DecimalFormat("#.##");

        // Binary search to find max C in [0..1]
		while(Double.valueOf(precision2.format(upperbound - lowerbound)) > 0.01)
		{

			middlevalue = (lowerbound + upperbound)/2.0F;
			middlevalue = Double.valueOf(precision2.format(middlevalue));			

			// x varies between 0 and 1
			for(double x = 0.01 ; x <= 1.00 ; x = x + 0.01)
			{
				x = Double.valueOf(precision2.format(x));
				trueflag = 0;
				
				// y varies between 0 and 1
				for(double y = 0.01; y <= 1.00 ; y += 0.01)
				{
					y = Double.valueOf(precision2.format(y));
					
					// Ig x and y satisfy inequality
					if(((x*y) + (1-x)*(1-(y*y))) >= middlevalue)
					{
						// There exists a value of y for this X.
						// So break out of y loop and continue with next value of x
						trueflag = 1;
						break;
					}
				}
				
				// If there is no value of y for a given value of x, break out of the loop and
				// update upperbound, because the current middlevalue does not satisfy inequality 
				
				if(trueflag == 0)
					break;
			}	
			if(trueflag == 1)
			{
				// Inequality satisfied, so move to higher values of C
				lowerbound = Double.valueOf(precision2.format(middlevalue + 0.01));
			}
			else
			{
				// Inequality not satisfied. so move to lower values of C
				upperbound = Double.valueOf(precision2.format(middlevalue - 0.01));
			}

		}
		return lowerbound;
	}

	@Override
	public List<Claim> propose(List<Claim> forbiddenClaims) {	
		
		
		List<Claim> claims = List.create();
		
		double lbound = 0.00F;
		double ubound = 1.00F;
		int tflag = 0;
		DecimalFormat precision2 = new DecimalFormat("#.###");	
		double middlevalue = 0.00;
		
		SCGConfig scg_cfg = config.getScgCfg();
		int maxProposals = scg_cfg.getMaxProposals() -1;
		double claim_value = 0.100;
		for(int i=0;i<maxProposals;i++)
		{			
			
			claim_value = Double.valueOf(precision2.format(claim_value));
			Claim claim = new Claim(MMGInstanceSet.getInstance(),ForAllExistsMax.getInstance(),claim_value,1);
			claim_value += 0.001;
			while(forbiddenClaims.contains(claim) || claims.contains(claim))
			{
				claim_value = Double.valueOf(precision2.format(claim_value));
				claim = new Claim(MMGInstanceSet.getInstance(),ForAllExistsMax.getInstance(),claim_value,1);
				claim_value += 0.001;
			}		

			claims = claims.append(claim);
		}
		return claims;
	}
	
	
	@Override
	public InstanceI provide(Claim claimToBeProvided) {
	
	// For the given claim C, find a value of x for which the inequality is 
	// not satisfied with a value of y in [0..1]
		
		DecimalFormat precision2 = new DecimalFormat("#.###");	
		double Claim_made = claimToBeProvided.getQuality();		
		double x = 0.000;
		double y = 0.000;
	
		// Error changed to 0.50 from -1
		double no_value = 0.000;
		int trueflag = 0;
		System.out.println("i'm in provide for claim " + Claim_made);
		// Dead code rectified
		
		double cmax = computeCmax();
		if (Claim_made < cmax)
		{	
			System.out.println("Claim made is less than cmax " + Claim_made);
			return new MMGInstance(0.050);
		}
		
		for(x =0.000; x <=1.000 ; x+= 0.001)
		{
			trueflag = 0;
			x = Double.valueOf(precision2.format(x)); 
			for(y = 0.000 ; y <= 1.000 ; y+= 0.001)
			{
				y = Double.valueOf(precision2.format(y));
				if(((x*y) + ((1-x)*(1-(y*y)))) > Claim_made)
				{									
					trueflag = 1;
					System.out.println("X satisfies inequality " + x + " " + y);
					break;
				}				
			}
			if(trueflag == 0)
			{	
				System.out.println("X value returned : " + x);
				return new MMGInstance(x);				
			}
			// Else condition removed - it was because of this that the dead code was showing up
		}
		return new MMGInstance(no_value);	
	}
	
	// Solve the inequality for the given values of x and C
	
	@Override
	public SolutionI solve(SolveRequest solveRequest) {
		
		double x,c;
		int trueflag = 0;
		// Error changed to 0.50 from -1
		double no_value = 0.000;
		MMGInstance i = (MMGInstance)solveRequest.getInstance();
		x = i.getX();
		
		System.out.println("I'm in solve for instance " + x);
		c= solveRequest.getClaim().inner().getQuality();		
		DecimalFormat precision2 = new DecimalFormat("#.###");

		x = Double.valueOf(precision2.format(x));
		trueflag = 0;
		for(double y = 0.001; y <= 1.000 ; y += 0.001)
		{
			y = Double.valueOf(precision2.format(y));
			if(((x*y) + ((1-x)*(1-(y*y)))) >= c)
			{
				trueflag = 1;
				System.out.println("Y value found: " + Double.valueOf(precision2.format(y)));
				return new MMGSolution(y);				
			}
		}			
		if(trueflag == 0)
		{	
			System.out.println("No value found in solve");
			return new MMGSolution(no_value);
		}
		return new MMGSolution(no_value);
	}

	



}


