/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import edu.neu.ccs.demeterf.lib.List;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MethodDB<M> {
    protected DBEntry<M>[] methods;

    public MethodDB(List<DBEntry<M>> m) {
        this.methods = m.toArray(new DBEntry[m.length()]);
    }

    public static MethodDB<Method> createMethodDB(Class<?> c2, String name2) {
        return Help.createMethodDB(c2, name2);
    }

    public static MethodDB<Constructor<?>> createConstrDB(Class<?> c2) {
        return Help.createConstrDB(c2);
    }

    public DBEntry<M> matchEntryFast(Class<?>[] args2, int len) {
        int max = this.methods.length;
        DBEntry<M> best = null;
        int i = 0;
        while (i < max) {
            DBEntry<M> e2 = this.methods[i];
            if (MethodDB.applicable(args2, len, e2) && (best == null || MethodDB.compare(e2, best))) {
                best = e2;
            }
            ++i;
        }
        return best;
    }

    private static <M> boolean applicable(Class<?>[] args2, int len, DBEntry<M> e2) {
        if (e2.numArgs() > len) {
            return false;
        }
        int i = 0;
        while (i < e2.numArgs()) {
            if (!e2.arg(i).isAssignableFrom(args2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static <M> boolean compare(DBEntry<M> e1, DBEntry<M> e2) {
        int min = Math.min(e1.numArgs(), e2.numArgs());
        int i = 0;
        while (i < min) {
            if (!e1.arg(i).equals(e2.arg(i))) {
                return !e1.arg(i).isAssignableFrom(e2.arg(i));
            }
            ++i;
        }
        return e1.numArgs() > e2.numArgs();
    }

    static class Help {
        Help() {
        }

        public static List<DBEntry<Method>> getMethods(Class<?> c2, String name2) {
            List<DBEntry<Method>> l2 = List.create();
            while (c2 != null && !c2.equals(Object.class)) {
                Method[] methodArray = c2.getDeclaredMethods();
                int n2 = methodArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    MethodEntry me;
                    Method m = methodArray[n3];
                    if (m.getName().equals(name2) && l2.index(me = new MethodEntry(m)) < 0) {
                        l2 = l2.push(me);
                    }
                    ++n3;
                }
                c2 = c2.getSuperclass();
            }
            return l2;
        }

        public static MethodDB<Method> createMethodDB(Class<?> c2, String name2) {
            return new MethodDB<Method>(Help.getMethods(c2, name2));
        }

        public static MethodDB<Constructor<?>> createConstrDB(Class<?> c2) {
            List l2 = List.create();
            Constructor<?>[] constructorArray = c2.getDeclaredConstructors();
            int n2 = constructorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Constructor<?> con = constructorArray[n3];
                l2 = l2.push(new ConstrEntry(con));
                ++n3;
            }
            return new MethodDB(l2);
        }
    }
}

