/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.RBTree;
import edu.neu.ccs.demeterf.lib.Wrap;
import java.util.Comparator;
import java.util.Iterator;

public class Set<X>
implements Iterable<X> {
    protected final RBTree<Wrap<X>> tree;
    private final Comparator<X> comp;

    private Set() {
        this(new Wrap.CComp(), RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(Comparator<X> c2) {
        this(c2, RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(List<X> l2, Comparator<X> c2) {
        this(c2, RBTree.create(l2.map(new Wrapper<X>(c2))));
    }

    public Set(List<X> l2) {
        this(l2, new Wrap.CComp());
    }

    public Set(RBTree<Wrap<X>> t) {
        this(new Wrap.CComp(), t);
    }

    public static <X extends Comparable<X>> Set<X> create() {
        return new Set<X>();
    }

    public static <X> Set<X> create(Comparator<X> c2) {
        return new Set<X>(c2, RBTree.create((Comparable[])new Wrap[0]));
    }

    public static <X extends Comparable<X>> Set<X> create(List<X> l2) {
        return new Set<X>(l2);
    }

    public static <X> Set<X> create(List<X> l2, Comparator<X> c2) {
        return new Set<X>(l2, c2);
    }

    public static <X extends Comparable<X>> Set<X> create(X ... xs) {
        return new Set<X>(List.create(xs));
    }

    private Set(Comparator<X> c2, List<Wrap<X>> l2) {
        this(c2, RBTree.create(l2));
    }

    private Set(Comparator<X> c2, RBTree<Wrap<X>> t) {
        this.tree = t;
        this.comp = c2;
    }

    private Set<X> make(RBTree<Wrap<X>> t) {
        return new Set<X>(this.comp, t);
    }

    private Set<X> make(List<Wrap<X>> lst) {
        return new Set<X>(this.comp, lst);
    }

    private List<Wrap<X>> toWrapList() {
        return this.tree.toList();
    }

    public boolean contains(X x2) {
        return this.tree.contains(new Wrap<X>(x2, this.comp));
    }

    public boolean isEmpty() {
        return this.tree.isLeaf();
    }

    public int size() {
        return this.tree.size();
    }

    public Set<X> add(X x2) {
        return this.make(this.tree.insert(new Wrap<X>(x2, this.comp)));
    }

    public Set<X> remove(X x2) {
        return this.make(this.tree.remove(new Wrap<X>(x2, this.comp)));
    }

    public boolean subseteq(Set<X> s2) {
        return s2.tree.containsAll(this.tree);
    }

    public Set<X> union(Set<X> s2) {
        return this.make(this.tree.insertAll(s2.tree));
    }

    public Set<X> intersect(Set<X> s2) {
        return this.make(this.toWrapList().filter(new InTree<X>(s2.tree)));
    }

    public Set<X> difference(Set<X> s2) {
        return this.make(this.toWrapList().filterout(new InTree<X>(s2.tree)));
    }

    public List<X> toList() {
        return this.toWrapList().map(new UnWrapper());
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    public Set<X> merge(Set<X> s2, Merge<X> m) {
        return this.make(super.toWrapList().fold(new Merger(m), this.tree));
    }

    public Set<X> merge(X x2, Merge<X> m) {
        Wrap<X> w = new Wrap<X>(x2, this.comp);
        if (!this.tree.contains(w)) {
            return this.make(this.tree.insert(w));
        }
        return this.make(this.tree.replace(new Wrap<X>(m.merge(x2, this.tree.find(w).x), this.comp)));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Set)) {
            return false;
        }
        Set s2 = (Set)o;
        return s2.size() == this.size() && this.tree.containsAll(s2.tree);
    }

    public String toString() {
        return "{ " + this.toList().toString(" ", "") + " }";
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    static class InTree<X>
    extends List.Pred<Wrap<X>> {
        RBTree<Wrap<X>> t;

        InTree(RBTree<Wrap<X>> tt) {
            this.t = tt;
        }

        @Override
        public boolean huh(Wrap<X> x2) {
            return this.t.contains(x2);
        }
    }

    public static abstract class Merge<X> {
        public abstract X merge(X var1, X var2);
    }

    class Merger
    extends List.Fold<Wrap<X>, RBTree<Wrap<X>>> {
        Merge<X> m;

        Merger(Merge<X> mm) {
            this.m = mm;
        }

        @Override
        public RBTree<Wrap<X>> fold(Wrap<X> w, RBTree<Wrap<X>> t) {
            if (!t.contains(w)) {
                return t.insert(w);
            }
            return t.replace(new Wrap(this.m.merge(w.x, t.find(w).x), Set.this.comp));
        }
    }

    static class UnWrapper<X>
    extends List.Map<Wrap<X>, X> {
        UnWrapper() {
        }

        @Override
        public X map(Wrap<X> w) {
            return w.x;
        }
    }

    static class Wrapper<X>
    extends List.Map<X, Wrap<X>> {
        Comparator<X> c;

        Wrapper(Comparator<X> cc) {
            this.c = cc;
        }

        @Override
        public Wrap<X> map(X x2) {
            return new Wrap<X>(x2, this.c);
        }
    }

    public static class tree
    extends Fields.any {
    }
}

