/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.RBColor;
import edu.neu.ccs.demeterf.lib.RBLeaf;
import edu.neu.ccs.demeterf.lib.RBNode;
import java.util.Comparator;
import java.util.Iterator;

public abstract class RBTree<X extends Comparable<X>>
implements Iterable<X> {
    public abstract boolean isLeaf();

    public RBTree<X> insert(X x2) {
        return this.insert(x2, new CComp());
    }

    public RBTree<X> insert(X x2, Comparator<X> comp) {
        return this.ins(x2, comp).makeBlack();
    }

    public RBTree<X> insertAll(RBTree<X> t) {
        return this.insertAll(t.toList());
    }

    public RBTree<X> insertAll(List<X> lst) {
        return this.insertAll(lst, new CComp());
    }

    public RBTree<X> insertAll(RBTree<X> t, Comparator<X> c2) {
        return this.insertAll(t.toList(), c2);
    }

    public RBTree<X> insertAll(List<X> lst, Comparator<X> c2) {
        if (lst.isEmpty()) {
            return this;
        }
        return this.insert((Comparable)lst.top(), c2).insertAll(lst.pop(), c2);
    }

    public RBTree<X> remove(X x2) {
        return this.remove(x2, new CComp());
    }

    public abstract RBTree<X> remove(X var1, Comparator<X> var2);

    public abstract int size();

    abstract RBTree<X> del(X var1, Comparator<X> var2);

    abstract boolean isBlack();

    abstract boolean isRed();

    abstract RBNode<X> asNode();

    abstract RBTree<X> makeBlack();

    abstract RBTree<X> makeRed();

    abstract RBTree<X> ins(X var1, Comparator<X> var2);

    public abstract X pred();

    public abstract X succ();

    public abstract X min();

    public abstract X max();

    boolean isBlackNode() {
        return !this.isLeaf() && this.isBlack();
    }

    boolean isRedNode() {
        return !this.isLeaf() && this.isRed();
    }

    public boolean contains(X x2) {
        return this.contains(x2, new CComp());
    }

    public abstract boolean contains(X var1, Comparator<X> var2);

    public boolean containsAll(RBTree<X> x2) {
        return this.containsAll(x2, new CComp());
    }

    public abstract boolean containsAll(RBTree<X> var1, Comparator<X> var2);

    public X find(X x2) {
        return this.find(x2, new CComp());
    }

    public abstract X find(X var1, Comparator<X> var2);

    public RBTree<X> replace(X x2) {
        return this.replace(x2, new CComp());
    }

    public abstract RBTree<X> replace(X var1, Comparator<X> var2);

    public abstract List<X> toList();

    static <X extends Comparable<X>> RBTree<X> balance(X dat, RBTree<X> l2, RBTree<X> r2) {
        if (l2.isRedNode() && r2.isRedNode()) {
            return RBTree.node(RBTree.red(), dat, l2.makeBlack(), r2.makeBlack());
        }
        if (l2.isRedNode()) {
            RBNode<X> L2 = l2.asNode();
            if (L2.left.isRedNode()) {
                RBNode LL = L2.left.asNode();
                return RBTree.node(RBTree.red(), L2.data, RBTree.node(RBTree.black(), LL.data, LL.left, LL.right), RBTree.node(RBTree.black(), dat, L2.right, r2));
            }
            if (L2.right.isRedNode()) {
                RBNode LR = L2.right.asNode();
                return RBTree.node(RBTree.red(), LR.data, RBTree.node(RBTree.black(), L2.data, L2.left, LR.left), RBTree.node(RBTree.black(), dat, LR.right, r2));
            }
        }
        if (r2.isRedNode()) {
            RBNode<X> R2 = r2.asNode();
            if (R2.left.isRedNode()) {
                RBNode RL = R2.left.asNode();
                return RBTree.node(RBTree.red(), RL.data, RBTree.node(RBTree.black(), dat, l2, RL.left), RBTree.node(RBTree.black(), R2.data, RL.right, R2.right));
            }
            if (R2.right.isRedNode()) {
                RBNode RR = R2.right.asNode();
                return RBTree.node(RBTree.red(), R2.data, RBTree.node(RBTree.black(), dat, l2, R2.left), RBTree.node(RBTree.black(), RR.data, RR.left, RR.right));
            }
        }
        return RBTree.node(RBTree.black(), dat, l2, r2);
    }

    protected static <X extends Comparable<X>> RBTree<X> balleft(RBTree<X> l2, X y, RBTree<X> r2) {
        if (l2.isRedNode()) {
            return RBTree.node(RBTree.red(), y, l2.makeBlack(), r2);
        }
        if (r2.isBlackNode()) {
            return RBTree.balance(y, l2, r2.makeRed());
        }
        RBNode<X> right2 = r2.asNode();
        RBNode rtlt = right2.left.asNode();
        return RBTree.node(RBTree.red(), rtlt.data, RBTree.node(RBTree.black(), y, l2, rtlt.left), RBTree.balance(right2.data, rtlt.right, right2.right.makeRed()));
    }

    protected static <X extends Comparable<X>> RBTree<X> balright(RBTree<X> l2, X y, RBTree<X> r2) {
        if (r2.isRedNode()) {
            return RBTree.node(RBTree.red(), y, l2, r2.makeBlack());
        }
        if (l2.isBlackNode()) {
            return RBTree.balance(y, l2.makeRed(), r2);
        }
        RBNode<X> left2 = l2.asNode();
        RBNode ltrt = left2.right.asNode();
        return RBTree.node(RBTree.red(), ltrt.data, RBTree.balance(left2.data, left2.left.makeRed(), ltrt.left), RBTree.node(RBTree.black(), y, ltrt.right, r2));
    }

    protected static <X extends Comparable<X>> RBTree<X> append(RBTree<X> l2, RBTree<X> r2) {
        if (l2.isLeaf()) {
            return r2;
        }
        if (r2.isLeaf()) {
            return l2;
        }
        RBNode<X> left2 = l2.asNode();
        RBNode<X> right2 = r2.asNode();
        if (left2.color.equals(right2.color)) {
            RBColor c2 = left2.color;
            RBTree rtlt = RBTree.append(left2.right, right2.left);
            if (rtlt.isRedNode()) {
                RBNode rln = rtlt.asNode();
                return RBTree.node(RBTree.red(), rln.data, RBTree.node(c2, left2.data, left2.left, rln.left), RBTree.node(c2, right2.data, rln.right, right2.right));
            }
            if (c2.isRed()) {
                return RBTree.node(RBTree.red(), left2.data, left2.left, RBTree.node(RBTree.red(), right2.data, rtlt, right2.right));
            }
            return RBTree.balleft(left2.left, left2.data, RBTree.node(RBTree.black(), right2.data, rtlt, right2.right));
        }
        if (right2.isRed()) {
            return RBTree.node(RBTree.red(), right2.data, RBTree.append(left2, right2.left), right2.right);
        }
        return RBTree.node(RBTree.red(), left2.data, left2.left, RBTree.append(left2.right, right2));
    }

    public static RBColor black() {
        return RBColor.black();
    }

    public static RBColor red() {
        return RBColor.red();
    }

    public static <X extends Comparable<X>> RBTree<X> create(X ... xs) {
        return RBTree.create(List.create(xs));
    }

    public static <X extends Comparable<X>> RBTree<X> create(List<X> xs) {
        return RBTree.create(xs);
    }

    public static <X extends Comparable<X>> RBTree<X> create(Iterable<X> xs) {
        RBTree t = new RBLeaf<Comparable>();
        for (Comparable x2 : xs) {
            t = t.insert(x2);
        }
        return t;
    }

    public static <X extends Comparable<X>> RBLeaf<X> leaf() {
        return new RBLeaf();
    }

    public static <X extends Comparable<X>> RBNode<X> node(RBColor c2, X d2, RBTree<X> l2, RBTree<X> r2) {
        return new RBNode<X>(c2, d2, l2, r2);
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static class CComp<X extends Comparable<X>>
    implements Comparator<X> {
        CComp() {
        }

        @Override
        public int compare(X a, X b) {
            return a.compareTo(b);
        }
    }
}

