/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.RBColor;
import edu.neu.ccs.demeterf.lib.RBTree;
import java.util.Comparator;

public class RBNode<X extends Comparable<X>>
extends RBTree<X> {
    protected final RBColor color;
    protected final X data;
    protected final RBTree<X> left;
    protected final RBTree<X> right;
    private final int hash;

    public RBNode(RBColor color2, X data2, RBTree<X> left2, RBTree<X> right2) {
        this.color = color2;
        this.data = data2;
        this.left = left2;
        this.right = right2;
        this.hash = data2.hashCode() + left2.hashCode() + right2.hashCode();
    }

    public String toString() {
        return "(node " + this.color + " " + this.data + " " + this.left + " " + this.right + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RBNode)) {
            return false;
        }
        RBNode oo = (RBNode)o;
        return this.color.equals(oo.color) && this.data.equals(oo.data) && ((Object)this.left).equals(oo.left) && ((Object)this.right).equals(oo.right);
    }

    public RBColor getColor() {
        return this.color;
    }

    public X getData() {
        return this.data;
    }

    public RBTree<X> getLeft() {
        return this.left;
    }

    public RBTree<X> getRight() {
        return this.right;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    boolean isBlack() {
        return this.color.isBlack();
    }

    @Override
    boolean isRed() {
        return this.color.isRed();
    }

    @Override
    RBNode<X> asNode() {
        return this;
    }

    @Override
    public boolean contains(X x2, Comparator<X> comp) {
        int c2 = comp.compare(x2, this.data);
        if (c2 < 0) {
            return this.left.contains(x2, comp);
        }
        if (c2 > 0) {
            return this.right.contains(x2, comp);
        }
        return true;
    }

    @Override
    public boolean containsAll(RBTree<X> x2, Comparator<X> comp) {
        if (x2.isLeaf()) {
            return true;
        }
        RBNode<X> n2 = x2.asNode();
        return this.contains(n2.data, comp) && this.containsAll(n2.left, comp) && this.containsAll(n2.right, comp);
    }

    @Override
    public X find(X x2, Comparator<X> comp) {
        int c2 = comp.compare(x2, this.data);
        if (c2 < 0) {
            return this.left.find(x2, comp);
        }
        if (c2 > 0) {
            return this.right.find(x2, comp);
        }
        return this.data;
    }

    @Override
    public RBTree<X> remove(X x2, Comparator<X> c2) {
        return this.del(x2, c2).makeBlack();
    }

    @Override
    RBTree<X> del(X x2, Comparator<X> comp) {
        int c2 = comp.compare(x2, this.data);
        if (c2 < 0) {
            return this.left.isBlackNode() ? RBNode.balleft(this.left.del(x2, comp), this.data, this.right) : RBNode.node(RBNode.red(), this.data, this.left.del(x2, comp), this.right);
        }
        if (c2 > 0) {
            return this.right.isBlackNode() ? RBNode.balright(this.left, this.data, this.right.del(x2, comp)) : RBNode.node(RBNode.red(), this.data, this.left, this.right.del(x2, comp));
        }
        return RBNode.append(this.left, this.right);
    }

    @Override
    public List<X> toList() {
        return this.left.toList().append(this.right.toList().push(this.data));
    }

    @Override
    public int size() {
        return 1 + this.left.size() + this.right.size();
    }

    @Override
    RBTree<X> makeBlack() {
        return RBNode.node(RBNode.black(), this.data, this.left, this.right);
    }

    @Override
    RBTree<X> makeRed() {
        return RBNode.node(RBNode.red(), this.data, this.left, this.right);
    }

    @Override
    public X pred() {
        return this.left.max();
    }

    @Override
    public X succ() {
        return this.right.min();
    }

    @Override
    public X min() {
        return this.left.isLeaf() ? this.data : this.left.min();
    }

    @Override
    public X max() {
        return this.right.isLeaf() ? this.data : this.right.min();
    }

    @Override
    RBTree<X> ins(X x2, Comparator<X> comp) {
        int c2 = comp.compare(x2, this.data);
        if (c2 == 0) {
            return this;
        }
        if (this.color.isBlack()) {
            if (c2 < 0) {
                return RBNode.balance(this.data, this.left.ins(x2, comp), this.right);
            }
            return RBNode.balance(this.data, this.left, this.right.ins(x2, comp));
        }
        if (c2 < 0) {
            return RBNode.node(RBNode.red(), this.data, this.left.ins(x2, comp), this.right);
        }
        return RBNode.node(RBNode.red(), this.data, this.left, this.right.ins(x2, comp));
    }

    @Override
    public RBTree<X> replace(X x2, Comparator<X> comp) {
        int c2 = comp.compare(x2, this.data);
        if (c2 == 0) {
            return RBNode.node(this.color, x2, this.left, this.right);
        }
        if (c2 < 0) {
            return RBNode.node(this.color, this.data, this.left.replace(x2, comp), this.right);
        }
        return RBNode.node(this.color, this.data, this.left, this.right.replace(x2, comp));
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    public static class color
    extends Fields.any {
    }

    public static class data
    extends Fields.any {
    }

    public static class left
    extends Fields.any {
    }

    public static class right
    extends Fields.any {
    }
}

