/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lib;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.lib.ConsS;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.PESepList;
import edu.neu.ccs.demeterf.lib.SepList;

public class NESepList<Syn, X>
extends SepList<Syn, X> {
    protected final X first;
    protected final PESepList<Syn, X> rest;

    public NESepList(X first2, PESepList<Syn, X> rest2) {
        this.first = first2;
        this.rest = rest2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NESepList)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        NESepList oo = (NESepList)o;
        return this.first.equals(oo.first) && this.rest.equals(oo.rest);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public X top() {
        return this.first;
    }

    @Override
    public PESepList<Syn, X> pop() {
        return this.rest;
    }

    @Override
    public boolean hasSyntax() {
        return this.rest.hasSyntax();
    }

    @Override
    public Syn topSyntax() {
        return this.rest.topSyntax();
    }

    @Override
    public List<X> toList() {
        return this.rest.toList().push(this.first);
    }

    @Override
    public SepList<Syn, X> push(X x2, Syn s2) {
        return new NESepList<Syn, X>(x2, new ConsS<Syn, X>(s2, this.first, this.rest));
    }

    @Override
    public SepList<Syn, X> reverse() {
        if (!this.rest.hasSyntax()) {
            return this;
        }
        return this.reverse(SepList.create(), this.rest.topSyntax());
    }

    @Override
    protected SepList<Syn, X> reverse(SepList<Syn, X> acc, Syn s2) {
        return this.rest.reverse(acc.push(this.first, s2), s2);
    }

    @Override
    public int length() {
        return 1 + this.rest.length();
    }

    @Override
    public X lookup(int i) {
        return i == 0 ? this.first : this.rest.lookup(i - 1);
    }

    @Override
    public String toString() {
        return this.first + this.rest.toString();
    }

    public <Y> Y foldl(SepList.Fold<Syn, X, Y> f) {
        return this.rest.foldl(f, f.fold(this.first));
    }

    @Override
    public <Y> Y foldl(SepList.Fold<Syn, X, Y> f, Y b) {
        X x2 = this.top();
        PESepList<Syn, X> r2 = this.pop();
        b = f.fold(x2, b);
        while (!r2.isEmpty()) {
            b = f.fold(r2.topSyntax(), r2.top(), b);
            r2 = r2.pop();
        }
        return b;
    }

    public static class first
    extends Fields.any {
    }

    public static class rest
    extends Fields.any {
    }
}

