/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.lexer;

import edu.neu.ccs.demeterf.lexer.ADFA;
import edu.neu.ccs.demeterf.lexer.TestLexer;
import edu.neu.ccs.demeterf.lib.List;
import java.io.IOException;
import java.io.InputStream;

public class Lexer {
    InputStream input;
    final int[][] EDGES;
    final int[][] FINAL;
    final String[] NAMES;
    final int EOF;
    final int SKIP;
    String saved = "";
    boolean eofHit = false;
    int lineNum = 0;
    int colNum = 0;

    public Lexer(InputStream in, ADFA dfa) {
        this.input = in;
        this.EDGES = dfa.getEDGES();
        this.FINAL = dfa.getFINAL();
        this.NAMES = dfa.getNAMES();
        this.EOF = dfa.EOF();
        this.SKIP = dfa.SKIP();
    }

    int read() throws IOException {
        if (this.saved.length() == 0) {
            int ch2 = this.input.read();
            if (ch2 < 0) {
                ch2 = 0;
                this.eofHit = true;
            }
            return ch2;
        }
        char ch3 = this.saved.charAt(0);
        this.saved = this.saved.substring(1);
        return ch3;
    }

    public Tok nextToken() {
        int state2 = 1;
        int finSt = 0;
        int finIdx = 0;
        int finLine = 0;
        int finCol = 0;
        String buff = "";
        int line = this.lineNum;
        int col = this.colNum;
        while (true) {
            int ch2 = 0;
            try {
                ch2 = this.read();
            }
            catch (IOException io) {
                this.eofHit = true;
                ch2 = 0;
            }
            if (ch2 == 10) {
                ++line;
                col = 0;
            } else {
                ++col;
            }
            int next = this.smallTrans(state2, ch2);
            buff = String.valueOf(buff) + (char)ch2;
            if (next == 0) {
                if (finSt == 0) {
                    if (this.eofHit) {
                        return new Tok(this.EOF, "", this.lineNum, this.colNum);
                    }
                    throw new RuntimeException("\n Lexer Error: Line " + line + ", Column " + col + "\n    Char: '" + Lexer.escape((char)ch2) + "' [" + ch2 + "]" + "\n    Buff: \"" + Lexer.escape(buff) + "\"" + "\n   State: #" + state2);
                }
                Tok ret2 = new Tok(this.FINAL[finSt][1], buff.substring(0, finIdx), this.lineNum, this.colNum);
                this.saved = buff.substring(finIdx);
                this.lineNum = finLine;
                this.colNum = finCol;
                return ret2;
            }
            if (this.eofHit) {
                if (this.FINAL[state2][0] == 1) {
                    this.saved = "";
                    this.lineNum = line;
                    this.colNum = col;
                    return new Tok(this.FINAL[state2][1], buff, this.lineNum, this.colNum);
                }
                if (buff.length() == 0) {
                    return new Tok(this.EOF, "", this.lineNum, this.colNum);
                }
                throw new RuntimeException("\n Unexpected EOF: Line " + line + ", Column " + col + "\n Buffer is: \"" + Lexer.escape(buff) + "\"");
            }
            state2 = next;
            if (this.FINAL[state2][0] != 1) continue;
            finSt = state2;
            finIdx = buff.length();
            finLine = line;
            finCol = col;
        }
    }

    public static String escape(String s2) {
        char[] str2 = s2.toCharArray();
        StringBuffer ret2 = new StringBuffer("");
        char[] cArray = str2;
        int n2 = str2.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            ret2.append(Lexer.escape(c2));
            ++n3;
        }
        return ret2.toString();
    }

    public static String escape(char c2) {
        switch (c2) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\\': {
                return "\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
        }
        return "" + c2;
    }

    public int trans(int state2, int ch2) {
        return this.EDGES[state2][ch2];
    }

    public int smallTrans(int state2, int ch2) {
        int[] table = this.EDGES[state2];
        int i = 0;
        while (i < table.length) {
            if ((ch2 -= table[i]) < 0) {
                return table[i + 1];
            }
            i += 2;
        }
        throw new RuntimeException(" NO TRANSITION!! [" + state2 + "][" + ch2 + "]");
    }

    public static void main(String[] args2) {
        Lexer.test(new TestLexer(System.in));
    }

    public static void test(Lexer lex) {
        Tok t;
        List<Object> ts = List.create();
        do {
            if ((t = lex.nextToken()).isSKIP()) continue;
            ts = ts.push(t);
        } while (!t.isEOF());
        System.out.println(ts.reverse().toString("\n", "   "));
    }

    public class Tok {
        int type;
        String image;
        int line;
        int col;

        public Tok(int t, String i, int l2, int c2) {
            this.type = t;
            this.image = i;
            this.line = l2;
            this.col = c2;
        }

        public String toString() {
            return "(" + Lexer.this.NAMES[this.type] + ",\"" + Lexer.escape(this.image) + "\"," + this.line + "," + this.col + ")";
        }

        public String getImage() {
            return this.image;
        }

        public boolean isEOF() {
            return this.type == Lexer.this.EOF;
        }

        public boolean isSKIP() {
            return this.type == Lexer.this.SKIP;
        }
    }
}

