/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.inline;

import edu.neu.ccs.demeterf.demfgen.ClassHier;
import edu.neu.ccs.demeterf.demfgen.DemFGenMain;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.IncludeCDs;
import edu.neu.ccs.demeterf.demfgen.Preamble;
import edu.neu.ccs.demeterf.demfgen.classes.CDFile;
import edu.neu.ccs.demeterf.demfgen.classes.Impl;
import edu.neu.ccs.demeterf.demfgen.classes.NoImpl;
import edu.neu.ccs.demeterf.demfgen.classes.RTFileNotFound;
import edu.neu.ccs.demeterf.demfgen.classes.RTParseException;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.inline.Checker;
import edu.neu.ccs.demeterf.inline.GenControl;
import edu.neu.ccs.demeterf.inline.GenHeapTrav;
import edu.neu.ccs.demeterf.inline.GenParTrav;
import edu.neu.ccs.demeterf.inline.GenTrav;
import edu.neu.ccs.demeterf.inline.Help;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.inline.Typer;
import edu.neu.ccs.demeterf.inline.classes.EnvEntry;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.util.CLI;
import java.io.FileNotFoundException;

public class Inline {
    static boolean FOR_ALL = false;
    static boolean RESIDUE = true;
    public static final String PATH = "--path";
    public static final String BUILTINS = "--builtins";
    public static final String BYPASS = "--bypass";
    public static final String IGNORE = "--ignore";
    public static final String VERBOSE = "--verbose";
    public static final String TARG = "--targ";
    public static final String HEAP = "--heap";
    public static final String PARALLEL = "--parallel";
    public static final String JAVAHACK = "--javahack";
    public static final String FORALL = "--forall";
    public static final String JUSTTYPE = "--justtype";
    public static final String STRICT = "--strict";
    public static final String CONCRETES = "--concretes";
    public static final String PARFIELDS = "--parfields";
    public static final String PARTYPES = "--partypes";
    public static final String PUBFIELDS = "--publicfields";
    public static final String BEHFILE = "--behfile";
    public static final List<String> allOpts = List.create("--path", "--builtins", "--bypass", "--ignore", "--verbose", "--targ", "--heap", "--parallel", "--javahack", "--forall", "--justtype", "--strict", "--concretes", "--publicfields", "--parfields", "--partypes", "--behfile");

    static void p(String s2) {
        System.err.print(s2);
    }

    public static void main(String[] args2) throws Exception {
        List<String>[] all = CLI.splitArgs(args2);
        List<String> opts = all[CLI.OPTS];
        String[] nonOpt = all[CLI.ARGS].toArray((String[])new String[all[CLI.ARGS].length()]);
        List<String> unknown = CLI.invalidOptions(opts, allOpts);
        if (!unknown.isEmpty()) {
            Inline.usage("Unknown Option(s): " + unknown.toString(", ", ""));
        }
        if (nonOpt.length != 3) {
            Inline.usage("Not Enough Aguments");
        }
        String cdFile = nonOpt[0];
        String funClass = nonOpt[1];
        String stClass = nonOpt[2];
        String[] stringArray = CLI.separateOption(PATH, opts);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String p = stringArray[n3];
            Type.addPath(p);
            ++n3;
        }
        try {
            List<CDFile> CDs = DemFGenMain.resolveCDFile(cdFile);
            SubTyping subs = new SubTyping(CDs);
            List<ClassHier.InhrtPair> inhrtL = DemFGenMain.subtypes(CDs);
            Map<String, List<ClassHier.InhrtPair>> inhrtM = DemFGenMain.buildInhrtMap(inhrtL);
            List<TypeDef> types2 = DemFGenMain.removeSyntax(DemFGenMain.flatten(CDs, inhrtM));
            System.out.println(Inline.doGen("", new NoImpl(), CDs, "", funClass, stClass, types2, subs, opts));
            System.exit(0);
        }
        catch (RTParseException pe) {
            Inline.error(pe, "Parse");
        }
        catch (FileNotFoundException fe) {
            Inline.error(fe, "File");
        }
        catch (RTFileNotFound fe) {
            Inline.error(fe, "File");
        }
        catch (TypeError te) {
            Inline.error(te, "Type");
        }
        catch (RuntimeException e2) {
            Inline.error(e2, "", true);
        }
        System.exit(1);
    }

    public static String doGen(String name2, Impl impl2, List<CDFile> CDs, String pack2, String funClass, String stClass, List<TypeDef> types2, SubTyping subs, List<String> opts) throws FileNotFoundException {
        Diff.storeOptions(opts);
        GenControl ctrl2 = GenControl.make(subs, List.create(CLI.separateOption(BUILTINS, opts)), List.create(CLI.separateOption(BYPASS, opts)), List.create(CLI.separateOption(IGNORE, opts)));
        String[] targC = CLI.separateOption(TARG, opts);
        Option<TypeUse> targ2 = targC.length > 0 ? Option.some(TypeUse.makeType(targC[0])) : Option.none();
        Help.verbose = CLI.optionSet(VERBOSE, opts);
        SubTyping.JAVA_HACK = CLI.optionSet(JAVAHACK, opts);
        FOR_ALL = CLI.optionSet(FORALL, opts);
        SubTyping.STRICT = CLI.optionSet(STRICT, opts);
        String header = pack2 + IncludeCDs.allImports(CDs) + (CDs.top().getPkg().hasPkg() ? "import " + CDs.top().getPkg().name() + ".*;\n" : "");
        return Inline.traversalClass(name2, impl2, header, types2, subs, funClass, stClass, ctrl2, targ2, opts);
    }

    public static String traversalClass(String name2, Impl impl2, String header, List<TypeDef> types2, SubTyping subs, String funClass, String stClass, GenControl ctrl2, Option<TypeUse> targ2, List<String> opts) throws FileNotFoundException {
        String ret2 = null;
        String[] behs2 = CLI.separateOption(BEHFILE, opts);
        String beh = "";
        if (behs2.length > 0) {
            beh = DemFGenMain.behBody(DemFGenMain.resolveBEHFile(behs2[0]), name2);
        }
        TypeUse stUse = TypeUse.makeType(stClass);
        Typer typer = Checker.check(types2, subs, funClass, stClass, ctrl2, targ2);
        List<EnvEntry> env = typer.results.toList();
        if (CLI.optionSet(JUSTTYPE, opts)) {
            System.exit(0);
        }
        if (name2.length() == 0) {
            name2 = "Inline" + (CLI.optionSet(HEAP, opts) ? "Heap" : (CLI.optionSet(PARALLEL, opts) ? "Par" : "")) + Inline.removePack(funClass);
        }
        ret2 = CLI.optionSet(HEAP, opts) ? GenHeapTrav.generate(name2, impl2, types2, funClass, stUse, ctrl2, targ2, env, subs, typer.updates, opts, beh) : (CLI.optionSet(PARALLEL, opts) ? GenParTrav.generate(name2, impl2, types2, funClass, stUse, ctrl2, targ2, env, subs, typer.updates, opts, beh) : GenTrav.generate(name2, impl2, types2, funClass, stUse, ctrl2, targ2, env, subs, typer.updates, opts, beh));
        return String.valueOf(Preamble.header) + header + "\n" + ret2 + "\n";
    }

    static String removePack(String f) {
        int idx = f.lastIndexOf(46);
        if (idx < 0) {
            return f;
        }
        return f.substring(idx + 1);
    }

    static void error(Throwable t, String type2) {
        Inline.error(t, type2, false);
    }

    static void error(Throwable t, String type2, boolean stack) {
        Inline.p("\n !! " + type2 + " Error:\n" + t.getMessage() + "\n\n");
        if (stack) {
            t.printStackTrace();
        }
    }

    static void usage(String msg) {
        Inline.p(String.valueOf(msg.length() > 0 ? " !! " + msg + "\n" : "") + " !! Usage: Inline [Options] <CD-File> <FuncClass> <StartClass>\n\n" + "    The order/placement of options doesn't matter, but the relative\n" + "       order of the manditory ones must be as shown.\n\n" + "    CD-File contains the CD for the traversal to be checked/generated,\n" + "    FuncClass is the function class to be checked/inlined,\n" + "    StartClass class where traversal begins (source)\n" + "    Options can be: \n" + "      --targ:Class          : The type of traversal context\n" + "      --path:P1:...:Pn      : A colon separated list of packages in which to\n" + "                               search for classes. E.g., \"--path:java.util:java.lang\"\n" + "      --builtin:C1:...:Cn   : A colon separated list classes to be considered BuiltIn\n" + "      --heap                : Create a heap-based (i.e., not stack) Traversal\n" + "      --parallel            : Create a muti-threaded Traversal\n" + "      --partypes:C1:...:Cn  : Classes to be Traversed in Parallel\n" + "      --parfields:E1:...:En : Fields/Edges to be Traversed in Parallel\n" + "      --justtype            : Only typecheck the traversal, and print the result type\n" + "      --strict              : Be strict on number of function arguments\n" + "      --verbose             : Print out more information\n" + "      --javahack            : Support Java 'Type Erasure' in generaic subtyping\n" + "      --forall              : Create a traverse method for each concrete type\n" + "\n");
        System.exit(1);
    }
}

