/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http.server;

import edu.neu.ccs.demeterf.http.server.ExceptionHandler;
import edu.neu.ccs.demeterf.http.server.MaxMessageSize;
import edu.neu.ccs.demeterf.http.server.Port;
import edu.neu.ccs.demeterf.http.server.Server;
import edu.neu.ccs.demeterf.http.server.ServerDispatch;
import edu.neu.ccs.demeterf.http.server.ServerThread;
import edu.neu.ccs.demeterf.lib.List;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;

public class Factory {
    static boolean verbose = false;

    private Factory() {
    }

    public static void setVerbose(boolean v2) {
        verbose = v2;
    }

    static void p(String s2) {
        if (verbose) {
            System.err.println(" ** " + s2);
        }
    }

    public static ServerThread create(Object handler) throws IOException {
        return Factory.create(handler, false);
    }

    public static ServerThread create(Object handler, boolean single) throws IOException {
        return Factory.create(handler, single, 20);
    }

    public static ServerThread create(Object handler, boolean single, int backlog) throws IOException {
        Class<?> c2 = handler.getClass();
        if (!c2.isAnnotationPresent(Server.class)) {
            throw Factory.error("Cannot Create Server for unannotated class '" + c2.getCanonicalName() + "'");
        }
        int port = Factory.getPort(c2, handler);
        long max = Factory.getMaxMsgSize(c2, handler);
        Factory.p("Server Port = " + port);
        Factory.p("Max MsgSize = " + max);
        List<Method> except = List.create(c2.getDeclaredMethods()).filter(new Except());
        if (!except.isEmpty()) {
            ServerDispatch.check(except.top(), new Class[]{Exception.class, Socket.class});
        }
        return new ServerThread(port, single, ServerDispatch.create(handler), max, except.isEmpty() ? null : except.top(), backlog);
    }

    public ServerDispatch localDispatcher(Object handler) {
        return ServerDispatch.create(handler, ServerDispatch.MinimalFormals);
    }

    private static int getPort(Class c2, Object server) {
        Field[] fieldArray = c2.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field ff = fieldArray[n3];
            if (ff.isAnnotationPresent(Port.class)) {
                try {
                    ff.setAccessible(true);
                    if (ff.getType().equals(Integer.TYPE) || ff.getType().equals(Integer.class)) {
                        return (Integer)ff.get(server);
                    }
                }
                catch (IllegalAccessException e2) {
                    throw Factory.error("Port Field '" + ff.getName() + "' is not accessible in " + c2.getCanonicalName());
                }
            }
            ++n3;
        }
        throw Factory.error("No Port Field found in " + c2.getCanonicalName());
    }

    private static long getMaxMsgSize(Class c2, Object server) {
        Field[] fieldArray = c2.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field ff = fieldArray[n3];
            if (ff.isAnnotationPresent(MaxMessageSize.class)) {
                try {
                    ff.setAccessible(true);
                    if (ff.getType().equals(Integer.TYPE) || ff.getType().equals(Integer.class)) {
                        return ((Integer)ff.get(server)).intValue();
                    }
                    if (ff.getType().equals(Long.TYPE) || ff.getType().equals(Long.class)) {
                        return (Long)ff.get(server);
                    }
                    throw Factory.error("Incorrect Type for MaxRequestSize (" + ff.getType().getSimpleName() + ")");
                }
                catch (IllegalAccessException e2) {
                    throw Factory.error("MaxRequestSize Field '" + ff.getName() + "' is not accessible in " + c2.getCanonicalName());
                }
            }
            ++n3;
        }
        return 0L;
    }

    public static RuntimeException error(String s2) {
        return new RuntimeException(s2);
    }

    public static RuntimeException error(Throwable t) {
        return new RuntimeException(t);
    }

    private static class Except
    extends List.Pred<Method> {
        private Except() {
        }

        @Override
        public boolean huh(Method m) {
            return m.isAnnotationPresent(ExceptionHandler.class);
        }
    }
}

