/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.http.classes;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.http.classes.HTTPReq;
import edu.neu.ccs.demeterf.http.classes.HTTPVer;
import edu.neu.ccs.demeterf.http.classes.MsgHead;
import edu.neu.ccs.demeterf.http.classes.PrintHeapToString;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.ident;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;

public class HTTPResp {
    protected final HTTPVer ver;
    protected final int resp;
    protected final ident label;
    protected final List<MsgHead> keys;
    protected final ident body;
    public static final int OK = 200;
    public static final int NOT_FOUND = 404;
    public static final int MIN_OK = 200;
    public static final int MAX_OK = 299;
    public static final int MIN_ERROR = 400;
    public static final int MIN_SERVER_ERROR = 500;
    public static final int MAX_ERROR = 599;
    public static final HTTPVer VER = new HTTPVer(1.0);

    public HTTPResp(HTTPVer ver2, int resp2, ident label2, List<MsgHead> keys2, ident body2) {
        this.ver = ver2;
        this.resp = resp2;
        this.label = label2;
        this.keys = keys2;
        this.body = body2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HTTPResp)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        HTTPResp oo = (HTTPResp)o;
        return ((Object)this.ver).equals(oo.ver) && ((Object)this.resp).equals(oo.resp) && ((Object)this.label).equals(oo.label) && ((Object)this.keys).equals(oo.keys) && ((Object)this.body).equals(oo.body);
    }

    public static HTTPResp create(int resp2, String desc, List<MsgHead> hds, String body2) {
        return HTTPResp.createNoLen(resp2, new ident(desc), hds.append(new MsgHead("Content-Length", "" + body2.length())), new ident(body2));
    }

    private static HTTPResp createNoLen(int resp2, ident label2, List<MsgHead> hds, ident body2) {
        return new HTTPResp(VER, resp2, label2, hds, body2);
    }

    public static HTTPResp ok(String type2, String body2) {
        return HTTPResp.create(200, "OK", HTTPResp.commonHeaders(type2), body2);
    }

    private static List<MsgHead> commonHeaders(String type2) {
        return List.create(new MsgHead("Date", "" + new Date()), new MsgHead("Content-Type", type2));
    }

    public static HTTPResp error() {
        return HTTPResp.textError("");
    }

    public static HTTPResp error(String body2) {
        return HTTPResp.textError(body2);
    }

    public static HTTPResp error(int errCode, String msg, String body2) {
        return HTTPResp.textError(errCode, msg, body2);
    }

    public static HTTPResp textError(String body2) {
        return HTTPResp.textError(404, "Not Found", body2);
    }

    public static HTTPResp textError(int errCode, String msg, String body2) {
        return HTTPResp.create(errCode, msg, HTTPResp.commonHeaders("text/plain"), body2);
    }

    public static HTTPResp htmlError(String body2) {
        return HTTPResp.htmlError(404, "Not Found", body2);
    }

    public static HTTPResp htmlError(int errCode, String msg, String body2) {
        return HTTPResp.create(errCode, msg, HTTPResp.commonHeaders("text/html"), body2);
    }

    public static HTTPResp textResponse(String text2) {
        return HTTPResp.ok("text/plain", text2);
    }

    public static HTTPResp htmlResponse(String text2) {
        return HTTPResp.ok("text/html", text2);
    }

    public HTTPResp addHeader(String key2, String val2) {
        return HTTPResp.createNoLen(this.resp, this.label, this.keys.append(new MsgHead(key2, val2)), this.body);
    }

    public boolean isOK() {
        return this.resp >= 200 && this.resp <= 299;
    }

    public boolean isError() {
        return this.resp >= 400 && this.resp <= 599;
    }

    public boolean isServerError() {
        return this.resp >= 500 && this.resp <= 599;
    }

    public boolean isClientError() {
        return this.resp >= 400 && this.resp < 500;
    }

    public void toSocket(Socket s2) {
        try {
            PrintWriter outt = new PrintWriter(s2.getOutputStream());
            outt.print(this.toString());
            outt.flush();
            s2.shutdownOutput();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static HTTPResp fromSocket(Socket s2) {
        return HTTPResp.fromSocket(s2, 0L);
    }

    public static HTTPResp fromSocket(Socket s2, long maxBytes) {
        return HTTPResp.fromSocket(s2, 0, maxBytes);
    }

    public static HTTPResp fromSocket(Socket s2, int respTimeout, long maxBytes) {
        try {
            s2.setSoTimeout(respTimeout);
            HTTPResp resp2 = HTTPResp.fromInputStream(s2.getInputStream(), respTimeout, maxBytes);
            s2.shutdownInput();
            return resp2;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static HTTPResp fromInputStream(InputStream inpt) {
        return HTTPResp.fromInputStream(inpt, 0L);
    }

    public static HTTPResp fromInputStream(InputStream inpt, long maxBytes) {
        return HTTPResp.fromInputStream(inpt, 0L, maxBytes);
    }

    public static HTTPResp fromInputStream(InputStream inpt, long timeout, long maxBytes) {
        try {
            BufferedReader inn = new BufferedReader(new InputStreamReader(inpt));
            String first2 = HTTPReq.readLine(inn, timeout);
            if (first2 == null) {
                throw new RuntimeException("Empty HTTP Header");
            }
            HTTPVer v2 = HTTPVer.parse(first2);
            first2 = first2.substring(first2.indexOf(32) + 1);
            int b = first2.indexOf(32);
            int rnum = Integer.parseInt(first2.substring(0, b));
            HTTPReq.CountHds headers = HTTPReq.parseMsgHeads(inn, timeout, maxBytes, maxBytes - (long)(first2.length() + 1));
            return new HTTPResp(v2, rnum, new ident(first2.substring(b + 1)), headers.heads, HTTPReq.parseBody(inn, timeout, maxBytes, maxBytes - ((long)(first2.length() + 1) + headers.size)));
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    public String getBodyString() {
        return "" + this.body;
    }

    public Map<String, String> getHeaders() {
        return HTTPReq.getHeaders(this.keys);
    }

    public String toString() {
        return PrintHeapToString.PrintHeapToStringM(this);
    }

    public HTTPVer getVer() {
        return this.ver;
    }

    public int getResp() {
        return this.resp;
    }

    public ident getLabel() {
        return this.label;
    }

    public List<MsgHead> getKeys() {
        return this.keys;
    }

    public ident getBody() {
        return this.body;
    }

    public static class body
    extends Fields.any {
    }

    public static class keys
    extends Fields.any {
    }

    public static class label
    extends Fields.any {
    }

    public static class resp
    extends Fields.any {
    }

    public static class ver
    extends Fields.any {
    }
}

