/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.parallel.ParTraversal;
import java.util.Random;

public class ParallelTree {
    static leaf leaf = new leaf();
    static Random rand = new Random();

    static int randInt() {
        return rand.nextInt(2000);
    }

    static bst generate(int depth) {
        if (depth == 0) {
            return leaf;
        }
        return new node(ParallelTree.randInt(), ParallelTree.generate(depth - 1), ParallelTree.generate(depth - 1));
    }

    static Traversal pTrav(ID b) {
        return new ParTraversal(b);
    }

    static Traversal sTrav(ID b) {
        return new Traversal(b);
    }

    public static void main(String[] s2) {
        Traversal ssum = ParallelTree.sTrav(new SumTree());
        Traversal psum = ParallelTree.pTrav(new SumTree());
        bst t = ParallelTree.generate(10);
        Long l2 = System.currentTimeMillis();
        System.out.println("  S-SUM: " + ssum.traverse(t));
        System.out.println(" S-Time: " + (double)(System.currentTimeMillis() - l2) / 1000.0 + " sec");
        l2 = System.currentTimeMillis();
        System.out.println("  P-SUM: " + psum.traverse(t));
        System.out.println(" P-Time: " + (double)(System.currentTimeMillis() - l2) / 1000.0 + " sec\n");
    }

    static class SumTree
    extends ID {
        SumTree() {
        }

        int combine(leaf l2) {
            return 0;
        }

        int combine(node n2, int d2, int l2, int r2) {
            return d2 + l2 + r2;
        }
    }

    static abstract class bst {
        bst() {
        }

        public String toString() {
            return (String)new Traversal(new ID(){

                String combine(leaf l2) {
                    return "_";
                }

                String combine(node n2, int d2, String l2, String r2) {
                    return "(" + d2 + " " + l2 + " " + r2 + ")";
                }
            }).traverse(this);
        }
    }

    static class leaf
    extends bst {
        leaf() {
        }
    }

    static class node
    extends bst {
        int data;
        bst left;
        bst right;

        node(int d2, bst l2, bst r2) {
            this.data = d2;
            this.left = l2;
            this.right = r2;
        }
    }
}

