/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.examples.Char;
import edu.neu.ccs.demeterf.examples.NewLine;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.stackless.HeapTrav;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class Editor
extends JComponent
implements KeyListener {
    List<Char> buff = List.create();
    List<Char> clip = this.buff;
    int len = 0;
    int index = 0;
    int select = -1;
    static Font font = new Font("courier", 0, 12);
    String file = "";

    Editor() {
    }

    void checkSelect(KeyEvent ke) {
        if (ke.isShiftDown()) {
            if (this.select < 0) {
                this.select = this.index;
            }
        } else {
            this.select = -1;
        }
    }

    FRes findLine(List<Char> end) {
        int dist = 0;
        while (!end.isEmpty() && !end.top().isNewLine()) {
            end = end.pop();
            ++dist;
        }
        return new FRes(dist, end);
    }

    void delete(boolean back) {
        if (!this.buff.isEmpty()) {
            if (this.select < 0) {
                if (back && this.index > 0 || !back && this.index != this.len) {
                    if (back) {
                        --this.index;
                    }
                    this.buff = this.buff.remove(this.index);
                    --this.len;
                }
            } else {
                int mn = Math.min(this.select, this.index);
                int mx = Math.max(this.select, this.index);
                int i = 0;
                while (i < mx - mn) {
                    this.buff = this.buff.remove(mn);
                    ++i;
                }
                this.select = -1;
                this.index = mn;
                this.len -= mx - mn;
            }
        }
    }

    boolean testChar(Char c2, boolean letter) {
        return letter == Character.isLetter(c2.toChar());
    }

    int LRarrow(KeyEvent ke, List<Char> end) {
        int dist = 0;
        if (ke.isControlDown()) {
            if (!end.isEmpty()) {
                boolean test = Character.isLetter(end.top().toChar());
                int times = test ? 1 : 2;
                while (true) {
                    if (!end.isEmpty() && this.testChar(end.top(), test)) {
                        end = end.pop();
                        ++dist;
                        continue;
                    }
                    test = true;
                    if (--times <= 0) break;
                }
            }
        } else {
            dist = 1;
        }
        return dist;
    }

    int UParrow(KeyEvent ke, List<Char> end) {
        if (ke.isControlDown()) {
            return this.len;
        }
        FRes res2 = this.findLine(end);
        if (res2.lst.isEmpty()) {
            return res2.dist;
        }
        return Math.max(this.findLine(res2.lst.pop()).dist + 1, res2.dist + 1);
    }

    int DNarrow(KeyEvent ke, List<Char> b) {
        if (ke.isControlDown()) {
            return this.len;
        }
        FRes front = this.findLine(b.reverse(this.index));
        FRes back = this.findLine(b.pop(this.index));
        if (back.lst.isEmpty()) {
            return back.dist;
        }
        return Math.min(back.dist + front.dist + 1, back.dist + this.findLine(back.lst.pop()).dist + 1);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 35: {
                this.checkSelect(ke);
                this.index += this.findLine(this.buff.pop((int)this.index)).dist;
                break;
            }
            case 36: {
                this.checkSelect(ke);
                this.index -= this.findLine(this.buff.reverse((int)this.index)).dist;
                break;
            }
            case 37: {
                this.checkSelect(ke);
                this.index -= this.LRarrow(ke, this.buff.reverse(this.index));
                break;
            }
            case 39: {
                this.checkSelect(ke);
                this.index += this.LRarrow(ke, this.buff.pop(this.index));
                break;
            }
            case 38: {
                this.checkSelect(ke);
                this.index -= this.UParrow(ke, this.buff.reverse(this.index));
                break;
            }
            case 40: {
                this.checkSelect(ke);
                this.index += this.DNarrow(ke, this.buff);
            }
        }
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.len) {
            this.index = this.len;
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (ke.isControlDown()) {
            this.control(ke);
            return;
        }
        switch (ke.getKeyChar()) {
            case '\b': {
                this.delete(true);
                break;
            }
            case '\u007f': {
                this.delete(false);
                break;
            }
            default: {
                this.buff = this.buff.add(Char.create(ke.getKeyChar()), this.index++);
                ++this.len;
            }
        }
        this.repaint();
    }

    void control(KeyEvent ke) {
        System.out.println("CONTROL:" + ke.getKeyChar() + " == " + 67);
        System.out.println("CODE:" + ke.getKeyCode());
        switch (ke.getKeyChar()) {
            case '\u0013': {
                this.save();
                break;
            }
            case '\u0017': {
                this.write(this.file, true);
                break;
            }
            case '\u0006': {
                this.open();
                break;
            }
            case '\u0003': {
                this.copy();
                break;
            }
            case '\u0016': {
                this.paste();
                break;
            }
            case '\u0018': {
                this.cut();
            }
        }
    }

    @Override
    public void paint(final Graphics g) {
        g.setFont(font);
        g.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        new HeapTrav(new ID(){

            int update(Cons c2, Cons.rest f, int i) {
                return i - 1;
            }

            Pos combine(Empty l2, int i) {
                return this.cursor(g, new Pos(12, 24), i, 0);
            }

            Pos combine(Cons<Char> l2, NewLine n2, Pos p, int i) {
                return this.cursor(g, new Pos(12, p.y + 15), i, -1);
            }

            Pos combine(Cons<Char> l2, Char c2, Pos p, int i) {
                int w = g.getFontMetrics().charWidth(c2.toChar()) + 1;
                this.cursor(g, p, i, w);
                this.selection(g, p, i, w);
                g.drawChars(new char[]{c2.toChar()}, 0, 1, p.x, p.y);
                if (p.x + w > Editor.this.getWidth() - 24) {
                    return new Pos(12, p.y + 15);
                }
                return new Pos(p.x + w, p.y);
            }

            Pos cursor(Graphics g2, Pos p, int i, int w) {
                if (i == Editor.this.index) {
                    g2.fillRect(p.x + w, p.y - 12, 2, 15);
                }
                return p;
            }

            void selection(Graphics g2, Pos p, int i, int w) {
                if (Editor.this.select < 0) {
                    return;
                }
                if (Editor.this.index > Editor.this.select && Editor.this.select < i && i <= Editor.this.index || Editor.this.index < Editor.this.select && Editor.this.index < i && i <= Editor.this.select) {
                    Color prev = g2.getColor();
                    g2.setColor(Color.lightGray);
                    g2.fillRect(p.x, p.y - 12, w, 15);
                    g2.setColor(prev);
                }
            }
        }, Control.builtins(Char.class)).traverse(this.buff.reverse(), this.len);
    }

    void save() {
        if (this.file.length() == 0) {
            this.write("untitled.txt", true);
        } else {
            this.write(this.file, false);
        }
    }

    void write(String fname, boolean ask) {
        if (ask) {
            JFileChooser chs;
            int res2;
            if (fname.charAt(0) != '/') {
                fname = "./" + fname;
            }
            if ((res2 = (chs = new JFileChooser(fname.substring(0, fname.lastIndexOf(47)))).showSaveDialog(this)) == 0) {
                this.file = fname = chs.getSelectedFile().getAbsolutePath();
            } else {
                return;
            }
        }
        List<Char> temp = this.buff;
        try {
            FileOutputStream out = new FileOutputStream(fname);
            while (!temp.isEmpty()) {
                out.write(temp.top().toChar());
                temp = temp.pop();
            }
        }
        catch (IOException e2) {
            System.err.println("ERROR: " + e2);
        }
    }

    void open() {
        JFileChooser chs;
        int res2;
        String f = this.file;
        if (this.file.length() == 0 || f.charAt(0) != '/') {
            f = "./" + f;
        }
        if ((res2 = (chs = new JFileChooser(f.substring(0, f.lastIndexOf(47)))).showOpenDialog(this)) != 0) {
            return;
        }
        f = chs.getSelectedFile().getAbsolutePath();
        System.err.println("FILE: " + f);
        this.file = f;
        this.buff = Editor.read(f);
        this.index = 0;
        this.len = this.buff.length();
        this.repaint();
    }

    void copy() {
        int st = Math.min(this.select, this.index);
        int ed = Math.max(this.select, this.index);
        this.clip = this.buff.reverse(ed).reverse(ed - st);
        this.select = -1;
    }

    void cut() {
        int sel = this.select;
        if (sel >= 0) {
            this.copy();
            this.select = sel;
            this.delete(true);
        }
    }

    void paste() {
        System.out.println("Paste: " + this.clip);
        if (!this.clip.isEmpty()) {
            if (this.select >= 0) {
                this.delete(true);
            }
            List<Char> tclip = this.clip.reverse();
            while (!tclip.isEmpty()) {
                this.buff = this.buff.add(tclip.top(), Math.max(0, this.index));
                ++this.len;
                tclip = tclip.pop();
            }
            this.index += this.clip.length();
        }
    }

    public static void main(String[] s2) {
        JFrame f = new JFrame();
        Editor e2 = new Editor();
        f.getContentPane().add(e2);
        f.addKeyListener(e2);
        f.setSize(300, 300);
        f.setLocation(200, 100);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public static List<Char> read(String s2) {
        List<Char> lst = List.create();
        try {
            FileInputStream in = new FileInputStream(s2);
            while (in.available() > 0) {
                lst = lst.push(Char.create((char)in.read()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lst.reverse();
    }

    static class FRes {
        int dist;
        List<Char> lst;

        FRes(int d2, List<Char> l2) {
            this.dist = d2;
            this.lst = l2;
        }
    }

    public static class Pos {
        int x;
        int y;

        Pos(int xx, int yy) {
            this.x = xx;
            this.y = yy;
        }
    }
}

