/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.compose.CompTraversal;

public class Compose {
    static BST<Integer> build(int k, BST<Integer> t, int[] a) {
        if (k >= a.length) {
            return t;
        }
        return Compose.build(k + 1, t.insert(a[k]), a);
    }

    public static void main(String[] args2) {
        int[] nArray = new int[10];
        nArray[0] = 6;
        nArray[1] = 3;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[5] = 9;
        nArray[6] = 4;
        nArray[7] = 7;
        nArray[8] = 10;
        nArray[9] = 8;
        BST<Integer> tree2 = Compose.build(0, new BST<Integer>(), nArray);
        System.out.print("   Tree: " + tree2.toString() + "\n");
        System.out.print(" Height: " + Height.height(tree2) + "\n");
        System.out.print("   Diam: " + Diam.diameter(tree2) + "\n");
    }

    static class BST<T extends Comparable> {
        BST() {
        }

        public String toString() {
            return (String)new Traversal(new ID(){

                String combine(BST<?> l2) {
                    return "";
                }

                String combine(Node<?> t, int d2, String l2, String r2) {
                    return "(" + d2 + l2 + r2 + ")";
                }
            }).traverse(this);
        }

        BST<T> insert(T d2) {
            return new Node<T>(d2, this, this);
        }
    }

    static class Diam
    extends ID {
        Diam() {
        }

        int combine(BST<?> l2) {
            return 0;
        }

        int combine(Node<?> t, int d2, int l2, int r2, HTrip h) {
            return Math.max(h.lh + h.rh + 1, Math.max(l2, r2));
        }

        static int diameter(BST<Integer> t) {
            return (Integer)new CompTraversal(new Height(), new Diam()).traverseLast(t);
        }
    }

    static class HTrip {
        int ch;
        int lh;
        int rh;

        HTrip() {
            this(0, 0, 0);
        }

        HTrip(int c2, int l2, int r2) {
            this.ch = c2;
            this.lh = l2;
            this.rh = r2;
        }
    }

    static class Height
    extends ID {
        Height() {
        }

        HTrip combine(BST<?> l2) {
            return new HTrip();
        }

        HTrip combine(Node<?> t, int d2, HTrip l2, HTrip r2) {
            return new HTrip(1 + Math.max(l2.ch, r2.ch), l2.ch, r2.ch);
        }

        static int height(BST<Integer> t) {
            return ((HTrip)new Traversal((FC)new Height()).traverse(t)).ch;
        }
    }

    static class Node<T extends Comparable>
    extends BST<T> {
        T data;
        BST<T> left;
        BST<T> right;

        Node(T d2, BST<T> l2, BST<T> r2) {
            this.data = d2;
            this.left = l2;
            this.right = r2;
        }

        @Override
        BST<T> insert(T d2) {
            if (d2.compareTo(this.data) > 0) {
                return new Node<T>(this.data, this.left.insert(d2), this.right);
            }
            return new Node<T>(this.data, this.left, this.right.insert(d2));
        }
    }
}

