/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.classes;

import edu.neu.ccs.demeterf.Fields;
import edu.neu.ccs.demeterf.demfgen.classes.DGPUses;
import edu.neu.ccs.demeterf.demfgen.classes.ImportList;
import edu.neu.ccs.demeterf.demfgen.classes.IncludeList;
import edu.neu.ccs.demeterf.demfgen.classes.LookDef;
import edu.neu.ccs.demeterf.demfgen.classes.PackageDef;
import edu.neu.ccs.demeterf.demfgen.classes.ParseException;
import edu.neu.ccs.demeterf.demfgen.classes.Print;
import edu.neu.ccs.demeterf.demfgen.classes.TheParser;
import edu.neu.ccs.demeterf.demfgen.classes.ToStr;
import edu.neu.ccs.demeterf.demfgen.classes.ToXML;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefList;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class CDFile {
    public final IncludeList incl;
    public final DGPUses dgpuse;
    public final PackageDef pkg;
    public final LookDef look;
    public final ImportList imports;
    public final TypeDefList types;

    public CDFile(IncludeList incl2, DGPUses dgpuse2, PackageDef pkg2, LookDef look2, ImportList imports2, TypeDefList types2) {
        this.incl = incl2;
        this.dgpuse = dgpuse2;
        this.pkg = pkg2;
        this.look = look2;
        this.imports = imports2;
        this.types = types2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CDFile)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        CDFile oo = (CDFile)o;
        return this.incl.equals(oo.incl) && this.dgpuse.equals(oo.dgpuse) && this.pkg.equals(oo.pkg) && this.look.equals(oo.look) && this.imports.equals(oo.imports) && this.types.equals(oo.types);
    }

    public static CDFile parse(String inpt) throws ParseException {
        return new TheParser(new StringReader(inpt)).parse_CDFile();
    }

    public static CDFile parse(InputStream inpt) throws ParseException {
        return new TheParser(inpt).parse_CDFile();
    }

    public static CDFile parse(Reader inpt) throws ParseException {
        return new TheParser(inpt).parse_CDFile();
    }

    public CDFile addType(TypeDef td) {
        return this.updateTypes(this.types.push(td));
    }

    public String print() {
        return Print.PrintM(this);
    }

    public String toStr() {
        return ToStr.ToStrM(this);
    }

    public String toXML() {
        return ToXML.ToXMLM(this);
    }

    public CDFile updateIncl(IncludeList _incl) {
        return new CDFile(_incl, this.dgpuse, this.pkg, this.look, this.imports, this.types);
    }

    public CDFile updateDgpuse(DGPUses _dgpuse) {
        return new CDFile(this.incl, _dgpuse, this.pkg, this.look, this.imports, this.types);
    }

    public CDFile updatePkg(PackageDef _pkg) {
        return new CDFile(this.incl, this.dgpuse, _pkg, this.look, this.imports, this.types);
    }

    public CDFile updateLook(LookDef _look) {
        return new CDFile(this.incl, this.dgpuse, this.pkg, _look, this.imports, this.types);
    }

    public CDFile updateImports(ImportList _imports) {
        return new CDFile(this.incl, this.dgpuse, this.pkg, this.look, _imports, this.types);
    }

    public CDFile updateTypes(TypeDefList _types) {
        return new CDFile(this.incl, this.dgpuse, this.pkg, this.look, this.imports, _types);
    }

    public IncludeList getIncl() {
        return this.incl;
    }

    public DGPUses getDgpuse() {
        return this.dgpuse;
    }

    public PackageDef getPkg() {
        return this.pkg;
    }

    public LookDef getLook() {
        return this.look;
    }

    public ImportList getImports() {
        return this.imports;
    }

    public TypeDefList getTypes() {
        return this.types;
    }

    public static class dgpuse
    extends Fields.any {
    }

    public static class imports
    extends Fields.any {
    }

    public static class incl
    extends Fields.any {
    }

    public static class look
    extends Fields.any {
    }

    public static class pkg
    extends Fields.any {
    }

    public static class types
    extends Fields.any {
    }
}

