/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.demfgen.DemFGenMain;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.classes.PackageDef;
import edu.neu.ccs.demeterf.lib.List;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Make {
    public static void make(String dir, PackageDef basepkg, boolean parse, List<String> opts, int libidx, List<String> pkgdirs) {
        boolean win = Diff.optionSet("--windows");
        boolean noshell = Diff.optionSet("--noshell");
        boolean comp = Diff.optionSet("--build");
        String basedir = DemFGenMain.pkgdir(dir, basepkg, true);
        if (parse) {
            DemFGenMain.p(String.valueOf(Diff.d.makeParseMsg) + "\n");
            if (win) {
                Make.runCmd(Diff.d.mkWinParseCmd(basedir), Diff.d.parserGen);
            } else if (noshell) {
                Make.runCmd(Diff.d.mkParseCmdNoShell(basedir), Diff.d.parserGen);
            } else {
                Make.runCmd(Diff.d.mkParseCmd(basedir), Diff.d.parserGen);
            }
        }
        if (libidx >= 0) {
            DemFGenMain.p(String.valueOf(Diff.d.makeBuildMsg) + "\n");
            String name2 = opts.lookup(libidx);
            int colon = name2.indexOf(":");
            if (win) {
                Make.runCmd(Diff.d.buildWinCmd(pkgdirs, true, name2.substring(colon + 1)), "CSC");
            } else {
                Make.runCmd(Diff.d.buildCmd(pkgdirs, true, name2.substring(colon + 1)), Diff.d.compilerName);
            }
        } else if (comp) {
            DemFGenMain.p(String.valueOf(Diff.d.makeBuildMsg) + "\n");
            if (win) {
                Make.runCmd(Diff.d.buildWinCmd(pkgdirs, false, ""), "CSC");
            } else {
                Make.runCmd(Diff.d.buildCmd(pkgdirs, false, ""), Diff.d.compilerName);
            }
        }
    }

    static void runCmd(String[] s2, String label2) {
        try {
            int result;
            Runtime run = Runtime.getRuntime();
            Process cmd = run.exec(s2);
            StringBuffer eb = new StringBuffer();
            StringBuffer ib = new StringBuffer();
            Read r2 = new Read(eb, cmd.getErrorStream());
            r2.start();
            new Read(ib, cmd.getInputStream()).start();
            try {
                result = cmd.waitFor();
            }
            catch (InterruptedException ie) {
                result = 1;
            }
            try {
                r2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (result != 0) {
                DemFGenMain.p("\n\n !! " + label2 + " Errors:\n\n");
                DemFGenMain.p(eb.toString());
                DemFGenMain.p(String.valueOf(ib.toString()) + "\n");
                System.exit(1);
            } else if (r2.didWarn()) {
                DemFGenMain.p("\n\n !! " + label2 + " Warnings:\n\n");
                DemFGenMain.p(String.valueOf(r2.warnings()) + "\n");
            }
        }
        catch (IOException e2) {
            DemFGenMain.p(" !! Exception :" + e2.getMessage() + "\n");
        }
    }

    static class Read
    extends Thread {
        StringBuffer sb;
        StringBuffer warn = new StringBuffer();
        BufferedReader rd;
        static final String tab = "    ";

        Read(StringBuffer s2, InputStream i) {
            this.sb = s2;
            this.rd = new BufferedReader(new InputStreamReader(i));
        }

        @Override
        public void run() {
            try {
                String s2 = "";
                while ((s2 = this.rd.readLine()) != null) {
                    if (s2.startsWith("Warning")) {
                        do {
                            this.sb.append(tab + this.breakUp(s2)).append("\n");
                            this.warn.append(tab + this.breakUp(s2)).append("\n");
                        } while ((s2 = this.rd.readLine()) != null && s2.startsWith(" "));
                    }
                    if (s2 == null) continue;
                    this.sb.append(tab + this.breakUp(s2)).append("\n");
                }
            }
            catch (IOException e2) {
                System.err.println("\n\n !! Error:\n" + e2.getMessage());
                System.exit(1);
            }
        }

        String breakUp(String s2) {
            if (s2.length() > 80) {
                int i = 80;
                while (i < s2.length() && Character.isWhitespace(s2.charAt(i))) {
                    ++i;
                }
                return String.valueOf(s2.substring(0, i)) + "\n" + tab + "  " + this.breakUp(s2.substring(i));
            }
            return s2;
        }

        public boolean didWarn() {
            return this.warn.length() > 0;
        }

        public String warnings() {
            return this.warn.toString();
        }
    }
}

