/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TP;
import edu.neu.ccs.demeterf.TU;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.demfgen.ClassHier;
import edu.neu.ccs.demeterf.demfgen.CollectInherit;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.Factory;
import edu.neu.ccs.demeterf.demfgen.GraphGen;
import edu.neu.ccs.demeterf.demfgen.IncludeCDs;
import edu.neu.ccs.demeterf.demfgen.Make;
import edu.neu.ccs.demeterf.demfgen.ParseGen;
import edu.neu.ccs.demeterf.demfgen.Preamble;
import edu.neu.ccs.demeterf.demfgen.StrLTrip;
import edu.neu.ccs.demeterf.demfgen.TypeCheck;
import edu.neu.ccs.demeterf.demfgen.classes.BehDef;
import edu.neu.ccs.demeterf.demfgen.classes.BehFile;
import edu.neu.ccs.demeterf.demfgen.classes.Bound;
import edu.neu.ccs.demeterf.demfgen.classes.CDFile;
import edu.neu.ccs.demeterf.demfgen.classes.ClassDef;
import edu.neu.ccs.demeterf.demfgen.classes.DoGen;
import edu.neu.ccs.demeterf.demfgen.classes.EmptyUseParams;
import edu.neu.ccs.demeterf.demfgen.classes.FieldCons;
import edu.neu.ccs.demeterf.demfgen.classes.FieldEmpty;
import edu.neu.ccs.demeterf.demfgen.classes.FieldList;
import edu.neu.ccs.demeterf.demfgen.classes.FieldOrSyntax;
import edu.neu.ccs.demeterf.demfgen.classes.Impl;
import edu.neu.ccs.demeterf.demfgen.classes.ImportList;
import edu.neu.ccs.demeterf.demfgen.classes.NameDef;
import edu.neu.ccs.demeterf.demfgen.classes.PESubtypeList;
import edu.neu.ccs.demeterf.demfgen.classes.PackageDef;
import edu.neu.ccs.demeterf.demfgen.classes.ParseException;
import edu.neu.ccs.demeterf.demfgen.classes.Print;
import edu.neu.ccs.demeterf.demfgen.classes.RTFileNotFound;
import edu.neu.ccs.demeterf.demfgen.classes.RTParseException;
import edu.neu.ccs.demeterf.demfgen.classes.StaticTP;
import edu.neu.ccs.demeterf.demfgen.classes.Syntax;
import edu.neu.ccs.demeterf.demfgen.classes.TE;
import edu.neu.ccs.demeterf.demfgen.classes.TokenMgrError;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.demfgen.classes.TypeUse;
import edu.neu.ccs.demeterf.demfgen.dgp.DGPFunc;
import edu.neu.ccs.demeterf.demfgen.pcdgp.PCDGPFunc;
import edu.neu.ccs.demeterf.demfgen.traversals.Travs;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.dispatch.TypeSearchException;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.lib.RE;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.CLI;
import edu.neu.ccs.demeterf.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

public class DemFGenMain {
    static boolean quiet = false;

    public static void p(String s2) {
        if (!quiet) {
            System.err.print(s2);
        }
    }

    static String gap(int len) {
        if (len <= 0) {
            return "";
        }
        return " " + DemFGenMain.gap(len - 1);
    }

    public static void abort() {
        System.exit(1);
    }

    public static void header(String lang) {
        DemFGenMain.p("\n                 \u25e4------------------------------\u25e5\n                 |         DemeterF " + lang + DemFGenMain.gap(12 - lang.length()) + "|" + "\n                 |          " + Diff.buildDate + "          |" + "\n                 \u25e3------------------------------\u25e2\n\n");
    }

    static void timing(String what, long start2) {
        System.out.print(String.valueOf(System.currentTimeMillis() - start2) + ",");
    }

    public static void main(String[] args2, String lang) throws Exception {
        List<String> unknown;
        long time = System.currentTimeMillis();
        List<String>[] all = CLI.splitArgs(args2);
        List<String> opts = all[CLI.OPTS];
        Diff.storeOptions(opts);
        String[] nonOpt = all[CLI.ARGS].toArray((String[])new String[all[CLI.ARGS].length()]);
        quiet = Diff.optionSet("--quiet");
        DemFGenMain.header(lang);
        if (Diff.optionSet("--help")) {
            DemFGenMain.usage(true, "");
        }
        if (nonOpt.length != 3) {
            DemFGenMain.usage(false, "Not enough arguments");
        }
        if (!(unknown = CLI.invalidOptions(opts, Diff.validOptions)).isEmpty()) {
            DemFGenMain.usage(false, "Unknown Option(s): " + unknown.toString(", ", ""));
        }
        String cdFile = nonOpt[0];
        String behFile = nonOpt[1];
        String outDir = nonOpt[2];
        if (outDir.lastIndexOf(File.separatorChar) == outDir.length() - 1) {
            outDir = outDir.substring(0, outDir.length() - 1);
        }
        final String dir = outDir;
        try {
            long starter = System.currentTimeMillis();
            List<CDFile> CDs = DemFGenMain.resolveCDFile(cdFile);
            List<BehDef> BEHs = DemFGenMain.resolveBEHFile(behFile);
            final PackageDef basepkg = CDs.top().getPkg();
            boolean parser = !Diff.optionSet("--noparse");
            starter = System.currentTimeMillis();
            Util.addBuiltIns(DoGen.class);
            if (!basepkg.hasPkg()) {
                DemFGenMain.p("\n !! Warning: No Root Package Specified\n     Parser/DGP classes may not be accessible\n\n");
            }
            List<ClassGen.ArityPair> arities = CDs.fold(new List.Fold<CDFile, List<ClassGen.ArityPair>>(){

                @Override
                public List<ClassGen.ArityPair> fold(CDFile f, List<ClassGen.ArityPair> r2) {
                    return TypeCheck.defsToList(f.getTypes()).append((ClassGen.ArityPair)((Object)r2));
                }
            }, ClassGen.Primitives);
            TypeCheck tc = new TypeCheck();
            Travs.TheFactory.makeTypeCheckTrav(tc).traverse(CDs, new TypeCheck.Env(arities));
            starter = System.currentTimeMillis();
            if (Diff.optionSet("--show")) {
                DemFGenMain.p("\n ** Full Class Dictionary:\n     " + Print.PrintM(CDs).replace("\n", "\n     "));
            }
            if (Diff.optionSet("--graph")) {
                DemFGenMain.p("\n ** Generating DOT Graph...\n");
                GraphGen.genGraph(CDs, dir);
                System.exit(0);
            } else {
                List<Object> funcs;
                List<ClassHier.InhrtPair> inhrtL = DemFGenMain.subtypes(CDs);
                Map<String, List<ClassHier.InhrtPair>> inhrtM = DemFGenMain.buildInhrtMap(inhrtL);
                String dgpMeths = "";
                int dgp = OptStart.index(opts, "--dgp:");
                if (dgp >= 0) {
                    DemFGenMain.p(" ** Loading DGP Functions...\n     [");
                    Type.addPath("edu.neu.ccs.demeterf.demfgen.dgp.");
                    funcs = DemFGenMain.loadDGP(CLI.separateOption("dgp", opts), new DGPLoad(), "DGP");
                    Type.removePath("edu.neu.ccs.demeterf.demfgen.dgp.");
                    DemFGenMain.p("]\n ** Generating DGP Functions...\n     [");
                    dgpMeths = funcs.foldl(new List.Fold<DGPFunc, String>(){

                        @Override
                        public String fold(DGPFunc f, String s2) {
                            return String.valueOf(f.method(basepkg.name())) + s2;
                        }
                    }, "");
                    DGPGen gen2 = new DGPGen(CDs, BEHs, dir, inhrtM);
                    starter = System.currentTimeMillis();
                    String names = Travs.makeDGPGenTrav(gen2).traverse(funcs);
                    DemFGenMain.p(names);
                    DemFGenMain.p("]\n");
                    DemFGenMain.timing("DGPFuncs", starter);
                }
                if (!Diff.optionSet("--nogen")) {
                    starter = System.currentTimeMillis();
                    funcs = List.create();
                    if (OptStart.index(opts, "--pcdgp:") >= 0) {
                        DemFGenMain.p(" ** Loading PCDGP Functions...\n     [");
                        Type.addPath("edu.neu.ccs.demeterf.demfgen.pcdgp.");
                        funcs = DemFGenMain.loadDGP(CLI.separateOption("pcdgp", opts), new PCDGPLoad(), "PCDGP");
                        Type.removePath("edu.neu.ccs.demeterf.demfgen.pcdgp.");
                        DemFGenMain.p("]\n");
                    }
                    starter = System.currentTimeMillis();
                    DemFGenMain.p(" ** Generating Classes...\n");
                    ClassGen.genClasses(CDs, BEHs, dir, dgpMeths, opts, inhrtM, funcs, basepkg);
                    DemFGenMain.timing("ClassGen", starter);
                }
                if (parser) {
                    starter = System.currentTimeMillis();
                    DemFGenMain.p(" ** Generating Parser...\n");
                    ParseGen.genParser(CDs, dir, inhrtM, basepkg);
                }
                if (!Diff.optionSet("--nogen")) {
                    starter = System.currentTimeMillis();
                    int lib = OptStart.index(opts, "--lib:");
                    List<String> pkgdirs = CDs.foldr(new List.Fold<CDFile, List<String>>(){

                        @Override
                        public List<String> fold(CDFile cd, List<String> r2) {
                            return cd.getTypes().anyGen() ? r2.push(DemFGenMain.pkgdir(dir, cd.getPkg(), true)) : r2;
                        }
                    }, List.create());
                    Make.make(dir, basepkg, parser && !Diff.optionSet("--noparsecc"), opts, lib, pkgdirs);
                }
                DemFGenMain.p(" ** Finished [" + DemFGenMain.seconds(System.currentTimeMillis() - time) + " sec.]");
                System.err.println();
                System.exit(0);
            }
        }
        catch (RE re2) {
            DemFGenMain.error(re2, "Runtime");
        }
        catch (RTParseException pe) {
            DemFGenMain.error(pe, "Parse");
        }
        catch (FileNotFoundException fe) {
            DemFGenMain.error(fe, "File");
        }
        catch (RTFileNotFound fe) {
            DemFGenMain.error(fe, "File");
        }
        catch (TE te) {
            DemFGenMain.error(te, "Type");
        }
        System.exit(1);
    }

    public static Map<String, List<ClassHier.InhrtPair>> buildInhrtMap(List<ClassHier.InhrtPair> inhrt) {
        return inhrt.foldr(new List.Fold<ClassHier.InhrtPair, Map<String, List<ClassHier.InhrtPair>>>(){

            @Override
            public Map<String, List<ClassHier.InhrtPair>> fold(ClassHier.InhrtPair p, Map<String, List<ClassHier.InhrtPair>> m) {
                return m.merge(p.child(), List.create(p), new Map.Merge<List<ClassHier.InhrtPair>>(){

                    @Override
                    public List<ClassHier.InhrtPair> merge(List<ClassHier.InhrtPair> a, List<ClassHier.InhrtPair> b) {
                        return b.append((ClassHier.InhrtPair)((Object)a));
                    }
                });
            }
        }, Map.create());
    }

    public static String pad(String s2, int i) {
        if (s2.length() >= i) {
            return s2;
        }
        return DemFGenMain.pad(String.valueOf(s2) + " ", i);
    }

    public static double seconds(long mil) {
        return (double)((int)((double)mil / 10.0)) / 100.0;
    }

    static void error(Throwable t, String type2) {
        System.err.print("\n\n !! " + type2 + " Error:\n" + t.getMessage() + "\n\n");
    }

    public static List<CDFile> resolveCDFile(String file2) throws FileNotFoundException {
        try {
            return DemFGenMain.resolveCDFile(new FileInputStream(file2), file2);
        }
        catch (ParseException pe) {
            throw new RTParseException(" ** CD File: \"" + file2 + "\"\n" + pe.getMessage());
        }
        catch (TokenMgrError te) {
            throw new RTParseException(" ** CD File: \"" + file2 + "\"\n" + te.getMessage());
        }
    }

    public static List<CDFile> resolveCDFile(InputStream in, String name2) throws ParseException {
        CDFile main = CDFile.parse(in);
        List<CDFile> CDs = IncludeCDs.resolveCDs(main.getIncl(), name2);
        ImportList imports2 = IncludeCDs.allImports(CDs.push(main));
        return CDs.push(main.updateImports(imports2));
    }

    public static List<BehDef> resolveBEHFile(String file2) throws FileNotFoundException {
        try {
            return DemFGenMain.resolveBEHFile(new FileInputStream(file2), file2);
        }
        catch (ParseException pe) {
            throw new RTParseException(" ** BEH File: \"" + file2 + "\"\n" + pe.getMessage());
        }
        catch (TokenMgrError te) {
            throw new RTParseException(" ** BEH File: \"" + file2 + "\"\n" + te.getMessage());
        }
    }

    public static List<BehDef> resolveBEHFile(InputStream in, String name2) throws ParseException {
        BehFile beh = BehFile.parse(in);
        return beh.getBehs().toList().append((BehDef)((Object)IncludeCDs.resolveBEHs(beh.getIncl(), name2)));
    }

    static void usage(boolean help, String bad) {
        DemFGenMain.p("\n" + (help ? "" : " !! " + bad + "\n\n") + " ** Usage: DemFGen [Options] <CD-File> <BEH-File> <Output-Dir>\n" + (!help ? " ** Use --help for a full description\n" : " The order/placement of options doesn't matter, but the relative\n    order of the manditory ones must be as shown.\n\n CD-File contains the CD to be generated,\n BEH-File contains the behavior to be used with classes,\n Output-Dir is the directory to place generated files\n\n Options can be: \n   --help            : Print this usage information.\n   --build           : " + Diff.d.makeInfo + "\n" + "   --lib:FILE        : Implies --build, Create a library named FILE from the\n" + "                         compiled/generated code (JAR for Java, DLL for C#)\n" + "   --windows         : Use Windows based command launches and CSC to compile\n" + "                         C# instead of GMCS. System PATH and CLASSPATH\n" + "                         variables need to be set correctly. Works with both\n" + "                         '--build' and '--lib'\n" + "   --noshell         : Use Java to run JavaCC, instead of trying to run commands\n" + "                         through BASH or Windows CMD\n" + "   --nogen           : Don't generate the classes... just DGP and Parser\n" + "   --noparse         : Don't generate the parser files or methods\n" + "   --noequals        : Don't generate the equals() methods\n" + "   --mutable         : Generate 'mutable' fields... not final/readonly\n" + "   --graph           : Just print a Dot file to StdOut\n" + "   --show            : Print the final deep parsed CD(s)\n" + "   --dgp:C1:...:Cn   : A Colon seperated List of Data-generic function\n" + "                         classes to be run/generated. Each class must be a\n" + "                         subclass of ...demeterf.demfgen.dgp.DGPFunc\n" + "                         and accessible in the current classpath.\n" + "       * Predefined classes are:\n" + "         - Objects to Strings, Each one can be used as a \"toString\" method\n" + "           by using the _ToString version\n" + "              Print, PrintToString         : in complete CD syntax\n" + "              PrintHeap, PrintHeapToString : Uses very little Java stack\n" + "                                             Same method Names as above\n" + "              PrintIter                    : Use iteration when possible\n" + "              Display, DisplayToString     : nested field/type information\n" + "              ToStr, ToString              : simple nested constructors\n" + "              ToXML                        : simple XML output\n" + "         - Useful methods\n" + "              HashCode                     : add deep hashcode methods\n" + "         - Static Code Generation:\n" + "              StaticTrav     : Create Static Traversal Class/Methods\n" + "                 use --nocontrol to eliminate Traversal control overhead\n" + "              StaticTravCtx  : Static Traversal with a context/argument\n" + "              StaticTP       : Create a static TP Class for the CD\n" + "              StaticTU       : Create a static TU Class for the CD\n" + "       * See the demfgen.dgp package source for more details.\n\n" + "   --pcdgp:C1:...:Cn : A Colon seperated List of Per-Class Data-generic function\n" + "                         classes to be run on each TypeDef. Classes must be a\n" + "                         subclass of ...demeterf.demfgen.pcdgp.PCDGPFunc\n" + "                         and accessible in the current classpath.\n" + "       * Predefined classes are:\n" + "         - Getters  : Add getters for all fields. For 'field' the getter is\n" + "                        created as 'getField()'.\n" + "         - Updaters : Adds an Update method for each field that returns an\n" + "                        updated instance; all other fields are the same, but\n" + "                        the selected field is replaced.\n" + "         - Creator  : Addes a static Creator method that mimics the constructor.\n" + "         - Setters  : Add setters for all fields.  ** The '--mutable' option\n" + "                        must be used in order for this to work.  Otherwise, try\n" + "                        using the Updaters instead.\n" + "       * See the demfgen.pcdgp package source for more details.\n") + "\n");
        System.exit(1);
    }

    static <X> List<X> loadDGP(String[] names, final Loader<X> load, final String typ) {
        return List.create(names).reverse().map(new List.Map<String, X>(){

            @Override
            public X map(String name2) {
                try {
                    return load.map(name2);
                }
                catch (TypeSearchException e2) {
                    DemFGenMain.p("\n !! DGP Error: Couldn't Find function class: '" + name2 + "'\n\n");
                }
                catch (LoadException e3) {
                    DemFGenMain.p("\n !! DGP Error: Class '" + name2 + "' isn't a subclass of " + typ + "Func\n\n");
                }
                catch (Exception e4) {
                    DemFGenMain.p("\n !! DGP Error: Couldn't create function: '" + name2 + "'\n\n");
                }
                DemFGenMain.abort();
                return null;
            }
        });
    }

    public static List<TypeDef> justTypes(List<CDFile> CD) {
        List types2 = (List)new JustTypes().traverse(CD);
        return types2;
    }

    public static List<TypeDef> flatten(List<CDFile> CD, Map<String, List<ClassHier.InhrtPair>> inhrt) {
        List<TypeDef> types2 = Travs.TheFactory.makeFlattenTrav(new Flat(inhrt)).traverse(DemFGenMain.justTypes(CD));
        return types2;
    }

    public static List<TypeDef> removeSyntax(List<TypeDef> types2) {
        return (List)Factory.newTraversal(new StaticTP(){

            FieldList combine(FieldCons l2, Syntax s2, FieldList r2) {
                return r2;
            }
        }, Control.builtins(Syntax.class)).traverseList_TypeDef_(types2);
    }

    public static String pkgdir(String dir, PackageDef pkg2, boolean create) {
        if (pkg2.hasPkg() && !Diff.optionSet("--flatdirs")) {
            String d2 = String.valueOf(dir) + File.separator + pkg2.dir();
            if (create) {
                Util.createWritableDir(d2);
            }
            return d2;
        }
        return dir;
    }

    static void do_DGPGen(List<DGPFunc> funcs, List<CDFile> CDs, List<BehDef> BEHs, String dir, Map<String, List<ClassHier.InhrtPair>> inhrt, long locstart) {
        DGPGen gen2 = new DGPGen(CDs, BEHs, dir, inhrt);
        String names = Travs.makeDGPGenTrav(gen2).traverse(funcs);
        DemFGenMain.p(names);
    }

    public static String behBody(List<BehDef> behs2, String c2) {
        List<BehDef> match = behs2.filter(new FindBeh(c2));
        return match.fold(new List.Fold<BehDef, String>(){

            @Override
            public String fold(BehDef b, String r2) {
                return String.valueOf(b.getBody().getText()) + r2;
            }
        }, "");
    }

    private static TypeDef instantiate(TypeDef td, List<StrLTrip.StrPair> env) {
        return (TypeDef)new Traversal(new Subst()).traverse((Object)td, env);
    }

    public static List<FieldOrSyntax> instantiate(List<FieldOrSyntax> fs, List<String> bnds, List<String> uses) {
        List<StrLTrip.StrPair> env = bnds.zip(new List.Zip<String, String, StrLTrip.StrPair>(){

            @Override
            public StrLTrip.StrPair zip(String b, String u) {
                return new StrLTrip.StrPair(b, u);
            }
        }, uses);
        return (List)new Traversal(new Subst()).traverse(fs, env);
    }

    public static TypeDef instantiate(TypeUse tu, List<TypeDef> aT) {
        String[] upar;
        TypeDef def = aT.find(new FindType("" + tu.getName()));
        String[] dpar = def.typeParams().toArray();
        if (dpar.length != (upar = tu.getTparams().toArray()).length) {
            throw new RuntimeException("Wrong number of Type parameters for " + def.name() + def.typeParams().print() + "\n  - Given " + upar.length + " in " + tu.print() + "!" + "\n Use: " + tu.print() + "\n Def: " + def.print() + "\n");
        }
        List<StrLTrip.StrPair> env = DemFGenMain.makeEnv(dpar, upar, 0);
        return DemFGenMain.instantiate(def, env);
    }

    public static List<StrLTrip.StrPair> makeEnv(String[] d2, String[] u, int i) {
        if (i == d2.length) {
            return List.create();
        }
        return DemFGenMain.makeEnv(d2, u, i + 1).push(new StrLTrip.StrPair(d2[i], u[i]));
    }

    public static List<ClassHier.InhrtPair> subtypes(List<CDFile> CD) {
        return CD.fold(new List.Fold<CDFile, List<ClassHier.InhrtPair>>(){

            @Override
            public List<ClassHier.InhrtPair> fold(CDFile f, List<ClassHier.InhrtPair> r2) {
                return CollectInherit.inheritPairs(f.getTypes()).append((ClassHier.InhrtPair)((Object)r2));
            }
        }, List.create());
    }

    public static class DGPGen
    extends FC {
        final List<TypeDef> types;
        final List<BehDef> BEHs;
        final Map<String, List<ClassHier.InhrtPair>> inhrt;
        final String dir;
        final String imports;
        final String suff;
        final PackageDef pkg;
        long total = 0L;

        public DGPGen(List<CDFile> CD, List<BehDef> Bs, String d2, Map<String, List<ClassHier.InhrtPair>> inh) {
            this.types = DemFGenMain.flatten(CD, inh);
            this.BEHs = Bs;
            this.inhrt = inh;
            this.imports = "" + IncludeCDs.allImports(CD);
            this.pkg = CD.top().getPkg();
            this.suff = CD.top().getPkg().hasPkg() ? Diff.d.classEnd : "";
            this.dir = DemFGenMain.pkgdir(d2, this.pkg, true);
        }

        public String combine(Cons<DGPFunc> e2, String f, String r2) {
            return String.valueOf(f) + r2;
        }

        public String combine(Empty<DGPFunc> e2) {
            return "";
        }

        public String combine(DGPFunc f) {
            long starter = System.currentTimeMillis();
            String name2 = f.fileName();
            String extra2 = DemFGenMain.behBody(this.BEHs, name2);
            DGPFunc.Trav trav = f.traversalObj(extra2, this.inhrt);
            String ret2 = trav.traverseOption_List_TypeDef__(Option.some(this.types));
            Util.writeFile(name2, "." + f.fileSuffix(), String.valueOf(ret2) + this.suff + "\n", this.dir, f.header(Preamble.header, this.pkg, this.imports));
            this.total += System.currentTimeMillis() - starter;
            return name2 + ", ";
        }
    }

    static class DGPLoad
    extends Loader<DGPFunc> {
        DGPLoad() {
        }

        @Override
        DGPFunc instance(Class<?> c2) throws Exception {
            if (DGPFunc.class.isAssignableFrom(c2)) {
                DemFGenMain.p(c2.getSimpleName() + ", ");
                return (DGPFunc)c2.newInstance();
            }
            throw new LoadException("Unknown DGPFunc");
        }
    }

    static class FIdent
    extends List.Pred<StrLTrip.StrPair> {
        String name;

        FIdent(ident look2) {
            this.name = "" + look2;
        }

        @Override
        public boolean huh(StrLTrip.StrPair t) {
            return this.name.equals(t.n);
        }
    }

    static class FindBeh
    extends List.Pred<BehDef> {
        String name;

        FindBeh(String n2) {
            this.name = n2;
        }

        @Override
        public boolean huh(BehDef b) {
            return this.name.equals("" + b.getName());
        }
    }

    static class FindType
    extends List.Pred<TypeDef> {
        String name;

        FindType(String n2) {
            this.name = n2;
        }

        @Override
        public boolean huh(TypeDef t) {
            return this.name.equals(t.name());
        }

        public String toString() {
            return "typedef[" + this.name + "]";
        }
    }

    public static class Flat
    extends ID {
        Map<String, List<ClassHier.InhrtPair>> inhrt;

        public Flat(Map<String, List<ClassHier.InhrtPair>> iht) {
            this.inhrt = iht;
        }

        public TypeDef combine(TypeDef td) {
            return td;
        }

        public ClassDef combine(ClassDef cd, DoGen g, ident n2, TypeDefParams ps, PESubtypeList sts2, FieldList fs, Impl i) {
            return new ClassDef(g, n2, ps, sts2, fs.append(ClassHier.superFieldsAndSyntax(ps.toList(), this.inhrt, "" + n2).foldr(new List.Fold<FieldOrSyntax, FieldList>(){

                @Override
                public FieldList fold(FieldOrSyntax f, FieldList r2) {
                    return r2.push(f);
                }
            }, new FieldEmpty())), i);
        }

        public Empty<TypeDef> combine(Empty<TypeDef> e2) {
            return e2;
        }

        public List<TypeDef> combine(Cons<TypeDef> l2, TypeDef f, List<TypeDef> r2) {
            return r2.push(f);
        }
    }

    static class JustTypes
    extends TU<List<TypeDef>> {
        JustTypes() {
        }

        @Override
        public List<TypeDef> combine() {
            return List.create();
        }

        @Override
        public List<TypeDef> fold(List<TypeDef> a, List<TypeDef> b) {
            return a.append((TypeDef)((Object)b));
        }

        List<TypeDef> combine(TypeDef t) {
            return ((List)this.combine()).push(t);
        }
    }

    static class LoadException
    extends RuntimeException {
        public LoadException(String s2) {
            super(s2);
        }

        public LoadException(Throwable e2) {
            super(e2);
        }
    }

    static abstract class Loader<X>
    extends List.Map<String, X> {
        Loader() {
        }

        @Override
        public X map(String n2) {
            try {
                Class<?> c2 = Type.classForName(n2);
                return this.instance(c2);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        abstract X instance(Class<?> var1) throws Exception;
    }

    static class OptStart
    extends List.Pred<String> {
        String start;

        OptStart(String s2) {
            this.start = s2;
        }

        @Override
        public boolean huh(String s2) {
            return s2.startsWith(this.start);
        }

        static int index(List<String> l2, String start2) {
            return l2.index(new OptStart(start2));
        }
    }

    static class PCDGPLoad
    extends Loader<PCDGPFunc> {
        PCDGPLoad() {
        }

        @Override
        PCDGPFunc instance(Class<?> c2) throws Exception {
            if (PCDGPFunc.class.isAssignableFrom(c2)) {
                DemFGenMain.p(c2.getSimpleName() + ", ");
                Constructor<?> constr = c2.getConstructor(List.class);
                return (PCDGPFunc)constr.newInstance(List.create());
            }
            throw new LoadException("Unknown PCDGPFunc");
        }
    }

    public static class Subst
    extends TP {
        public static String lookup(ident name2, List<StrLTrip.StrPair> env) {
            FIdent find = new FIdent(name2);
            if (env.contains(find)) {
                return env.find((List.Pred<StrLTrip.StrPair>)find).b;
            }
            return name2.toString();
        }

        TypeUse combine(TypeUse t, ident name2, EmptyUseParams ps, List<StrLTrip.StrPair> env) {
            return TypeUse.makeType(Subst.lookup(name2, env));
        }

        NameDef combine(NameDef d2, ident i, Bound b, List<StrLTrip.StrPair> env) {
            return new NameDef(new ident(ClassGen.unlocal(Subst.lookup(i, env))), b);
        }
    }
}

