/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.compose;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.compose.Functor;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.util.Option;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

public class CompTraversal {
    Control bypass;
    Functor[] funcs;
    int length;
    private static int indent = 0;

    public CompTraversal(Functor ... fs) {
        this(fs, Control.everywhere());
    }

    public CompTraversal(Functor[] fs, Control c2) {
        this.bypass = c2;
        this.funcs = fs;
        this.length = fs.length;
    }

    public CompTraversal(FC ... fs) {
        this(fs, Control.everywhere());
    }

    public CompTraversal(FC[] fs, Control c2) {
        this((Functor[])new Traversal(new ID(){

            Functor combine(FC f) {
                return new Functor(f);
            }
        }, Control.builtins(FC.class)).traverse(fs), c2);
    }

    public <T> T traverseLast(Object o) {
        return (T)this.traverse(o, Option.none())[this.length - 1];
    }

    public <T> T traverseLast(Object o, Object arg) {
        return (T)this.traverse(o, Option.some(arg))[this.length - 1];
    }

    public Object[] traverse(Object o) {
        return this.traverse(o, Option.none());
    }

    public Object[] traverse(Object o, Object a) {
        return this.traverse(o, Option.some(a));
    }

    private static String indent() {
        return CompTraversal.indent(indent);
    }

    private static String indent(int i) {
        if (i == 0) {
            return "";
        }
        return " " + CompTraversal.indent(i - 1);
    }

    protected Object[] traverse(Object o, Option arg) {
        Object[] result;
        ++indent;
        Class<?> c2 = o.getClass();
        boolean hasArg = arg.some();
        List<Field> fl = Util.getFuncFields(c2);
        if (this.bypass.isBuiltIn(c2)) {
            result = this.applyF(o, arg);
        } else {
            Option narg = hasArg ? Option.some(this.funcs[0].applyAugment(new Object[]{o, arg.get()})) : arg;
            Object[][] tret = new Object[fl.length()][];
            int i = 0;
            while (i < fl.length()) {
                try {
                    Field f = fl.lookup(i);
                    Object fld = f.get(o);
                    if (fld == null) {
                        if (!Util.allowNull) {
                            Util.nullFieldError(f);
                        }
                    } else {
                        tret[i] = !this.bypass.skip(c2, f.getName()) ? this.traverse(fld, narg) : this.applyF(fld, narg);
                    }
                }
                catch (Exception e2) {
                    throw (RuntimeException)e2;
                }
                ++i;
            }
            result = this.applyB(o, tret, arg);
        }
        --indent;
        return result;
    }

    private Object[] applyF(Object o, Option arg) {
        Object[] res2 = new Object[this.length];
        res2[0] = this.funcs[0].applyBuilder(Util.addArg(new Object[]{o}, arg), true);
        int i = 1;
        while (i < this.length) {
            res2[i] = this.funcs[i].applyBuilder(new Object[]{o, res2[i - 1]}, true);
            ++i;
        }
        return res2;
    }

    private Object[] applyB(Object o, Object[][] r2, Option arg) {
        Object[] res2 = new Object[this.length];
        res2[0] = this.funcs[0].applyBuilder(this.make(o, r2, 0, arg), false);
        int i = 1;
        while (i < this.length) {
            res2[i] = this.funcs[i].applyBuilder(this.make(o, r2, i, Option.some(res2[i - 1])), false);
            ++i;
        }
        return res2;
    }

    private Object[] make(Object targ2, Object[][] r2, int idx, Option arg) {
        int max = r2.length + 1 + (arg.some() ? 1 : 0);
        Object[] ret2 = new Object[max];
        ret2[0] = targ2;
        int i = 0;
        while (i < r2.length) {
            ret2[i + 1] = r2[i][idx];
            ++i;
        }
        if (arg.some()) {
            ret2[max - 1] = arg.get();
        }
        return ret2;
    }
}

