/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.batch;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.FC;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.batch.classes.ContextType;
import edu.neu.ccs.demeterf.batch.classes.ExtraArgs;
import edu.neu.ccs.demeterf.batch.classes.TRVDef;
import edu.neu.ccs.demeterf.batch.classes.TRVFile;
import edu.neu.ccs.demeterf.batch.classes.TravControl;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.demfgen.ClassHier;
import edu.neu.ccs.demeterf.demfgen.DemFGenMain;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.IncludeCDs;
import edu.neu.ccs.demeterf.demfgen.classes.CDFile;
import edu.neu.ccs.demeterf.demfgen.classes.Impl;
import edu.neu.ccs.demeterf.demfgen.classes.NEPkgList;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.inline.Inline;
import edu.neu.ccs.demeterf.inline.SubTyping;
import edu.neu.ccs.demeterf.inline.classes.TypeError;
import edu.neu.ccs.demeterf.lib.Cons;
import edu.neu.ccs.demeterf.lib.Empty;
import edu.neu.ccs.demeterf.lib.List;
import edu.neu.ccs.demeterf.lib.Map;
import edu.neu.ccs.demeterf.lib.Option;
import edu.neu.ccs.demeterf.lib.ident;
import edu.neu.ccs.demeterf.util.Util;
import java.io.FileNotFoundException;

public class GenBatch
extends FC {
    String header = "// ** Batch Generated with DemeterF\n";
    String pack;
    String imports;
    String dir;
    List<CDFile> CDs;
    SubTyping subs;
    List<TypeDef> types;
    List<String> opts;

    GenBatch(String p, String imp, String d2, List<CDFile> cds, SubTyping ss, List<TypeDef> ts, List<String> os) {
        this.pack = p;
        this.imports = imp;
        this.dir = d2;
        this.CDs = cds;
        this.subs = ss;
        this.types = ts;
        this.opts = os;
    }

    static void createTraversals(TRVFile trv, List<String> opts) throws FileNotFoundException {
        List<CDFile> CDs = DemFGenMain.resolveCDFile(trv.getCdfile());
        SubTyping subs = new SubTyping(CDs);
        List<ClassHier.InhrtPair> inhrtL = DemFGenMain.subtypes(CDs);
        Map<String, List<ClassHier.InhrtPair>> inhrtM = DemFGenMain.buildInhrtMap(inhrtL);
        List<TypeDef> types2 = DemFGenMain.removeSyntax(DemFGenMain.flatten(CDs, inhrtM));
        CDs = CDs.pop().push(CDs.top().updateImports(CDs.top().getImports().append(trv.getImports())));
        GenBatch func2 = new GenBatch("" + trv.getPack(), "" + IncludeCDs.allImports(CDs), trv.getOutdir(), CDs, subs, types2, opts);
        String body2 = (String)new Traversal(func2, Control.bypass(TRVDef.class)).traverse(trv.getTravs());
        func2.writeFactory(body2, trv.getFact().toString());
    }

    void writeFactory(String body2, String name2) {
        String cls = "public class " + name2 + "{\n" + body2 + "}\n";
        Util.writeFile(name2, "." + Diff.d.fileSuffix, cls, this.dir, String.valueOf(this.header) + this.pack + this.imports);
    }

    String combine(TRVDef trv, ident name2, Impl impl2, NEPkgList func2, Option<ContextType> ctx2, TravControl ctrl2, Option<ExtraArgs> extra2) {
        try {
            List args2 = List.create(GenBatch.makeArgs("--builtins", ctrl2.getBuiltins()), GenBatch.makeArgs("--bypass", ctrl2.getBypass()), GenBatch.makeArgs("--targ", ctx2.isSome() ? List.create(ctx2.inner().getTarg()) : List.create())).append((String)((Object)(extra2.isSome() ? extra2.inner().getArgs() : List.create())));
            String body2 = Inline.doGen("" + name2, impl2, this.CDs, this.pack, func2.print(), ctrl2.getStart().print(), this.types, this.subs, this.opts.append((String)((Object)args2)));
            Util.writeFile("" + name2, "." + Diff.d.fileSuffix, body2, this.dir, this.header);
            return "    public static " + name2 + " make" + name2 + "(" + ClassGen.unlocal(func2.toString()) + " f){ return new " + name2 + "(f); }\n";
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException("   " + fe.getMessage());
        }
        catch (TypeError te) {
            throw new TypeError("   " + te.getMessage() + "\n   In Generation for Traversal: " + trv.getName() + "\n                 With function: " + trv.getFunc().print());
        }
    }

    static String makeArgs(String opt, List<?> args2) {
        if (args2.isEmpty()) {
            return "";
        }
        String ret2 = String.valueOf(opt) + ":" + args2.toString(":", "");
        return ret2;
    }

    String combine(Cons<?> e2, String f, String r2) {
        return String.valueOf(f) + r2;
    }

    String combine(Empty<?> e2) {
        return "";
    }
}

